/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.wgblockreplacer.events;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import the_fireplace.wgblockreplacer.WGBlockReplacer;
import the_fireplace.wgblockreplacer.translation.SimpleTranslationUtil;

@Mod.EventBusSubscriber(modid="wgblockreplacer")
public class CommonEvents {
    private static final Random rand = new Random();
    private static boolean displayWarning = true;
    private static Map<Pair<World, Chunk>, Integer> timers = Maps.newConcurrentMap();

    private static int max(int ... args) {
        int max = Integer.MIN_VALUE;
        for (int arg : args) {
            if (arg <= max) continue;
            max = arg;
        }
        return max;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEvent(ChunkEvent.Load event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (!WGBlockReplacer.hasBeenReplaced(event.getChunk())) {
            if (WGBlockReplacer.ConfigValues.replaceblock.length != WGBlockReplacer.ConfigValues.replacewith.length || WGBlockReplacer.ConfigValues.replacewith.length != WGBlockReplacer.ConfigValues.replacewithmeta.length || WGBlockReplacer.ConfigValues.replacewithmeta.length != WGBlockReplacer.ConfigValues.replaceblockmeta.length || WGBlockReplacer.ConfigValues.replaceblockmeta.length != WGBlockReplacer.ConfigValues.replacepercent.length || WGBlockReplacer.ConfigValues.replacepercent.length != WGBlockReplacer.ConfigValues.dimension_list.length || WGBlockReplacer.ConfigValues.dimension_list.length != WGBlockReplacer.ConfigValues.multiplychance.length || WGBlockReplacer.ConfigValues.multiplychance.length != WGBlockReplacer.ConfigValues.miny.length || WGBlockReplacer.ConfigValues.miny.length != WGBlockReplacer.ConfigValues.maxy.length || WGBlockReplacer.ConfigValues.maxy.length != WGBlockReplacer.ConfigValues.biomefilter.length) {
                if (displayWarning) {
                    WGBlockReplacer.LOGGER.error(SimpleTranslationUtil.getStringTranslation("wgbr.array_length_mismatch", new Object[0]));
                    displayWarning = false;
                    int maxLength = CommonEvents.max(WGBlockReplacer.ConfigValues.replaceblock.length, WGBlockReplacer.ConfigValues.replacewith.length, WGBlockReplacer.ConfigValues.replacewithmeta.length, WGBlockReplacer.ConfigValues.replaceblockmeta.length, WGBlockReplacer.ConfigValues.replacepercent.length, WGBlockReplacer.ConfigValues.dimension_list.length, WGBlockReplacer.ConfigValues.multiplychance.length, WGBlockReplacer.ConfigValues.miny.length, WGBlockReplacer.ConfigValues.maxy.length, WGBlockReplacer.ConfigValues.biomefilter.length);
                    if (WGBlockReplacer.ConfigValues.replaceblock.length < maxLength) {
                        WGBlockReplacer.LOGGER.error(SimpleTranslationUtil.getStringTranslation("wgbr.mismatch_length", "replaceblock", WGBlockReplacer.ConfigValues.replaceblock.length, maxLength));
                    }
                    if (WGBlockReplacer.ConfigValues.replacewith.length < maxLength) {
                        WGBlockReplacer.LOGGER.error(SimpleTranslationUtil.getStringTranslation("wgbr.mismatch_length", "replacewith", WGBlockReplacer.ConfigValues.replacewith.length, maxLength));
                    }
                    if (WGBlockReplacer.ConfigValues.replacewithmeta.length < maxLength) {
                        WGBlockReplacer.LOGGER.error(SimpleTranslationUtil.getStringTranslation("wgbr.mismatch_length", "replacewithmeta", WGBlockReplacer.ConfigValues.replacewithmeta.length, maxLength));
                    }
                    if (WGBlockReplacer.ConfigValues.replaceblockmeta.length < maxLength) {
                        WGBlockReplacer.LOGGER.error(SimpleTranslationUtil.getStringTranslation("wgbr.mismatch_length", "replaceblockmeta", WGBlockReplacer.ConfigValues.replaceblockmeta.length, maxLength));
                    }
                    if (WGBlockReplacer.ConfigValues.replacepercent.length < maxLength) {
                        WGBlockReplacer.LOGGER.error(SimpleTranslationUtil.getStringTranslation("wgbr.mismatch_length", "replacepercent", WGBlockReplacer.ConfigValues.replacepercent.length, maxLength));
                    }
                    if (WGBlockReplacer.ConfigValues.dimension_list.length < maxLength) {
                        WGBlockReplacer.LOGGER.error(SimpleTranslationUtil.getStringTranslation("wgbr.mismatch_length", "dimension_list", WGBlockReplacer.ConfigValues.dimension_list.length, maxLength));
                    }
                    if (WGBlockReplacer.ConfigValues.multiplychance.length < maxLength) {
                        WGBlockReplacer.LOGGER.error(SimpleTranslationUtil.getStringTranslation("wgbr.mismatch_length", "multiplychance", WGBlockReplacer.ConfigValues.multiplychance.length, maxLength));
                    }
                    if (WGBlockReplacer.ConfigValues.miny.length < maxLength) {
                        WGBlockReplacer.LOGGER.error(SimpleTranslationUtil.getStringTranslation("wgbr.mismatch_length", "miny", WGBlockReplacer.ConfigValues.miny.length, maxLength));
                    }
                    if (WGBlockReplacer.ConfigValues.maxy.length < maxLength) {
                        WGBlockReplacer.LOGGER.error(SimpleTranslationUtil.getStringTranslation("wgbr.mismatch_length", "maxy", WGBlockReplacer.ConfigValues.maxy.length, maxLength));
                    }
                    if (WGBlockReplacer.ConfigValues.biomefilter.length < maxLength) {
                        WGBlockReplacer.LOGGER.error(SimpleTranslationUtil.getStringTranslation("wgbr.mismatch_length", "biomefilter", WGBlockReplacer.ConfigValues.biomefilter.length, maxLength));
                    }
                }
                if (WGBlockReplacer.ConfigValues.preventLoadOnFailure) {
                    CommonEvents.stopServer();
                }
                return;
            }
            if (WGBlockReplacer.ConfigValues.lateReplacement > 0) {
                CommonEvents.queueReplacement(event.getWorld(), event.getChunk());
            } else {
                CommonEvents.doReplacement(event.getWorld(), event.getChunk());
            }
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.ServerTickEvent event) {
        for (Map.Entry<Pair<World, Chunk>, Integer> p : timers.entrySet()) {
            if (p.getValue() <= 0) {
                CommonEvents.doReplacement((World)p.getKey().getLeft(), (Chunk)p.getKey().getRight());
                timers.remove(p.getKey());
                continue;
            }
            timers.put(p.getKey(), p.getValue() - 1);
        }
    }

    private static void queueReplacement(World world, Chunk chunk) {
        Pair p = Pair.of((Object)world, (Object)chunk);
        timers.putIfAbsent((Pair<World, Chunk>)p, WGBlockReplacer.ConfigValues.lateReplacement);
    }

    private static void doReplacement(World world, Chunk chunk) {
        for (int i = 0; i < WGBlockReplacer.ConfigValues.replaceblock.length; ++i) {
            Block fromBlock;
            Block toBlock;
            boolean doEvent = ArrayUtils.contains((Object[])WGBlockReplacer.ConfigValues.dimension_list[i].split(","), (Object)"*");
            for (String dim : WGBlockReplacer.ConfigValues.dimension_list[i].split(",")) {
                try {
                    if (world.field_73011_w.getDimension() != Integer.parseInt(dim)) continue;
                    doEvent = !doEvent;
                }
                catch (NumberFormatException e) {
                    if (dim.equals("*") || !world.field_73011_w.func_186058_p().func_186065_b().toLowerCase().equals(dim.toLowerCase())) continue;
                    doEvent = !doEvent;
                }
                break;
            }
            if (!doEvent) continue;
            if (!WGBlockReplacer.ConfigValues.biomeprecision) {
                doEvent = ArrayUtils.contains((Object[])WGBlockReplacer.ConfigValues.biomefilter[i].split(","), (Object)"*");
                for (String biome : WGBlockReplacer.ConfigValues.biomefilter[i].split(",")) {
                    try {
                        if (chunk.func_177411_a(new BlockPos(chunk.func_76632_l().func_180334_c(), 64, chunk.func_76632_l().func_180333_d()), world.func_72959_q()) != Biome.field_185377_q.func_82594_a((Object)new ResourceLocation(biome))) continue;
                        doEvent = !doEvent;
                        break;
                    }
                    catch (Exception e) {
                        if (biome.equals("*")) continue;
                        if (displayWarning) {
                            WGBlockReplacer.LOGGER.error(SimpleTranslationUtil.getStringTranslation("wgbr.biome_not_found", biome));
                            displayWarning = false;
                        }
                        if (!WGBlockReplacer.ConfigValues.preventLoadOnFailure) continue;
                        CommonEvents.stopServer();
                    }
                }
                if (!doEvent) continue;
            }
            if ((toBlock = Block.func_149684_b((String)WGBlockReplacer.ConfigValues.replacewith[i])) == (fromBlock = Block.func_149684_b((String)WGBlockReplacer.ConfigValues.replaceblock[i])) && WGBlockReplacer.ConfigValues.replaceblockmeta == WGBlockReplacer.ConfigValues.replacewithmeta) continue;
            if (fromBlock == null) {
                if (displayWarning) {
                    WGBlockReplacer.LOGGER.error(SimpleTranslationUtil.getStringTranslation("wgbr.replaceblock_not_found", WGBlockReplacer.ConfigValues.replaceblock[i]));
                    displayWarning = false;
                }
                if (!WGBlockReplacer.ConfigValues.preventLoadOnFailure) continue;
                CommonEvents.stopServer();
                continue;
            }
            if (toBlock == null) {
                if (displayWarning) {
                    WGBlockReplacer.LOGGER.error(SimpleTranslationUtil.getStringTranslation("wgbr.replacewith_not_found", WGBlockReplacer.ConfigValues.replacewith[i]));
                    displayWarning = false;
                }
                if (!WGBlockReplacer.ConfigValues.preventLoadOnFailure) continue;
                CommonEvents.stopServer();
                continue;
            }
            if (displayWarning && WGBlockReplacer.ConfigValues.replaceblockmeta[i] < -1 || WGBlockReplacer.ConfigValues.replaceblockmeta[i] > 15) {
                WGBlockReplacer.LOGGER.error(SimpleTranslationUtil.getStringTranslation("wgbr.replaceblockmeta_out_of_range", WGBlockReplacer.ConfigValues.replaceblockmeta[i]));
                displayWarning = false;
            }
            if (displayWarning && WGBlockReplacer.ConfigValues.replacewithmeta[i] < -1 || WGBlockReplacer.ConfigValues.replacewithmeta[i] > 15) {
                WGBlockReplacer.LOGGER.error(SimpleTranslationUtil.getStringTranslation("wgbr.replacewithmeta_out_of_range", WGBlockReplacer.ConfigValues.replacewithmeta[i]));
                displayWarning = false;
            }
            if (!WGBlockReplacer.ConfigValues.riskyblocks && WGBlockReplacer.isBlockRisky(toBlock)) {
                if (displayWarning) {
                    WGBlockReplacer.LOGGER.error(SimpleTranslationUtil.getStringTranslation("wgbr.disallowed_block", WGBlockReplacer.ConfigValues.replacewith[i]));
                    displayWarning = false;
                }
                if (WGBlockReplacer.ConfigValues.preventLoadOnFailure) {
                    CommonEvents.stopServer();
                }
                toBlock = Blocks.field_150348_b;
            }
            IBlockState fromState = WGBlockReplacer.ConfigValues.replaceblockmeta[i] == -1 ? fromBlock.func_176223_P() : fromBlock.func_176203_a(WGBlockReplacer.ConfigValues.replaceblockmeta[i]);
            IBlockState toState = WGBlockReplacer.ConfigValues.replacewithmeta[i] == -1 ? toBlock.func_176223_P() : toBlock.func_176203_a(WGBlockReplacer.ConfigValues.replacewithmeta[i]);
            int chunkNum = 0;
            for (ExtendedBlockStorage storage : chunk.func_76587_i()) {
                if (storage != null) {
                    for (int x = 0; x < 16; ++x) {
                        for (int y = 0; y < 16; ++y) {
                            for (int z = 0; z < 16; ++z) {
                                if (!storage.func_177485_a(x, y, z).equals(fromState) || WGBlockReplacer.ConfigValues.miny[i] > chunkNum * 16 + y || WGBlockReplacer.ConfigValues.maxy[i] < chunkNum * 16 + y) continue;
                                double d = rand.nextDouble();
                                int n = WGBlockReplacer.ConfigValues.multiplychance[i] ? chunkNum * 16 + y : 1;
                                if (!(d * (double)n <= WGBlockReplacer.ConfigValues.replacepercent[i])) continue;
                                if (WGBlockReplacer.ConfigValues.biomeprecision) {
                                    doEvent = ArrayUtils.contains((Object[])WGBlockReplacer.ConfigValues.biomefilter[i].split(","), (Object)"*");
                                    for (String biome : WGBlockReplacer.ConfigValues.biomefilter[i].split(",")) {
                                        try {
                                            if (chunk.func_177411_a(new BlockPos(x, y, z), world.func_72959_q()) != Biome.field_185377_q.func_82594_a((Object)new ResourceLocation(biome))) continue;
                                            doEvent = !doEvent;
                                            break;
                                        }
                                        catch (Exception e) {
                                            if (biome.equals("*")) continue;
                                            if (displayWarning) {
                                                WGBlockReplacer.LOGGER.error(SimpleTranslationUtil.getStringTranslation("wgbr.biome_not_found", biome));
                                                displayWarning = false;
                                            }
                                            if (!WGBlockReplacer.ConfigValues.preventLoadOnFailure) continue;
                                            CommonEvents.stopServer();
                                        }
                                    }
                                    if (!doEvent) continue;
                                    storage.func_177484_a(x, y, z, toState);
                                    continue;
                                }
                                storage.func_177484_a(x, y, z, toState);
                            }
                        }
                    }
                }
                ++chunkNum;
            }
            chunk.func_76630_e();
        }
        WGBlockReplacer.setReplaced(chunk);
    }

    private static void stopServer() {
        FMLCommonHandler.instance().getMinecraftServerInstance().func_71260_j();
        throw new RuntimeException(SimpleTranslationUtil.getStringTranslation("wgbr.shutdown", new Object[0]));
    }
}

