/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.wgblockreplacer.translation;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import the_fireplace.wgblockreplacer.WGBlockReplacer;

public class BRLanguageMap {
    private static final Pattern NUMERIC_VARIABLE_PATTERN = Pattern.compile("%(\\d+\\$)?[\\d\\.]*[df]");
    private static final Splitter EQUAL_SIGN_SPLITTER = Splitter.on((char)'=').limit(2);
    private static final BRLanguageMap instance = new BRLanguageMap(WGBlockReplacer.ConfigValues.locale);
    private final Map<String, String> languageList = Maps.newHashMap();

    BRLanguageMap(String locale) {
        InputStream inputstream = BRLanguageMap.class.getResourceAsStream("/assets/wgblockreplacer/lang/" + locale + ".lang");
        BRLanguageMap.inject(this, inputstream);
    }

    public static void inject(InputStream inputstream) {
        BRLanguageMap.inject(instance, inputstream);
    }

    private static void inject(BRLanguageMap inst, InputStream inputstream) {
        Map<String, String> map = BRLanguageMap.parseLangFile(inputstream);
        inst.languageList.putAll(map);
    }

    private static Map<String, String> parseLangFile(InputStream inputstream) {
        HashMap table = Maps.newHashMap();
        try {
            inputstream = BRLanguageMap.loadLanguage(table, inputstream);
            if (inputstream == null) {
                return table;
            }
            for (String s : IOUtils.readLines((InputStream)inputstream, (Charset)StandardCharsets.UTF_8)) {
                String[] astring;
                if (s.isEmpty() || s.charAt(0) == '#' || (astring = (String[])Iterables.toArray((Iterable)EQUAL_SIGN_SPLITTER.split((CharSequence)s), String.class)) == null || astring.length != 2) continue;
                String s1 = astring[0];
                String s2 = NUMERIC_VARIABLE_PATTERN.matcher(astring[1]).replaceAll("%$1s");
                table.put(s1, s2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return table;
    }

    static BRLanguageMap getInstance() {
        return instance;
    }

    synchronized String translateKeyFormat(String key, Object ... format) {
        String s = this.tryTranslateKey(key);
        try {
            return String.format(s, format);
        }
        catch (IllegalFormatException e) {
            return "Format error: " + s;
        }
    }

    private String tryTranslateKey(String key) {
        String s = this.languageList.get(key);
        return s == null ? key : s;
    }

    synchronized boolean isKeyTranslated(String key) {
        return this.languageList.containsKey(key);
    }

    @Nullable
    private static InputStream loadLanguage(Map<String, String> table, InputStream inputstream) throws IOException {
        byte[] data = IOUtils.toByteArray((InputStream)inputstream);
        boolean isEnhanced = false;
        for (String line : IOUtils.readLines((InputStream)new ByteArrayInputStream(data), (Charset)StandardCharsets.UTF_8)) {
            if (line.isEmpty() || line.charAt(0) != '#' || !(line = line.substring(1).trim()).equals("PARSE_ESCAPES")) continue;
            isEnhanced = true;
            break;
        }
        if (!isEnhanced) {
            return new ByteArrayInputStream(data);
        }
        Properties props = new Properties();
        props.load(new InputStreamReader((InputStream)new ByteArrayInputStream(data), StandardCharsets.UTF_8));
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            table.put((String)e.getKey(), (String)e.getValue());
        }
        props.clear();
        return null;
    }
}

