/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.handlers;

import appeng.api.AEApi;
import appeng.api.features.IInscriberRecipeBuilder;
import appeng.api.features.IInscriberRegistry;
import appeng.api.features.InscriberProcessType;
import appeng.recipes.IAERecipeFactory;
import appeng.recipes.factories.recipes.PartRecipeFactory;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.JsonContext;

public class InscriberHandler
implements IAERecipeFactory {
    @Override
    public void register(JsonObject json, JsonContext ctx) {
        ItemStack result = PartRecipeFactory.getResult(json, ctx);
        String mode = JsonUtils.func_151200_h((JsonObject)json, (String)"mode");
        JsonObject ingredients = JsonUtils.func_152754_s((JsonObject)json, (String)"ingredients");
        List<ItemStack> middle = Arrays.asList(CraftingHelper.getIngredient((JsonElement)ingredients.get("middle"), (JsonContext)ctx).func_193365_a());
        ItemStack[] top = new ItemStack[]{null};
        if (ingredients.has("top")) {
            top = CraftingHelper.getIngredient((JsonElement)JsonUtils.func_152754_s((JsonObject)ingredients, (String)"top"), (JsonContext)ctx).func_193365_a();
        }
        ItemStack[] bottom = new ItemStack[]{null};
        if (ingredients.has("bottom")) {
            bottom = CraftingHelper.getIngredient((JsonElement)JsonUtils.func_152754_s((JsonObject)ingredients, (String)"bottom"), (JsonContext)ctx).func_193365_a();
        }
        IInscriberRegistry reg = AEApi.instance().registries().inscriber();
        for (int i = 0; i < top.length; ++i) {
            for (int j = 0; j < bottom.length; ++j) {
                IInscriberRecipeBuilder builder = reg.builder();
                builder.withOutput(result);
                builder.withProcessType("press".equals(mode) ? InscriberProcessType.PRESS : InscriberProcessType.INSCRIBE);
                builder.withInputs(middle);
                if (top[i] != null) {
                    builder.withTopOptional(top[i]);
                }
                if (bottom[j] != null) {
                    builder.withBottomOptional(bottom[j]);
                }
                reg.addRecipe(builder.build());
            }
        }
    }
}

