/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.arcaneworld.crafting.ritual;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;
import party.lemons.arcaneworld.util.ArcaneWorldUtil;

public abstract class Ritual
extends IForgeRegistryEntry.Impl<Ritual> {
    private final List<Ingredient> ingredients = new ArrayList<Ingredient>();
    private boolean empty = false;
    private String unlocName;

    public Ritual(Ingredient ... ingredients) {
        int i;
        for (i = 0; i < 5; ++i) {
            this.ingredients.add(Ingredient.field_193370_a);
        }
        for (i = 0; i < ingredients.length; ++i) {
            this.ingredients.set(i, ingredients[i]);
        }
    }

    public Ritual setEmpty() {
        this.empty = true;
        return this;
    }

    public Ritual setTranslationKey(String key) {
        this.unlocName = key;
        return this;
    }

    public String getTranslationKey() {
        return this.unlocName;
    }

    public boolean matches(NonNullList<ItemStack> inputs) {
        if (this.isEmpty()) {
            return false;
        }
        ArrayList<Ingredient> ingreds = new ArrayList<Ingredient>(this.ingredients);
        ArrayList<Object> inputList = new ArrayList<Object>();
        for (int i = 0; i < inputs.size(); ++i) {
            inputList.add(inputs.get(i));
        }
        inputList.removeIf(ItemStack::func_190926_b);
        ingreds.removeIf(is -> is == Ingredient.field_193370_a);
        if (ingreds.size() != inputList.size()) {
            return false;
        }
        for (Ingredient ingredient : ingreds) {
            int removeIndex = -1;
            for (int i = 0; i < inputList.size(); ++i) {
                if (!ArcaneWorldUtil.ingredientMatch(ingredient, (ItemStack)inputList.get(i))) continue;
                removeIndex = i;
                break;
            }
            if (removeIndex == -1) {
                return false;
            }
            inputList.remove(removeIndex);
        }
        return true;
    }

    public abstract void onActivate(@Nonnull World var1, @Nonnull BlockPos var2, EntityPlayer var3, ItemStack ... var4);

    public boolean isEmpty() {
        return this.empty;
    }

    public boolean canDrop() {
        return true;
    }

    public List<Ingredient> getRequiredItems() {
        return this.ingredients;
    }
}

