/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.arcaneworld.crafting.ritual.impl;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ITeleporter;
import party.lemons.arcaneworld.config.ArcaneWorldConfig;
import party.lemons.arcaneworld.crafting.ritual.Ritual;
import party.lemons.arcaneworld.gen.dungeon.ArenaGenerator;
import party.lemons.arcaneworld.gen.dungeon.dimension.TeleporterDungeon;

public class RitualArena
extends Ritual {
    private final Class<? extends Entity> entityClass;

    public RitualArena(Class<? extends Entity> entityClass, Ingredient ... ingredients) {
        super(ingredients);
        this.entityClass = entityClass;
    }

    @Override
    public void onActivate(@Nonnull World world, @Nonnull BlockPos pos, EntityPlayer player, ItemStack ... items) {
        WorldServer ws = (WorldServer)world;
        TeleporterArena teleporter = new TeleporterArena(ws, this.entityClass);
        List players = world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(pos).func_72314_b(5.0, 5.0, 5.0));
        players.forEach(p -> p.changeDimension(ArcaneWorldConfig.DUNGEONS.DIM_ID, (ITeleporter)teleporter));
    }

    public static class TeleporterArena
    extends TeleporterDungeon {
        private final Class<? extends Entity> entityClass;

        public TeleporterArena(WorldServer worldIn, Class<? extends Entity> entityClass) {
            super(worldIn);
            this.entityClass = entityClass;
        }

        @Override
        public void doGeneration(World world) {
            this.hasGenerated = true;
            ArenaGenerator.generate(world, this.offsetPos);
            Entity ent = null;
            try {
                ent = this.entityClass.getConstructor(World.class).newInstance(world);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (ent != null) {
                ent.func_184211_a("arena_entity");
                ent.func_70107_b((double)(this.offsetPos.func_177958_n() + 16), (double)this.offsetPos.func_177981_b(13).func_177956_o(), (double)(this.offsetPos.func_177952_p() + 16));
                world.func_72838_d(ent);
                if (ent instanceof EntityWither) {
                    ((EntityWither)ent).func_82206_m();
                }
            }
        }

        @Override
        public double getTeleportOffsetX() {
            return 16.5;
        }

        @Override
        public double getTeleportOffsetZ() {
            return 5.0;
        }
    }
}

