/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.arcaneworld.entity;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityEvoker;
import net.minecraft.entity.monster.EntityIllusionIllager;
import net.minecraft.entity.monster.EntityVindicator;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import party.lemons.arcaneworld.config.ArcaneWorldConfig;
import party.lemons.arcaneworld.config.ConfigEntitySpawn;
import party.lemons.arcaneworld.entity.EntityOvergrownSheep;
import party.lemons.arcaneworld.entity.EntityRift;

@Mod.EventBusSubscriber(modid="arcaneworld")
public class ArcaneWorldEntities {
    private static int ID = 0;

    @SubscribeEvent
    public static void onRegisterEntity(RegistryEvent.Register<EntityEntry> event) {
        event.getRegistry().register((IForgeRegistryEntry)EntityEntryBuilder.create().name("Rift").entity(EntityRift.class).id(new ResourceLocation("arcaneworld", "rift"), ID++).tracker(64, 3, false).build());
        event.getRegistry().register((IForgeRegistryEntry)EntityEntryBuilder.create().name("Overgrown Sheep").entity(EntityOvergrownSheep.class).id(new ResourceLocation("arcaneworld", "overgrown_sheep"), ID++).tracker(80, 3, true).build());
    }

    public static void init() {
        List<Biome> biomesList = ForgeRegistries.BIOMES.getValuesCollection().stream().filter(b -> !BiomeDictionary.getTypes((Biome)b).contains(BiomeDictionary.Type.NETHER) && !BiomeDictionary.getTypes((Biome)b).contains(BiomeDictionary.Type.END)).collect(Collectors.toList());
        Biome[] biomes = biomesList.toArray(new Biome[biomesList.size()]);
        ConfigEntitySpawn illusionerSpawn = ArcaneWorldConfig.ENTITIES.ILLUSIONER_SPAWN;
        ConfigEntitySpawn vindicatorSpawn = ArcaneWorldConfig.ENTITIES.VINDICATOR_SPAWN;
        ConfigEntitySpawn evokerSpawn = ArcaneWorldConfig.ENTITIES.EVOKER_SPAWN;
        if (illusionerSpawn.enabled) {
            EntityRegistry.addSpawn(EntityIllusionIllager.class, (int)illusionerSpawn.rarity, (int)illusionerSpawn.min, (int)illusionerSpawn.max, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])biomes);
        }
        if (vindicatorSpawn.enabled) {
            EntityRegistry.addSpawn(EntityVindicator.class, (int)vindicatorSpawn.rarity, (int)vindicatorSpawn.min, (int)vindicatorSpawn.max, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])biomes);
        }
        if (evokerSpawn.enabled) {
            EntityRegistry.addSpawn(EntityEvoker.class, (int)evokerSpawn.rarity, (int)evokerSpawn.min, (int)evokerSpawn.max, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])biomes);
        }
    }
}

