/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.arcaneworld.gen.dungeon.generation;

import java.util.Random;

public enum Direction {
    NORTH(0, -1),
    SOUTH(0, 1),
    EAST(1, 0),
    WEST(-1, 0);

    private final int x;
    private final int y;
    private static Random RANDOM;

    private Direction(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public boolean isHorizontal() {
        return this.x != 0;
    }

    public boolean isVertical() {
        return this.y != 0;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public static Direction random() {
        return Direction.values()[RANDOM.nextInt(Direction.values().length)];
    }

    public Direction opposite() {
        switch (this) {
            case NORTH: {
                return SOUTH;
            }
            case SOUTH: {
                return NORTH;
            }
            case EAST: {
                return WEST;
            }
            case WEST: {
                return EAST;
            }
        }
        return null;
    }

    static {
        RANDOM = new Random();
    }
}

