/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.arcaneworld.handler;

import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.AbstractIllager;
import net.minecraft.entity.monster.EntityEvoker;
import net.minecraft.init.Items;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import party.lemons.arcaneworld.config.ArcaneWorldConfig;
import party.lemons.arcaneworld.gen.dungeon.dimension.DungeonDimension;
import party.lemons.arcaneworld.gen.dungeon.dimension.TeleporterDungeonReturn;
import party.lemons.arcaneworld.util.ArcaneWorldUtil;
import party.lemons.arcaneworld.util.capabilities.IRitualCoordinate;
import party.lemons.arcaneworld.util.capabilities.RitualCoordinateProvider;

@Mod.EventBusSubscriber(modid="arcaneworld")
public final class ArcaneWorldGeneralEventHandler {
    @SubscribeEvent
    public static void onEntityDrop(LivingDropsEvent event) {
        if (ArcaneWorldConfig.ENTITIES.EVOKER_SPAWN.enabled && event.getEntity() instanceof EntityEvoker) {
            event.getDrops().removeIf(e -> e.func_92059_d().func_77973_b() == Items.field_190929_cY && event.getEntity().field_70170_p.field_73012_v.nextInt(100) < 95);
        }
        if (event.getEntity() instanceof AbstractIllager) {
            Entity e2 = event.getEntity();
            if (e2.field_70170_p.field_73012_v.nextInt(ArcaneWorldConfig.ENTITIES.SCROLL_CHANCE) == 0) {
                EntityItem item = new EntityItem(e2.field_70170_p, e2.field_70165_t, e2.field_70163_u, e2.field_70161_v, ArcaneWorldUtil.getRandomRitualScrollForDrop(e2.field_70170_p.field_73012_v));
                event.getDrops().add(item);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityTick(TickEvent.PlayerTickEvent event) {
        if (event.player.field_70170_p.field_73011_w.getDimension() == DungeonDimension.TYPE.func_186068_a() && event.player.field_70163_u < 10.0) {
            event.player.field_70143_R = 0.0f;
            event.player.func_146105_b((ITextComponent)new TextComponentString("You experienced a bug in Arcane World, please report this on the Curse page!"), false);
            if (!event.player.field_70170_p.field_72995_K) {
                int returnDim = ((IRitualCoordinate)event.player.getCapability(RitualCoordinateProvider.RITUAL_COORDINATE_CAPABILITY, null)).getDim();
                event.player.changeDimension(returnDim, (ITeleporter)new TeleporterDungeonReturn((WorldServer)event.player.field_70170_p));
            }
        }
    }
}

