/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.arcaneworld.handler.ticker;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import party.lemons.arcaneworld.ArcaneWorld;
import party.lemons.arcaneworld.network.MessageUpdateBiomeArea;
import party.lemons.lemonlib.ticker.ITicker;

public class TickerSetBiome
implements ITicker {
    private World world;
    private Biome biome;
    private BlockPos pos;
    private int radius;
    private int step;
    private int tick;
    private int dim;

    public TickerSetBiome(World world, Biome biome, BlockPos pos, int radius) {
        this.world = world;
        this.biome = biome;
        this.pos = pos;
        this.radius = radius;
        this.step = 0;
        this.dim = world.field_73011_w.getDimension();
        this.tick = 0;
    }

    public void update(World world) {
        if (this.tick % 3 == 0) {
            AxisAlignedBB bb = new AxisAlignedBB(this.pos).func_72314_b((double)this.step, 0.0, (double)this.step);
            int x = (int)bb.field_72340_a;
            while ((double)x < bb.field_72336_d) {
                int z = (int)bb.field_72339_c;
                while ((double)z < bb.field_72334_f) {
                    Chunk chunk = world.func_175726_f(new BlockPos(x, this.pos.func_177956_o(), z));
                    chunk.func_76605_m()[(z & 0xF) << 4 | x & 0xF] = (byte)Biome.func_185362_a((Biome)this.biome);
                    chunk.func_177427_f(true);
                    ++z;
                }
                ++x;
            }
            ArcaneWorld.NETWORK.sendToAllTracking((IMessage)new MessageUpdateBiomeArea(this.biome, bb), new NetworkRegistry.TargetPoint(this.getDimension(), (double)this.pos.func_177958_n(), (double)this.pos.func_177956_o(), (double)this.pos.func_177952_p(), 120.0));
            ++this.step;
        }
        ++this.tick;
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74768_a("dim", this.getDimension());
        tags.func_74768_a("radius", this.radius);
        tags.func_74778_a("biome", this.biome.getRegistryName().toString());
        tags.func_74782_a("pos", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.pos));
        tags.func_74768_a("step", this.step);
        return tags;
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        this.dim = tagCompound.func_74762_e("dim");
        this.radius = tagCompound.func_74762_e("radius");
        this.biome = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(tagCompound.func_74779_i("biome")));
        this.pos = NBTUtil.func_186861_c((NBTTagCompound)tagCompound.func_74775_l("pos"));
        this.step = tagCompound.func_74762_e("step");
    }

    public boolean isTaskFinished(World world) {
        return this.step == this.radius + 1;
    }

    public int getDimension() {
        return this.dim;
    }

    public boolean isUnique() {
        return false;
    }
}

