/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.arcaneworld.item;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import party.lemons.arcaneworld.item.IMolten;

@Mod.EventBusSubscriber(modid="arcaneworld")
public class ItemEventHandler {
    @SubscribeEvent
    public static void onItemDrops(BlockEvent.HarvestDropsEvent event) {
        if (event.getHarvester() == null || event.getWorld().field_72995_K) {
            return;
        }
        ItemStack stack = event.getHarvester().func_184614_ca();
        if (!event.isSilkTouching() && !stack.func_190926_b() && stack.func_77973_b() instanceof IMolten) {
            ItemEventHandler.handleMolten(stack, event.getHarvester(), event.getPos(), event.getState(), event.getWorld(), event.getDrops());
        }
    }

    private static void handleMolten(ItemStack stack, EntityPlayer harvester, BlockPos pos, IBlockState state, World world, List<ItemStack> drops) {
        IMolten molten = (IMolten)stack.func_77973_b();
        ArrayList<ItemStack> toRemove = new ArrayList<ItemStack>();
        ArrayList<ItemStack> toAdd = new ArrayList<ItemStack>();
        for (ItemStack drop : drops) {
            ItemStack result = molten.getSmeltResult(drop);
            if (result.func_190926_b()) continue;
            toRemove.add(drop);
            for (int i = 0; i < drop.func_190916_E(); ++i) {
                toAdd.add(result.func_77946_l());
            }
        }
        drops.removeAll(toRemove);
        drops.addAll(toAdd);
    }
}

