/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.arcaneworld.item.impl;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import party.lemons.arcaneworld.crafting.ArcaneWorldSpamTab;
import party.lemons.arcaneworld.gen.ArcaneWorldGen;
import party.lemons.arcaneworld.handler.ArcaneWorldSounds;
import party.lemons.arcaneworld.handler.ticker.TickerSetBiome;
import party.lemons.arcaneworld.item.impl.ItemModel;
import party.lemons.lemonlib.ticker.ITicker;
import party.lemons.lemonlib.ticker.TickerHandler;

public class ItemBiomeCrystal
extends ItemModel {
    private int radius;

    public ItemBiomeCrystal(int radius) {
        this.radius = radius;
        this.field_77777_bU = 1;
        this.func_77656_e(30);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (facing == EnumFacing.UP) {
            boolean success;
            if (world.field_72995_K) {
                return EnumActionResult.SUCCESS;
            }
            if (this.hasBiome(stack)) {
                success = this.setBiomeInWorld(world, stack, pos);
                if (success) {
                    this.setBiome(stack, null);
                }
            } else {
                success = this.takeBiomeFromWorld(world, stack, pos);
            }
            int cooldown = success ? 20 : 4;
            SoundEvent sound = success ? ArcaneWorldSounds.GENERAL_WOOSH : ArcaneWorldSounds.GENERAL_BREAK;
            stack.func_77972_a(success ? 1 : 0, (EntityLivingBase)player);
            world.func_184133_a(null, pos, sound, SoundCategory.PLAYERS, 1.0f, 0.75f + world.field_73012_v.nextFloat());
            player.func_184811_cZ().func_185145_a((Item)this, cooldown);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    protected boolean setBiomeInWorld(World world, ItemStack stack, BlockPos pos) {
        Biome biome = this.getBiome(stack);
        if (biome != world.func_180494_b(pos)) {
            this.setBiomeInWorld(world, biome, pos);
            return true;
        }
        return false;
    }

    protected boolean setBiomeInWorld(World world, Biome biome, BlockPos pos) {
        if (biome == null) {
            return false;
        }
        TickerHandler.addTicker((ITicker)new TickerSetBiome(world, biome, pos, this.radius), (int)world.field_73011_w.getDimension());
        return true;
    }

    protected boolean takeBiomeFromWorld(World world, ItemStack stack, BlockPos pos) {
        Biome biome = world.func_180494_b(pos);
        if (biome != ArcaneWorldGen.ARCANE_VOID) {
            this.setBiome(stack, biome);
            return this.setBiomeInWorld(world, ArcaneWorldGen.ARCANE_VOID, pos);
        }
        return false;
    }

    public boolean hasBiome(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return false;
        }
        return stack.func_77978_p().func_74764_b("biome");
    }

    @Nullable
    public Biome getBiome(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return null;
        }
        NBTTagCompound tags = stack.func_77978_p();
        if (tags.func_74764_b("biome")) {
            return (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(tags.func_74779_i("biome")));
        }
        return null;
    }

    public void setBiome(ItemStack stack, Biome biome) {
        NBTTagCompound tags = !stack.func_77942_o() ? new NBTTagCompound() : stack.func_77978_p();
        if (biome == null) {
            tags.func_82580_o("biome");
        } else {
            tags.func_74778_a("biome", biome.getRegistryName().toString());
        }
        stack.func_77982_d(tags);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        Biome biome = this.getBiome(stack);
        if (biome != null) {
            tooltip.add(TextFormatting.GOLD + biome.func_185359_l());
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)new ItemStack((Item)this));
            for (Biome biome : ForgeRegistries.BIOMES.getValuesCollection()) {
                if (biome.func_185363_b()) continue;
                ItemStack biomeStack = new ItemStack((Item)this);
                this.setBiome(biomeStack, biome);
                items.add((Object)biomeStack);
            }
        }
    }

    @Nullable
    public CreativeTabs func_77640_w() {
        return ArcaneWorldSpamTab.INSTANCE;
    }
}

