/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.helper;

import hellfirepvp.astralsorcery.common.crafting.helper.BasePlainRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapeMap;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapedRecipeSlot;
import java.util.Iterator;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class RecipeHelper {
    public static BasePlainRecipe getShapelessOreDictRecipe(ResourceLocation name, ItemStack output, NonNullList<Ingredient> craftingComponents) {
        return new ShapelessIngredientRecipe(name, output, craftingComponents);
    }

    public static BasePlainRecipe getShapedOredictRecipe(ResourceLocation name, ItemStack output, ShapeMap.Baked craftingComponents) {
        return new ShapedIngredientRecipe(name, output, craftingComponents);
    }

    public static class ShapedIngredientRecipe
    extends BasePlainRecipe {
        private final ItemStack out;
        private final ShapeMap.Baked grid;

        private ShapedIngredientRecipe(ResourceLocation name, ItemStack out, ShapeMap.Baked grid) {
            super(name);
            this.out = out;
            this.grid = grid;
        }

        public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
            for (int x = 0; x <= 3 - this.grid.getWidth(); ++x) {
                for (int y = 0; y <= 3 - this.grid.getHeight(); ++y) {
                    if (!this.checkMatch(inv, x, y)) continue;
                    return true;
                }
            }
            return false;
        }

        protected boolean checkMatch(InventoryCrafting inv, int startX, int startY) {
            for (int x = 0; x < 3; ++x) {
                for (int y = 0; y < 3; ++y) {
                    int subX = x - startX;
                    int subY = y - startY;
                    Ingredient target = Ingredient.field_193370_a;
                    if (subX >= 0 && subY >= 0 && subX < this.grid.getWidth() && subY < this.grid.getHeight()) {
                        ShapedRecipeSlot srs = ShapedRecipeSlot.getByRowColumnIndex(subY, subX);
                        target = (Ingredient)this.grid.get((Object)srs);
                    }
                    if (target.apply(inv.func_70463_b(x, y))) continue;
                    return false;
                }
            }
            return true;
        }

        public ItemStack func_77572_b(InventoryCrafting inv) {
            return this.out.func_77946_l();
        }

        public boolean func_194133_a(int width, int height) {
            return width >= this.grid.getWidth() && height >= this.grid.getHeight();
        }

        public ItemStack func_77571_b() {
            return this.out.func_77946_l();
        }

        public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
            return ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)inv);
        }

        public NonNullList<Ingredient> func_192400_c() {
            return this.grid.getRawIngredientList();
        }
    }

    public static class ShapelessIngredientRecipe
    extends BasePlainRecipe {
        private final ItemStack out;
        private final NonNullList<Ingredient> inputs;

        public ShapelessIngredientRecipe(ResourceLocation registryName, ItemStack out, NonNullList<Ingredient> inputs) {
            super(registryName);
            this.out = out;
            this.inputs = inputs;
        }

        public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
            NonNullList required = NonNullList.func_191196_a();
            required.addAll(this.inputs);
            for (int x = 0; x < inv.func_70302_i_(); ++x) {
                ItemStack slot = inv.func_70301_a(x);
                if (slot.func_190926_b()) continue;
                boolean inRecipe = false;
                Iterator req = required.iterator();
                while (req.hasNext()) {
                    if (!((Ingredient)req.next()).apply(slot)) continue;
                    inRecipe = true;
                    req.remove();
                    break;
                }
                if (inRecipe) continue;
                return false;
            }
            return required.isEmpty();
        }

        public ItemStack func_77572_b(InventoryCrafting inv) {
            return this.out.func_77946_l();
        }

        public boolean func_194133_a(int width, int height) {
            return width * height >= this.inputs.size();
        }

        public ItemStack func_77571_b() {
            return this.out.func_77946_l();
        }

        public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
            return ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)inv);
        }

        public NonNullList<Ingredient> func_192400_c() {
            return this.inputs;
        }
    }
}

