/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment;

import net.minecraft.init.Blocks;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="bewitchment", name="Bewitchment")
public class ModConfig {
    @Config.Comment(value={"Miscellaneous settings"})
    public static final Misc misc = new Misc();
    @Config.Comment(value={"World generation settings"})
    public static final WorldGen worldGen = new WorldGen();
    @Config.Comment(value={"Mob spawn settings"})
    public static final MobSpawns mobSpawns = new MobSpawns();
    @Config.Comment(value={"Compat Settings"})
    public static final Compat compat = new Compat();
    @Config.Comment(value={"Modifier Settings"})
    public static final Modifiers modifiers = new Modifiers();
    @Config.Comment(value={"Ael is banned"})
    public static final Maymays memes = new Maymays();

    @Mod.EventBusSubscriber(modid="bewitchment")
    private static class SyncConfig {
        private SyncConfig() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("bewitchment")) {
                ConfigManager.sync((String)"bewitchment", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class Compat {
        @Config.RequiresMcRestart
        @Config.Comment(value={"Enable replacing saplings with dynamic trees seeds upon planting (Must have DynamicTrees installed"})
        public boolean replaceSapling = true;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Enable world gen of dynamic Bewitchment trees instead of the regular trees"})
        public boolean genDynamic = true;
    }

    public static class Maymays {
        @Config.RequiresMcRestart
        @Config.Comment(value={"Decides whether or not the cats and dogs fortune will be enabled."})
        public boolean enableCatsAndDogsFortune = false;
        @Config.RequiresMcRestart
        @Config.Comment(value={"it is wednesday my dudes"})
        public boolean wednesday = false;
    }

    public static class Modifiers {
        @Config.RequiresMcRestart
        @Config.Comment(value={"Enable items from other mods to have silver bonuses"})
        public boolean silverBonuses = true;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Enable items from other mods to have cold iron bonuses"})
        public boolean coldIronBonuses = true;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Entities to be affected by silver"})
        public String[] silverWeakness = new String[]{"bewitchment:werewolf"};
        @Config.RequiresMcRestart
        @Config.Comment(value={"Entities to be affected by cold iron"})
        public String[] coldIronWeakness = new String[]{"minecraft:blaze", "minecraft:ghast", "minecraft:vex", "minecraft:enderman", "thaumcraft:pech", "thaumcraft:wisp", "bewitchment:black_dog", "bewitchment:ghost", "bewitchment:hellhound", "bewitchment:demon", "bewitchment:demoness", "bewitchment:imp"};
    }

    public static class MobSpawns {
        public final Lizard lizard = new Lizard();
        public final Owl owl = new Owl();
        public final Raven raven = new Raven();
        public final Snek snake = new Snek();
        public final Toad toad = new Toad();
        public final BlackDog blackDog = new BlackDog();
        public final Ghost ghost = new Ghost();
        public final Hellhound hellhound = new Hellhound();
        public final Feuerwurm feuerwurm = new Feuerwurm();
        public final Druden druden = new Druden();
        public final Cleaver cleaver = new Cleaver();
        public final Bafometyr bafometyr = new Bafometyr();
        public final Werewolf werewolf = new Werewolf();

        public static class Werewolf {
            @Config.Comment(value={"The list of BiomeDictionary types that the werewolf will spawn in."})
            public String[] werewolfBiomes = new String[]{BiomeDictionary.Type.FOREST.getName(), BiomeDictionary.Type.CONIFEROUS.getName(), BiomeDictionary.Type.SNOWY.getName(), BiomeDictionary.Type.SPOOKY.getName(), BiomeDictionary.Type.MAGICAL.getName()};
            @Config.Comment(value={"The weight chance for werewolves to spawn."})
            @Config.RangeInt(min=0, max=127)
            public int werewolfWeight = 1;
            @Config.Comment(value={"The minimum amount of werewolves to spawn at once."})
            @Config.RangeInt(min=0, max=127)
            public int werewolfMin = 0;
            @Config.Comment(value={"The maximum amount of werewolves to spawn at once."})
            @Config.RangeInt(min=0, max=127)
            public int werewolfMax = 4;
        }

        public static class Druden {
            @Config.Comment(value={"The list of BiomeDictionary types that the druden will spawn in."})
            public String[] drudenBiomes = new String[]{BiomeDictionary.Type.FOREST.getName(), BiomeDictionary.Type.DENSE.getName(), BiomeDictionary.Type.CONIFEROUS.getName(), BiomeDictionary.Type.MAGICAL.getName(), BiomeDictionary.Type.SPOOKY.getName()};
            @Config.Comment(value={"The weight chance for druden to spawn."})
            @Config.RangeInt(min=0, max=127)
            public int drudenWeight = 1;
            @Config.Comment(value={"The minimum amount of druden to spawn at once."})
            @Config.RangeInt(min=0, max=127)
            public int drudenMin = 0;
            @Config.Comment(value={"The maximum amount of druden to spawn at once."})
            @Config.RangeInt(min=0, max=127)
            public int drudenMax = 3;
        }

        public static class Bafometyr {
            @Config.Comment(value={"The list of BiomeDictionary types that the bafometyr will spawn in."})
            public String[] bafometyrBiomes = new String[]{BiomeDictionary.Type.NETHER.getName()};
            @Config.Comment(value={"The weight chance for a bafometyr to spawn."})
            @Config.RangeInt(min=0, max=127)
            public int bafometyrWeight = 1;
            @Config.Comment(value={"The minimum amount of bafometyrs to spawn at once."})
            @Config.RangeInt(min=0, max=127)
            public int bafometyrMin = 0;
            @Config.Comment(value={"The maximum amount of bafometyrs to spawn at once."})
            @Config.RangeInt(min=0, max=127)
            public int bafometyrMax = 1;
        }

        public static class Cleaver {
            @Config.Comment(value={"The list of BiomeDictionary types that the cleaver will spawn in."})
            public String[] cleaverBiomes = new String[]{BiomeDictionary.Type.NETHER.getName()};
            @Config.Comment(value={"The weight chance for a cleaver to spawn."})
            @Config.RangeInt(min=0, max=127)
            public int cleaverWeight = 1;
            @Config.Comment(value={"The minimum amount of cleavers to spawn at once."})
            @Config.RangeInt(min=0, max=127)
            public int cleaverMin = 0;
            @Config.Comment(value={"The maximum amount of cleavers to spawn at once."})
            @Config.RangeInt(min=0, max=127)
            public int cleaverMax = 1;
        }

        public static class Feuerwurm {
            @Config.Comment(value={"The list of BiomeDictionary types that the feuerwurm will spawn in."})
            public String[] feuerwurmBiomes = new String[]{BiomeDictionary.Type.NETHER.getName()};
            @Config.Comment(value={"The weight chance for feuerwurms to spawn."})
            @Config.RangeInt(min=0, max=127)
            public int feuerwurmWeight = 3;
            @Config.Comment(value={"The minimum amount of feuerwurms to spawn at once."})
            @Config.RangeInt(min=0, max=127)
            public int feuerwurmMin = 0;
            @Config.Comment(value={"The maximum amount of feuerwurms to spawn at once."})
            @Config.RangeInt(min=0, max=127)
            public int feuerwurmMax = 3;
        }

        public static class Hellhound {
            @Config.Comment(value={"The list of BiomeDictionary types that the hellhound will spawn in."})
            public String[] hellhoundBiomes = new String[]{BiomeDictionary.Type.NETHER.getName()};
            @Config.Comment(value={"The weight chance for hellhounds to spawn."})
            @Config.RangeInt(min=0, max=127)
            public int hellhoundWeight = 6;
            @Config.Comment(value={"The minimum amount of hellhounds to spawn at once."})
            @Config.RangeInt(min=0, max=127)
            public int hellhoundMin = 0;
            @Config.Comment(value={"The maximum amount of hellhounds to spawn at once."})
            @Config.RangeInt(min=0, max=127)
            public int hellhoundMax = 3;
        }

        public static class Ghost {
            @Config.Comment(value={"The list of BiomeDictionary types that the ghost will spawn in."})
            public String[] ghostBiomes = new String[]{BiomeDictionary.Type.PLAINS.getName(), BiomeDictionary.Type.WASTELAND.getName(), BiomeDictionary.Type.FOREST.getName(), BiomeDictionary.Type.SPOOKY.getName(), BiomeDictionary.Type.MAGICAL.getName()};
            @Config.Comment(value={"The weight chance for ghosts to spawn."})
            @Config.RangeInt(min=0, max=127)
            public int ghostWeight = 3;
            @Config.Comment(value={"The minimum amount of ghosts to spawn at once."})
            @Config.RangeInt(min=0, max=127)
            public int ghostMin = 0;
            @Config.Comment(value={"The maximum amount of ghosts to spawn at once."})
            @Config.RangeInt(min=0, max=127)
            public int ghostMax = 2;
        }

        public static class BlackDog {
            @Config.Comment(value={"The list of BiomeDictionary types that the black dog will spawn in."})
            public String[] blackDogBiomes = new String[]{BiomeDictionary.Type.PLAINS.getName(), BiomeDictionary.Type.WASTELAND.getName(), BiomeDictionary.Type.FOREST.getName(), BiomeDictionary.Type.SPOOKY.getName(), BiomeDictionary.Type.MAGICAL.getName()};
            @Config.Comment(value={"The weight chance for black dogs to spawn."})
            @Config.RangeInt(min=0, max=127)
            public int blackDogWeight = 3;
            @Config.Comment(value={"The minimum amount of black dogs to spawn at once."})
            @Config.RangeInt(min=0, max=127)
            public int blackDogMin = 0;
            @Config.Comment(value={"The maximum amount of black dogs to spawn at once."})
            @Config.RangeInt(min=0, max=127)
            public int blackDogMax = 3;
        }

        public static class Toad {
            @Config.Comment(value={"The list of BiomeDictionary types that the toad will spawn in."})
            public String[] toadBiomes = new String[]{BiomeDictionary.Type.SWAMP.getName(), BiomeDictionary.Type.WET.getName(), BiomeDictionary.Type.JUNGLE.getName()};
            @Config.Comment(value={"The weight chance for toads to spawn."})
            @Config.RangeInt(min=0, max=127)
            public int toadWeight = 20;
            @Config.Comment(value={"The minimum amount of toads to spawn at once."})
            @Config.RangeInt(min=0, max=127)
            public int toadMin = 0;
            @Config.Comment(value={"The maximum amount of toads to spawn at once."})
            @Config.RangeInt(min=0, max=127)
            public int toadMax = 4;
        }

        public static class Snek {
            @Config.Comment(value={"The list of BiomeDictionary types that the snake will spawn in."})
            public String[] snakeBiomes = new String[]{BiomeDictionary.Type.PLAINS.getName(), BiomeDictionary.Type.HILLS.getName(), BiomeDictionary.Type.SANDY.getName()};
            @Config.Comment(value={"The weight chance for snakes to spawn."})
            @Config.RangeInt(min=0, max=127)
            public int snakeWeight = 20;
            @Config.Comment(value={"The minimum amount of snakes to spawn at once."})
            @Config.RangeInt(min=0, max=127)
            public int snakeMin = 0;
            @Config.Comment(value={"The maximum amount of snakes to spawn at once."})
            @Config.RangeInt(min=0, max=127)
            public int snakeMax = 4;
        }

        public static class Raven {
            @Config.Comment(value={"The list of BiomeDictionary types that the raven will spawn in."})
            public String[] ravenBiomes = new String[]{BiomeDictionary.Type.PLAINS.getName(), BiomeDictionary.Type.WASTELAND.getName(), BiomeDictionary.Type.SPOOKY.getName()};
            @Config.Comment(value={"The weight chance for ravens to spawn."})
            @Config.RangeInt(min=0, max=127)
            public int ravenWeight = 20;
            @Config.Comment(value={"The minimum amount of ravens to spawn at once."})
            @Config.RangeInt(min=0, max=127)
            public int ravenMin = 0;
            @Config.Comment(value={"The maximum amount of ravens to spawn at once."})
            @Config.RangeInt(min=0, max=127)
            public int ravenMax = 4;
        }

        public static class Owl {
            @Config.Comment(value={"The list of BiomeDictionary types that the owl will spawn in."})
            public String[] owlBiomes = new String[]{BiomeDictionary.Type.FOREST.getName(), BiomeDictionary.Type.DENSE.getName(), BiomeDictionary.Type.SPOOKY.getName()};
            @Config.Comment(value={"The weight chance for owls to spawn."})
            @Config.RangeInt(min=0, max=127)
            public int owlWeight = 20;
            @Config.Comment(value={"The minimum amount of owls to spawn at once."})
            @Config.RangeInt(min=0, max=127)
            public int owlMin = 0;
            @Config.Comment(value={"The maximum amount of owls to spawn at once."})
            @Config.RangeInt(min=0, max=127)
            public int owlMax = 4;
        }

        public static class Lizard {
            @Config.Comment(value={"The list of BiomeDictionary types that the lizard will spawn in."})
            public String[] lizardBiomes = new String[]{BiomeDictionary.Type.FOREST.getName(), BiomeDictionary.Type.SWAMP.getName(), BiomeDictionary.Type.JUNGLE.getName()};
            @Config.Comment(value={"The weight chance for lizards to spawn."})
            @Config.RangeInt(min=0, max=127)
            public int lizardWeight = 6;
            @Config.Comment(value={"The minimum amount of lizards to spawn at once."})
            @Config.RangeInt(min=0, max=127)
            public int lizardMin = 0;
            @Config.Comment(value={"The maximum amount of lizards to spawn at once."})
            @Config.RangeInt(min=0, max=127)
            public int lizardMax = 2;
        }
    }

    public static class WorldGen {
        public final TreeGen treeGen = new TreeGen();
        public final OreGen oreGen = new OreGen();
        public final StructureGen structureGen = new StructureGen();
        @Config.Comment(value={"The dimensions that trees, ores, and coquina are allowed to spawn in."})
        public Integer[] worldGenWhitelist = new Integer[]{0};
        @Config.Comment(value={"Allow bewitchment structures to be generated in the OverWorld"})
        public boolean enableStructures = true;

        public static class StructureGen {
            @Config.Comment(value={"The chance for wickermen to generate"})
            @Config.RangeDouble(min=0.0, max=1.0)
            public double wickermanChance = 0.001;
            @Config.Comment(value={"The chance for a stone circle to generate"})
            @Config.RangeDouble(min=0.0, max=1.0)
            public double stonecircleChance = 0.001;
            @Config.Comment(value={"The chance for menhir to generate"})
            @Config.RangeDouble(min=0.0, max=1.0)
            public double menhirChance = 0.001;
            @Config.Comment(value={"The chance for a large cambion home to generate"})
            @Config.RangeDouble(min=0.0, max=1.0)
            public double cambionHomeChance = 0.001;
            @Config.Comment(value={"The chance for a medium cambion home to generate"})
            @Config.RangeDouble(min=0.0, max=1.0)
            public double cambionHomeMediumChance = 0.001;
        }

        public static class OreGen {
            @Config.Comment(value={"The size of silver ore veins."})
            @Config.RangeInt(min=0, max=127)
            public int silverSize = 7;
            @Config.Comment(value={"The chance for silver ore veins to spawn. 0 to disable."})
            @Config.RangeInt(min=0, max=127)
            public int silverChance = 12;
            @Config.Comment(value={"The minimum height for silver ore veins to spawn."})
            @Config.RangeInt(min=0, max=255)
            public int silverMin = 10;
            @Config.Comment(value={"The maximum height for silver ore veins to spawn."})
            @Config.RangeInt(min=0, max=255)
            public int silverMax = 128;
            @Config.Comment(value={"The size of salt ore veins."})
            @Config.RangeInt(min=0, max=127)
            public int saltSize = 5;
            @Config.Comment(value={"The chance for salt ore veins to spawn. 0 to disable."})
            @Config.RangeInt(min=0, max=127)
            public int saltChance = 10;
            @Config.Comment(value={"The minimum height for salt ore veins to spawn."})
            @Config.RangeInt(min=0, max=255)
            public int saltMin = 10;
            @Config.Comment(value={"The maximum height for salt ore veins to spawn."})
            @Config.RangeInt(min=0, max=255)
            public int saltMax = 120;
            @Config.Comment(value={"The size of amethyst ore veins."})
            @Config.RangeInt(min=0, max=127)
            public int amethystSize = 6;
            @Config.Comment(value={"The chance for amethyst ore veins to spawn. 0 to disable."})
            @Config.RangeInt(min=0, max=127)
            public int amethystChance = 2;
            @Config.Comment(value={"The minimum height for amethyst ore veins to spawn."})
            @Config.RangeInt(min=0, max=255)
            public int amethystMin = 10;
            @Config.Comment(value={"The maximum height for amethyst ore veins to spawn."})
            @Config.RangeInt(min=0, max=255)
            public int amethystMax = 42;
            @Config.Comment(value={"The size of garnet ore veins."})
            @Config.RangeInt(min=0, max=127)
            public int garnetSize = 6;
            @Config.Comment(value={"The chance for garnet ore veins to spawn. 0 to disable."})
            @Config.RangeInt(min=0, max=127)
            public int garnetChance = 2;
            @Config.Comment(value={"The minimum height for garnet ore veins to spawn."})
            @Config.RangeInt(min=0, max=255)
            public int garnetMin = 12;
            @Config.Comment(value={"The maximum height for garnet ore veins to spawn."})
            @Config.RangeInt(min=0, max=255)
            public int garnetMax = 42;
            @Config.Comment(value={"The size of opal ore veins."})
            @Config.RangeInt(min=0, max=127)
            public int opalSize = 6;
            @Config.Comment(value={"The chance for opal ore veins to spawn. 0 to disable."})
            @Config.RangeInt(min=0, max=127)
            public int opalChance = 2;
            @Config.Comment(value={"The minimum height for opal ore veins to spawn."})
            @Config.RangeInt(min=0, max=255)
            public int opalMin = 16;
            @Config.Comment(value={"The maximum height for opal ore veins to spawn."})
            @Config.RangeInt(min=0, max=255)
            public int opalMax = 42;
        }

        public static class TreeGen {
            @Config.Comment(value={"The biome IDs that Bewitchment trees are blacklisted from spawning"})
            public String[] treeGenBlacklist = new String[0];
            @Config.Comment(value={"The chance for cypress trees to spawn. Set to 0 to disable."})
            @Config.RangeDouble(min=0.0, max=1.0)
            public double cypressChance = 0.01;
            @Config.Comment(value={"The chance for elder trees to spawn. Set to 0 to disable."})
            @Config.RangeDouble(min=0.0, max=1.0)
            public double elderChance = 0.01;
            @Config.Comment(value={"The chance for juniper trees to spawn. Set to 0 to disable."})
            @Config.RangeDouble(min=0.0, max=1.0)
            public double juniperChance = 0.01;
        }
    }

    public static class Misc {
        @Config.Comment(value={"The list of blocks that the broom will sweep when right clicked on."})
        public String[] broomSweepables = new String[]{"tile.redstoneDust", "tile.bewitchment.glyph", "tile.bewitchment.salt_barrier"};
        @Config.Comment(value={"The list of blocks that the witches' cauldron will count as heat sources."})
        public String[] heatSources = new String[]{Blocks.field_150480_ab.func_149739_a(), Blocks.field_150353_l.func_149739_a(), Blocks.field_189877_df.func_149739_a(), "tile.bewitchment.hellfire", "tile.blazeBlock", "tile.nitor_white", "tile.nitor_orange", "tile.nitor_magenta", "tile.nitor_lightblue", "tile.nitor_yellow", "tile.nitor_lime", "tile.nitor_pink", "tile.nitor_gray", "tile.nitor_silver", "tile.nitor_cyan", "tile.nitor_purple", "tile.nitor_blue", "tile.nitor_brown", "tile.nitor_green", "tile.nitor_red", "tile.nitor_black"};
        @Config.Comment(value={"The amount of blocks an altar should scan per tick."})
        @Config.RangeInt(min=0, max=32767)
        public int altarScansPerTick = 64;
        @Config.Comment(value={"The maximum power a Grimoire Magia can have."})
        @Config.RangeInt(min=0)
        public int maxGrimoirePower = 1000;
        @Config.Comment(value={"The maximum damage a Skeleton Key can take."})
        @Config.RangeInt(min=0, max=128)
        public int maxSkeletonKeyUses = 10;
    }
}

