/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.api.message;

import com.bewitchment.Bewitchment;
import com.bewitchment.api.message.TarotInfo;
import com.bewitchment.api.registry.Tarot;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class TarotMessage
implements IMessage {
    private List<TarotInfo> infoList = new ArrayList<TarotInfo>();

    public TarotMessage() {
    }

    public TarotMessage(EntityPlayer player) {
        List valid = GameRegistry.findRegistry(Tarot.class).getValuesCollection().stream().filter(f -> f.isCounted(player)).collect(Collectors.toList());
        if (!valid.isEmpty()) {
            while (!valid.isEmpty() && this.infoList.size() < 4) {
                int i = player.func_70681_au().nextInt(valid.size());
                this.infoList.add(new TarotInfo((Tarot)((Object)valid.get(i)), player));
                valid.remove(i);
            }
        }
    }

    public void fromBytes(ByteBuf byteBuf) {
        this.infoList = TarotInfo.fromBuffer(byteBuf);
    }

    public void toBytes(ByteBuf byteBuf) {
        byteBuf.writeInt(this.infoList.size());
        for (TarotInfo info : this.infoList) {
            ByteBufUtils.writeUTF8String((ByteBuf)byteBuf, (String)info.getTexture().toString());
            byteBuf.writeBoolean(info.isReversed());
            byteBuf.writeInt(info.getNumber());
        }
    }

    public static class Handler
    implements IMessageHandler<TarotMessage, IMessage> {
        public IMessage onMessage(TarotMessage message, MessageContext ctx) {
            if (ctx.side.isClient()) {
                Bewitchment.proxy.handleTarot(message.infoList);
            }
            return null;
        }
    }
}

