/*
 * Decompiled with CFR 0.152.
 */
package quaternary.brokenwings.config;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import quaternary.brokenwings.BrokenWings;

public class ItemList
implements Iterable<Map.Entry<Item, ExtraConditions>> {
    private final Multimap<Item, ExtraConditions> entries;
    private static final ExtraConditions TRUE = new ExtraConditions();
    public static final String CONDITIONS_SEPARATOR = " ";
    public static final String META_CONDITION = "meta:";
    public static final String DIMENSION_CONDITION = "dimension:";
    private static final Matcher CONDITION_REGEX = Pattern.compile(String.format("(%s|%s)(-?[0-9]+(\\~-?[0-9]+)?)", "meta:", "dimension:")).matcher("");

    public ItemList() {
        this((Multimap<Item, ExtraConditions>)HashMultimap.create());
    }

    public ItemList(Multimap<Item, ExtraConditions> entries) {
        this.entries = entries;
    }

    public void addItem(Item item) {
        this.addItemWithPredicate(item, TRUE);
    }

    public void addItemWithPredicate(Item item, ExtraConditions test) {
        this.entries.put((Object)item, (Object)test);
    }

    @Override
    @Nonnull
    public Iterator<Map.Entry<Item, ExtraConditions>> iterator() {
        return this.entries.entries().iterator();
    }

    public boolean contains(ItemStack stack, int dimension) {
        if (stack.func_190926_b()) {
            return false;
        }
        Collection tests = this.entries.get((Object)stack.func_77973_b());
        if (tests == null || tests.isEmpty()) {
            return false;
        }
        for (BiPredicate test : tests) {
            if (!test.test(stack, dimension)) continue;
            return true;
        }
        return false;
    }

    public ItemList copy() {
        return new ItemList(this.entries);
    }

    public String[] toStringArray() {
        if (this.entries.isEmpty()) {
            return new String[0];
        }
        ArrayList xd = new ArrayList();
        this.entries.forEach((item, test) -> {
            if (test == TRUE) {
                xd.add(Objects.requireNonNull(item.getRegistryName()).toString());
            } else {
                xd.add(Objects.requireNonNull(item.getRegistryName()).toString() + CONDITIONS_SEPARATOR + test.toString());
            }
        });
        return xd.toArray(new String[0]);
    }

    public ItemList addFromStringArray(String[] arr) {
        if (arr.length == 0) {
            return this;
        }
        for (int line = 0; line < arr.length; ++line) {
            ResourceLocation itemRes;
            String s;
            String unparsedItemRes = s = arr[line];
            ExtraConditions test = TRUE;
            if (s.contains(CONDITIONS_SEPARATOR)) {
                String[] split = unparsedItemRes.split(CONDITIONS_SEPARATOR);
                unparsedItemRes = split[0];
                try {
                    test = new ExtraConditions();
                    for (int i = 1; i < split.length; ++i) {
                        test.readSettingString(split[i]);
                    }
                }
                catch (RuntimeException e) {
                    throw new IllegalStateException("Problem parsing conditions on entry " + line, e);
                }
            }
            try {
                itemRes = new ResourceLocation(unparsedItemRes);
            }
            catch (RuntimeException e) {
                throw new IllegalStateException("Problem parsing item identifier on entry " + line, e);
            }
            if (ForgeRegistries.ITEMS.containsKey(itemRes)) {
                this.addItemWithPredicate((Item)ForgeRegistries.ITEMS.getValue(itemRes), test);
                continue;
            }
            BrokenWings.LOGGER.error("Unknown item " + unparsedItemRes + " in entry " + line + " in config file!");
        }
        return this;
    }

    public static class InclusiveRange
    implements Predicate<Integer> {
        public int bottom;
        public int top;

        public InclusiveRange(int exact) {
            this(exact, exact);
        }

        public InclusiveRange(int bottom, int top) {
            this.bottom = bottom;
            this.top = top;
        }

        public static InclusiveRange fromString(String s) {
            try {
                if (s.contains("~")) {
                    String[] split = s.split("~");
                    return new InclusiveRange(Integer.valueOf(split[0]), Integer.valueOf(split[1])).fixOrder();
                }
                return new InclusiveRange(Integer.valueOf(s));
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Problem parsing range", e);
            }
        }

        private InclusiveRange fixOrder() {
            if (this.bottom > this.top) {
                int asdfghjkl = this.top;
                this.top = this.bottom;
                this.bottom = asdfghjkl;
            }
            return this;
        }

        public String toString() {
            if (this.bottom == this.top) {
                return String.valueOf(this.bottom);
            }
            return String.valueOf(this.bottom) + "~" + String.valueOf(this.top);
        }

        @Override
        public boolean test(Integer integer) {
            return integer >= this.bottom && integer <= this.top;
        }
    }

    public static class ExtraConditions
    implements BiPredicate<ItemStack, Integer> {
        private boolean forceMeta = false;
        private InclusiveRange metaRange;
        private boolean forceDimension = false;
        private InclusiveRange dimensionRange;

        public ExtraConditions forceMeta(InclusiveRange metaRange) {
            this.forceMeta = true;
            this.metaRange = metaRange;
            return this;
        }

        public ExtraConditions forceDimension(InclusiveRange dimensionRange) {
            this.forceDimension = true;
            this.dimensionRange = dimensionRange;
            return this;
        }

        public String toString() {
            if (!this.forceMeta && !this.forceDimension) {
                return "";
            }
            StringBuilder s = new StringBuilder();
            if (this.forceMeta) {
                s.append(ItemList.META_CONDITION);
                s.append(this.metaRange.toString());
            }
            if (this.forceDimension) {
                if (this.forceMeta) {
                    s.append(ItemList.CONDITIONS_SEPARATOR);
                }
                s.append(ItemList.DIMENSION_CONDITION);
                s.append(this.dimensionRange.toString());
            }
            return s.toString();
        }

        public void readSettingString(String setting) {
            CONDITION_REGEX.reset(setting);
            while (CONDITION_REGEX.find()) {
                String key = CONDITION_REGEX.group(1);
                InclusiveRange range = InclusiveRange.fromString(CONDITION_REGEX.group(2));
                if (ItemList.META_CONDITION.equals(key)) {
                    this.forceMeta(range);
                    continue;
                }
                if (!ItemList.DIMENSION_CONDITION.equals(key)) continue;
                this.forceDimension(range);
            }
        }

        @Override
        public boolean test(ItemStack stack, Integer dimension) {
            if (this.forceMeta && !this.metaRange.test(stack.func_77960_j())) {
                return false;
            }
            return !this.forceDimension || this.dimensionRange.test(dimension);
        }
    }
}

