/*
 * Decompiled with CFR 0.152.
 */
package quaternary.brokenwings.countermeasures;

import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.config.Configuration;
import quaternary.brokenwings.config.ConfigHelpers;
import quaternary.brokenwings.config.ItemList;
import quaternary.brokenwings.countermeasures.ICountermeasure;

public class ButterfingersCountermeasure
implements ICountermeasure {
    private int interval;
    private ItemList items;

    @Override
    public String getName() {
        return "butterfingers";
    }

    @Override
    public String getFriendlyName() {
        return "Butterfingers";
    }

    @Override
    public String getDescription() {
        return "This measure causes players to periodically drop items matching a configurable list. Use for 'angel-ring'-like items.";
    }

    @Override
    public void readConfig(Configuration config) {
        String cat = "countermeasures." + this.getName();
        this.interval = config.getInt("interval", cat, 70, 1, Integer.MAX_VALUE, "How often should players automatically drop the banned items? (The lower you set this, the more annoying it is if people accidentally visit a dimension carrying one of these)");
        this.items = ConfigHelpers.getItemList(config, "items", cat, new ItemList(), "The banned list of items.");
    }

    @Override
    public boolean isFlying(EntityPlayerMP playerMP) {
        if (playerMP.field_70170_p.func_82737_E() % (long)this.interval != 0L) {
            return false;
        }
        if (this.hav(playerMP, (NonNullList<ItemStack>)playerMP.field_71071_by.field_70462_a)) {
            return true;
        }
        return this.hav(playerMP, (NonNullList<ItemStack>)playerMP.field_71071_by.field_184439_c);
    }

    private boolean hav(EntityPlayerMP playerMP, NonNullList<ItemStack> yea) {
        for (ItemStack itemStack : yea) {
            if (!this.items.contains(itemStack, playerMP.field_71093_bK)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void stopFlying(EntityPlayerMP playerMP) {
        this.noh(playerMP, (NonNullList<ItemStack>)playerMP.field_71071_by.field_70462_a);
        this.noh(playerMP, (NonNullList<ItemStack>)playerMP.field_71071_by.field_184439_c);
    }

    private void noh(EntityPlayerMP playerMP, NonNullList<ItemStack> yea) {
        for (int i = 0; i < yea.size(); ++i) {
            if (!this.items.contains((ItemStack)yea.get(i), playerMP.field_71093_bK)) continue;
            ItemStack there = ((ItemStack)yea.get(i)).func_77946_l();
            yea.set(i, (Object)ItemStack.field_190927_a);
            playerMP.func_71019_a(there, false);
        }
    }
}

