/*
 * Decompiled with CFR 0.152.
 */
package quaternary.brokenwings.countermeasures;

import java.util.HashSet;
import java.util.Set;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import quaternary.brokenwings.countermeasures.ButterfingersCountermeasure;
import quaternary.brokenwings.countermeasures.CreativeStyleFlightCountermeasure;
import quaternary.brokenwings.countermeasures.ElytraCountermeasure;
import quaternary.brokenwings.countermeasures.GreasyArmorCountermeasure;
import quaternary.brokenwings.countermeasures.ICountermeasure;
import quaternary.brokenwings.countermeasures.compat.GreasyBaublesCountermeasure;
import quaternary.brokenwings.countermeasures.compat.WingsCountermeasure;

public class Countermeasures {
    public static final Set<ICountermeasure> ALL = new HashSet<ICountermeasure>();
    public static final Set<ICountermeasure> ENABLED = new HashSet<ICountermeasure>();

    public static void createAll() {
        ALL.add(new ElytraCountermeasure());
        ALL.add(new CreativeStyleFlightCountermeasure());
        ALL.add(new ButterfingersCountermeasure());
        ALL.add(new GreasyArmorCountermeasure());
        if (Loader.isModLoaded((String)"wings")) {
            ALL.add(new WingsCountermeasure());
        }
        if (Loader.isModLoaded((String)"baubles")) {
            ALL.add(new GreasyBaublesCountermeasure());
        }
        ENABLED.addAll(ALL);
    }

    public static void readConfig(Configuration config) {
        ENABLED.clear();
        for (ICountermeasure measure : ALL) {
            String configName = measure.getName();
            String friendlyName = measure.getFriendlyName();
            String description = "Is the \"" + friendlyName + "\" countermeasure enabled?";
            if (!measure.getDescription().isEmpty()) {
                description = description + " ";
                description = description + measure.getDescription();
            }
            boolean enabled = config.getBoolean(configName, "countermeasures", true, description);
            measure.readConfig(config);
            if (!enabled) continue;
            ENABLED.add(measure);
        }
    }
}

