/*
 * Decompiled with CFR 0.152.
 */
package quaternary.brokenwings.countermeasures.compat;

import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import quaternary.brokenwings.config.ConfigHelpers;
import quaternary.brokenwings.config.ItemList;
import quaternary.brokenwings.countermeasures.ICountermeasure;

public class GreasyBaublesCountermeasure
implements ICountermeasure {
    private ItemList items;

    @Override
    public String getName() {
        return "greasybaubles";
    }

    @Override
    public String getFriendlyName() {
        return "Greasy Baubles";
    }

    @Override
    public String getDescription() {
        return "Unequips Baubles matching a list. If it can't be unequipped (full inventory, maybe), it gets thrown on the ground.";
    }

    @Override
    public void readConfig(Configuration config) {
        String cat = "countermeasures." + this.getName();
        this.items = ConfigHelpers.getItemList(config, "items", cat, new ItemList(), "Items to automatically unequip when worn in the Bauble slots.");
    }

    @Override
    public boolean isFlying(EntityPlayerMP playerMP) {
        IBaublesItemHandler bubbles = BaublesApi.getBaublesHandler((EntityPlayer)playerMP);
        for (int i = 0; i < bubbles.getSlots(); ++i) {
            if (!this.items.contains(bubbles.getStackInSlot(i), playerMP.field_71093_bK)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void stopFlying(EntityPlayerMP playerMP) {
        IBaublesItemHandler bubbles = BaublesApi.getBaublesHandler((EntityPlayer)playerMP);
        for (int i = 0; i < bubbles.getSlots(); ++i) {
            if (!this.items.contains(bubbles.getStackInSlot(i), playerMP.field_71093_bK)) continue;
            ItemStack bubble = bubbles.getStackInSlot(i).func_77946_l();
            bubbles.setStackInSlot(i, ItemStack.field_190927_a);
            if (!playerMP.field_71071_by.func_70441_a(bubble)) continue;
            playerMP.func_71019_a(bubble, false);
        }
    }
}

