/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui.widget;

import buildcraft.api.core.BCLog;
import buildcraft.lib.gui.BuildCraftGui;
import buildcraft.lib.gui.ContainerBC_Neptune;
import buildcraft.lib.gui.GuiElementSimple;
import buildcraft.lib.gui.IInteractionElement;
import buildcraft.lib.gui.Widget_Neptune;
import buildcraft.lib.gui.elem.ToolTip;
import buildcraft.lib.gui.pos.IGuiArea;
import buildcraft.lib.misc.GuiUtil;
import buildcraft.lib.misc.StackUtil;
import buildcraft.lib.net.PacketBufferBC;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WidgetPhantomSlot
extends Widget_Neptune<ContainerBC_Neptune> {
    private static final byte NET_CLIENT_TO_SERVER_CLICK = 0;
    private static final byte NET_SERVER_TO_CLIENT_ITEM = 0;
    private static final byte CLICK_FLAG_SHIFT = 1;
    private static final byte CLICK_FLAG_SINGLE = 2;
    private static final byte CLICK_FLAG_CLONE = 4;
    @Nonnull
    private ItemStack stack = StackUtil.EMPTY;

    public WidgetPhantomSlot(ContainerBC_Neptune container) {
        super(container);
    }

    @Override
    public IMessage handleWidgetDataServer(MessageContext ctx, PacketBufferBC buffer) throws IOException {
        byte id = buffer.readByte();
        if (id == 0) {
            byte flags = buffer.readByte();
            this.tryMouseClick(flags);
        }
        return null;
    }

    void tryMouseClick(int flags) {
        boolean clone;
        boolean shift = (flags & 1) == 1;
        boolean single = (flags & 2) == 2;
        boolean bl = clone = (flags & 4) == 4;
        if (clone) {
            ItemStack get;
            if (this.container.player.field_71075_bZ.field_75098_d && !(get = this.getStack()).func_190926_b() && this.container.player.field_71071_by.func_70445_o().func_190926_b()) {
                this.container.player.field_71071_by.func_70437_b(get.func_77946_l());
            }
        } else if (shift) {
            this.setStack(StackUtil.EMPTY, true);
        } else {
            ItemStack toSet = this.container.player.field_71071_by.func_70445_o();
            if (toSet.func_190926_b()) {
                this.setStack(StackUtil.EMPTY, true);
            } else {
                toSet = toSet.func_77946_l();
                if (single) {
                    toSet.func_190920_e(1);
                }
                this.setStack(toSet, true);
            }
        }
    }

    @Override
    public IMessage handleWidgetDataClient(MessageContext ctx, PacketBufferBC buffer) throws IOException {
        byte id = buffer.readByte();
        if (id == 0) {
            this.stack = StackUtil.asNonNull(buffer.func_150791_c());
            this.onSetStack();
        }
        return null;
    }

    protected int getMaxStackSize(ItemStack stack) {
        return stack.func_77976_d();
    }

    @Nonnull
    public ItemStack getStack() {
        return this.stack;
    }

    public final void setStack(@Nonnull ItemStack stack, boolean tellClient) {
        this.stack = StackUtil.asNonNull(stack);
        int max = this.getMaxStackSize(stack);
        if (stack.func_190916_E() > max) {
            this.stack.func_190920_e(max);
        }
        if (tellClient && !this.container.player.field_70170_p.field_72995_K) {
            this.sendWidgetData(buffer -> {
                buffer.writeByte(0);
                buffer.func_150788_a(stack);
            });
        }
        this.onSetStack();
    }

    protected void onSetStack() {
    }

    @SideOnly(value=Side.CLIENT)
    public class GuiElementPhantomSlot
    extends GuiElementSimple
    implements IInteractionElement {
        private final ToolTip tooltip;

        public GuiElementPhantomSlot(BuildCraftGui gui, IGuiArea area) {
            super(gui, area);
            this.tooltip = GuiUtil.createToolTip(this::getStack);
        }

        @Override
        public void drawForeground(float partialTicks) {
            RenderHelper.func_74520_c();
            this.gui.mc.func_175599_af().func_180450_b(this.getStack(), (int)this.getX(), (int)this.getY());
            RenderHelper.func_74518_a();
            if (this.contains(this.gui.mouse) && this.shouldDrawHighlight()) {
                GuiUtil.drawRect(this, 0x70FFFFFF);
            }
        }

        protected boolean shouldDrawHighlight() {
            return true;
        }

        @Nonnull
        public ItemStack getStack() {
            return WidgetPhantomSlot.this.getStack();
        }

        @Override
        public void onMouseClicked(int button) {
            if (this.contains(this.gui.mouse)) {
                byte flags = 0;
                if (button == 1) {
                    flags = (byte)(flags | 2);
                }
                if (GuiScreen.func_146272_n()) {
                    flags = (byte)(flags | 1);
                }
                if (this.gui.mc.field_71474_y.field_74322_I.isActiveAndMatches(button - 100)) {
                    flags = (byte)(flags | 4);
                    BCLog.logger.info("clone");
                }
                byte writtenFlags = flags;
                WidgetPhantomSlot.this.tryMouseClick(flags);
                WidgetPhantomSlot.this.sendWidgetData(buffer -> {
                    buffer.writeByte(0);
                    buffer.writeByte(writtenFlags);
                });
            }
        }

        @Override
        public void addToolTips(List<ToolTip> tooltips) {
            if (this.contains(this.gui.mouse) && !this.getStack().func_190926_b()) {
                tooltips.add(this.tooltip);
                this.tooltip.refresh();
            }
        }
    }
}

