/*
 * Decompiled with CFR 0.152.
 */
package c4.champions.common.affix;

import c4.champions.Champions;
import c4.champions.common.affix.AffixRegistry;
import c4.champions.common.affix.core.AffixBase;
import c4.champions.common.capability.CapabilityChampionship;
import c4.champions.common.capability.IChampionship;
import c4.champions.common.config.ConfigHandler;
import c4.champions.common.rank.Rank;
import c4.champions.common.rank.RankManager;
import c4.champions.common.util.ChampionHelper;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.Tuple;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class AffixEvents {
    @SubscribeEvent
    public void onLivingJoinWorld(EntityJoinWorldEvent evt) {
        EntityLiving living;
        IChampionship chp;
        if (ChampionHelper.isValidChampion(evt.getEntity()) && (chp = CapabilityChampionship.getChampionship(living = (EntityLiving)evt.getEntity())) != null) {
            List<Tuple<Potion, Integer>> potions;
            for (String aff : chp.getAffixes()) {
                AffixBase affix = AffixRegistry.getAffix(aff);
                if (affix == null) continue;
                affix.onSpawn(living, chp);
            }
            Rank rank = chp.getRank();
            if (!living.field_70170_p.field_72995_K && ChampionHelper.isElite(rank) && (potions = RankManager.getPotionsForTier(rank.getTier())) != null) {
                for (Tuple<Potion, Integer> potion : potions) {
                    living.func_70690_d(new PotionEffect((Potion)potion.func_76341_a(), 200, ((Integer)potion.func_76340_b()).intValue()));
                }
            }
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent evt) {
        EntityLiving living;
        IChampionship chp;
        if (ChampionHelper.isValidChampion((Entity)evt.getEntityLiving()) && (chp = CapabilityChampionship.getChampionship(living = (EntityLiving)evt.getEntityLiving())) != null) {
            for (String aff : chp.getAffixes()) {
                AffixBase affix = AffixRegistry.getAffix(aff);
                if (affix == null) continue;
                affix.onUpdate(living, chp);
            }
            Rank rank = chp.getRank();
            if (ChampionHelper.isElite(rank)) {
                List<Tuple<Potion, Integer>> potions;
                if (living.field_70170_p.field_72995_K && !ConfigHandler.hideEffects) {
                    Champions.proxy.generateRankParticle((EntityLivingBase)living, rank.getColor());
                } else if (living.field_70173_aa % 100 == 0 && (potions = RankManager.getPotionsForTier(rank.getTier())) != null) {
                    for (Tuple<Potion, Integer> potion : potions) {
                        living.func_70690_d(new PotionEffect((Potion)potion.func_76341_a(), 200, ((Integer)potion.func_76340_b()).intValue()));
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onLivingAttacked(LivingAttackEvent evt) {
        EntityLiving living;
        IChampionship chp;
        if (ChampionHelper.isValidChampion((Entity)evt.getEntityLiving()) && (chp = CapabilityChampionship.getChampionship(living = (EntityLiving)evt.getEntityLiving())) != null) {
            for (String aff : chp.getAffixes()) {
                AffixBase affix = AffixRegistry.getAffix(aff);
                if (affix == null) continue;
                affix.onAttacked(living, chp, evt.getSource(), evt.getAmount(), evt);
            }
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent evt) {
        EntityLiving living;
        IChampionship chp;
        EntityLivingBase entityLivingBase;
        if (evt.getSource().func_76346_g() instanceof EntityLivingBase && ChampionHelper.isValidChampion((Entity)(entityLivingBase = (EntityLivingBase)evt.getSource().func_76346_g())) && (chp = CapabilityChampionship.getChampionship(living = (EntityLiving)entityLivingBase)) != null) {
            for (String aff : chp.getAffixes()) {
                AffixBase affix = AffixRegistry.getAffix(aff);
                if (affix == null) continue;
                affix.onAttack(living, chp, evt.getEntityLiving(), evt.getSource(), evt.getAmount(), evt);
            }
        }
    }

    @SubscribeEvent
    public void onLivingWasHurt(LivingHurtEvent evt) {
        if (ChampionHelper.isValidChampion((Entity)evt.getEntityLiving())) {
            float amount;
            float newAmount = amount = evt.getAmount();
            EntityLiving living = (EntityLiving)evt.getEntityLiving();
            IChampionship chp = CapabilityChampionship.getChampionship(living);
            if (chp != null) {
                for (String aff : chp.getAffixes()) {
                    AffixBase affix = AffixRegistry.getAffix(aff);
                    if (affix == null) continue;
                    newAmount = affix.onHurt(living, chp, evt.getSource(), amount, newAmount);
                }
                evt.setAmount(newAmount);
            }
        }
    }

    @SubscribeEvent
    public void onLivingDamaged(LivingDamageEvent evt) {
        if (ChampionHelper.isValidChampion((Entity)evt.getEntityLiving())) {
            float amount;
            float newAmount = amount = evt.getAmount();
            EntityLiving living = (EntityLiving)evt.getEntityLiving();
            IChampionship chp = CapabilityChampionship.getChampionship(living);
            if (chp != null) {
                for (String aff : chp.getAffixes()) {
                    AffixBase affix = AffixRegistry.getAffix(aff);
                    if (affix == null) continue;
                    newAmount = affix.onDamaged(living, chp, evt.getSource(), amount, newAmount);
                }
                evt.setAmount(newAmount);
            }
        }
    }

    @SubscribeEvent
    public void onLivingKnockback(LivingKnockBackEvent evt) {
        EntityLiving living;
        IChampionship chp;
        if (ChampionHelper.isValidChampion(evt.getOriginalAttacker()) && (chp = CapabilityChampionship.getChampionship(living = (EntityLiving)evt.getOriginalAttacker())) != null) {
            for (String aff : chp.getAffixes()) {
                AffixBase affix = AffixRegistry.getAffix(aff);
                if (affix == null) continue;
                affix.onKnockback(living, chp, evt);
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent evt) {
        EntityLiving living;
        IChampionship chp;
        if (ChampionHelper.isValidChampion((Entity)evt.getEntityLiving()) && (chp = CapabilityChampionship.getChampionship(living = (EntityLiving)evt.getEntityLiving())) != null) {
            for (String aff : chp.getAffixes()) {
                AffixBase affix = AffixRegistry.getAffix(aff);
                if (affix == null) continue;
                affix.onDeath(living, chp, evt.getSource(), evt);
            }
        }
    }

    @SubscribeEvent
    public void onLivingHeal(LivingHealEvent evt) {
        if (ChampionHelper.isValidChampion((Entity)evt.getEntityLiving())) {
            float amount;
            float newAmount = amount = evt.getAmount();
            EntityLiving living = (EntityLiving)evt.getEntityLiving();
            IChampionship chp = CapabilityChampionship.getChampionship(living);
            if (chp != null) {
                for (String aff : chp.getAffixes()) {
                    AffixBase affix = AffixRegistry.getAffix(aff);
                    if (affix == null) continue;
                    newAmount = affix.onHealed(living, chp, amount, newAmount);
                }
                evt.setAmount(newAmount);
            }
        }
    }
}

