/*
 * Decompiled with CFR 0.152.
 */
package c4.champions.common.item;

import c4.champions.common.affix.AffixRegistry;
import c4.champions.common.affix.core.AffixBase;
import c4.champions.common.capability.CapabilityChampionship;
import c4.champions.common.capability.IChampionship;
import c4.champions.common.rank.Rank;
import c4.champions.common.rank.RankManager;
import c4.champions.common.util.ChampionHelper;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLiquid;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemChampionPlacer
extends Item {
    public ItemChampionPlacer() {
        this.setRegistryName(new ResourceLocation("champions", "champion_egg"));
        this.func_77655_b("champions.champion_egg");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound != null && nbttagcompound.func_150297_b("ChampionInfo", 10)) {
            NBTTagCompound compound = nbttagcompound.func_74775_l("ChampionInfo");
            int tier = compound.func_74762_e("tier");
            tooltip.add(net.minecraft.client.resources.I18n.func_135052_a((String)"champions.champion_egg.tooltip.tier", (Object[])new Object[]{tier}));
            NBTTagList tagList = compound.func_150295_c("affixes", 8);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                tooltip.add(net.minecraft.client.resources.I18n.func_135052_a((String)("champions.affix." + tagList.func_150307_f(i)), (Object[])new Object[0]));
            }
        }
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        String s = ("" + I18n.func_74838_a((String)(this.func_77658_a() + ".name"))).trim();
        String s1 = EntityList.func_191302_a((ResourceLocation)ItemMonsterPlacer.func_190908_h((ItemStack)stack));
        if (s1 != null) {
            s = s + " " + I18n.func_74838_a((String)("entity." + s1 + ".name"));
        }
        return s;
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (worldIn.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        if (!player.func_175151_a(pos.func_177972_a(facing), facing, itemstack)) {
            return EnumActionResult.FAIL;
        }
        BlockPos blockpos = pos.func_177972_a(facing);
        double d0 = this.getYOffset(worldIn, blockpos);
        Entity entity = ItemChampionPlacer.createChampion(worldIn, ItemMonsterPlacer.func_190908_h((ItemStack)itemstack), (double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + d0, (double)blockpos.func_177952_p() + 0.5);
        if (entity != null) {
            if (entity instanceof EntityLivingBase && itemstack.func_82837_s()) {
                entity.func_96094_a(itemstack.func_82833_r());
            }
            ItemMonsterPlacer.func_185079_a((World)worldIn, (EntityPlayer)player, (ItemStack)itemstack, (Entity)entity);
            if (ChampionHelper.isValidChampion(entity)) {
                EntityLiving living = (EntityLiving)entity;
                ItemChampionPlacer.applyItemChampionDataToEntity(worldIn, player, itemstack, living);
                living.func_180482_a(worldIn.func_175649_E(new BlockPos((Entity)living)), null);
                worldIn.func_72838_d(entity);
                living.func_70642_aH();
                if (!player.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.FAIL;
        }
        return EnumActionResult.SUCCESS;
    }

    protected double getYOffset(World world, BlockPos blockPos) {
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(blockPos).func_72321_a(0.0, -1.0, 0.0);
        List list = world.func_184144_a(null, axisalignedbb);
        if (list.isEmpty()) {
            return 0.0;
        }
        double d0 = axisalignedbb.field_72338_b;
        for (AxisAlignedBB axisalignedbb1 : list) {
            d0 = Math.max(axisalignedbb1.field_72337_e, d0);
        }
        return d0 - (double)blockPos.func_177956_o();
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, @Nonnull EnumHand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (worldIn.field_72995_K) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
        }
        RayTraceResult raytraceresult = this.func_77621_a(worldIn, playerIn, true);
        if (raytraceresult != null && raytraceresult.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos blockpos = raytraceresult.func_178782_a();
            if (!(worldIn.func_180495_p(blockpos).func_177230_c() instanceof BlockLiquid)) {
                return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
            }
            if (worldIn.func_175660_a(playerIn, blockpos) && playerIn.func_175151_a(blockpos, raytraceresult.field_178784_b, itemstack)) {
                Entity entity = ItemChampionPlacer.createChampion(worldIn, ItemMonsterPlacer.func_190908_h((ItemStack)itemstack), (double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.5, (double)blockpos.func_177952_p() + 0.5);
                if (entity == null) {
                    return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
                }
                if (entity instanceof EntityLivingBase && itemstack.func_82837_s()) {
                    entity.func_96094_a(itemstack.func_82833_r());
                }
                ItemMonsterPlacer.func_185079_a((World)worldIn, (EntityPlayer)playerIn, (ItemStack)itemstack, (Entity)entity);
                if (ChampionHelper.isValidChampion(entity)) {
                    EntityLiving living = (EntityLiving)entity;
                    ItemChampionPlacer.applyItemChampionDataToEntity(worldIn, playerIn, itemstack, living);
                    living.func_180482_a(worldIn.func_175649_E(new BlockPos((Entity)living)), null);
                    worldIn.func_72838_d(entity);
                    living.func_70642_aH();
                    if (!playerIn.field_71075_bZ.field_75098_d) {
                        itemstack.func_190918_g(1);
                    }
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
                }
                return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
    }

    @Nullable
    public static Entity createChampion(World worldIn, @Nullable ResourceLocation entityID, double x, double y, double z) {
        if (entityID != null && EntityList.field_75627_a.containsKey(entityID)) {
            Entity entity = null;
            for (int i = 0; i < 1; ++i) {
                entity = EntityList.func_188429_b((ResourceLocation)entityID, (World)worldIn);
                if (!(entity instanceof EntityLiving)) continue;
                EntityLiving entityliving = (EntityLiving)entity;
                entity.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(worldIn.field_73012_v.nextFloat() * 360.0f)), 0.0f);
                entityliving.field_70759_as = entityliving.field_70177_z;
                entityliving.field_70761_aq = entityliving.field_70177_z;
            }
            return entity;
        }
        return null;
    }

    public static void applyItemChampionDataToEntity(World entityWorld, @Nullable EntityPlayer player, ItemStack stack, @Nullable EntityLiving targetEntity) {
        NBTTagCompound nbttagcompound;
        MinecraftServer minecraftserver = entityWorld.func_73046_m();
        if (minecraftserver != null && targetEntity != null && (nbttagcompound = stack.func_77978_p()) != null && nbttagcompound.func_150297_b("ChampionInfo", 10)) {
            if (!(entityWorld.field_72995_K || player != null && minecraftserver.func_184103_al().func_152596_g(player.func_146103_bH()))) {
                return;
            }
            IChampionship chp = CapabilityChampionship.getChampionship(targetEntity);
            if (chp != null) {
                NBTTagCompound compound = nbttagcompound.func_74775_l("ChampionInfo");
                Rank rank = RankManager.getRankForTier(compound.func_74762_e("tier"));
                chp.setRank(rank);
                if (rank.getTier() > 0) {
                    HashSet affixes = Sets.newHashSet();
                    NBTTagList tagList = compound.func_150295_c("affixes", 8);
                    for (int i = 0; i < tagList.func_74745_c(); ++i) {
                        String affix = tagList.func_150307_f(i);
                        if (AffixRegistry.getAffix(affix) == null) continue;
                        affixes.add(affix);
                    }
                    if (affixes.isEmpty()) {
                        chp.setAffixes(ChampionHelper.generateAffixes(rank, targetEntity, new String[0]));
                    } else {
                        chp.setAffixes(affixes);
                    }
                    chp.setName(ChampionHelper.generateRandomName());
                    chp.getRank().applyGrowth((EntityLivingBase)targetEntity);
                    for (String s : chp.getAffixes()) {
                        AffixBase affix = AffixRegistry.getAffix(s);
                        if (affix == null) continue;
                        affix.onInitialSpawn(targetEntity, chp);
                    }
                }
            }
        }
    }

    public static void applyEntityInfoToItemStack(ItemStack stack, ResourceLocation entityId, int tier, Set<String> affixes) {
        NBTTagCompound nbttagcompound = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        nbttagcompound1.func_74778_a("id", entityId.toString());
        nbttagcompound.func_74782_a("EntityTag", (NBTBase)nbttagcompound1);
        NBTTagCompound nbttagcompound2 = new NBTTagCompound();
        nbttagcompound2.func_74768_a("tier", tier);
        NBTTagList taglist = new NBTTagList();
        for (String affix : affixes) {
            taglist.func_74742_a((NBTBase)new NBTTagString(affix));
        }
        nbttagcompound2.func_74782_a("affixes", (NBTBase)taglist);
        nbttagcompound.func_74782_a("ChampionInfo", (NBTBase)nbttagcompound2);
        stack.func_77982_d(nbttagcompound);
    }
}

