/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.functions;

import com.natamus.collective.functions.RayTraceFunctions;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class BlockPosFunctions {
    public static List<BlockPos> getBlocksAround(BlockPos pos, boolean down) {
        ArrayList<BlockPos> around = new ArrayList<BlockPos>();
        around.add(pos.func_177978_c());
        around.add(pos.func_177974_f());
        around.add(pos.func_177968_d());
        around.add(pos.func_177976_e());
        around.add(pos.func_177984_a());
        if (down) {
            around.add(pos.func_177977_b());
        }
        return around;
    }

    public static List<BlockPos> getBlocksNextToEachOther(World world, BlockPos startpos, List<Block> possibleblocks) {
        ArrayList<BlockPos> checkedblocks = new ArrayList<BlockPos>();
        ArrayList<BlockPos> theblocksaround = new ArrayList<BlockPos>();
        if (possibleblocks.contains(world.func_180495_p(startpos).func_177230_c())) {
            theblocksaround.add(startpos);
            checkedblocks.add(startpos);
        }
        BlockPosFunctions.recursiveGetNextBlocks(world, startpos, possibleblocks, theblocksaround, checkedblocks);
        return theblocksaround;
    }

    private static void recursiveGetNextBlocks(World world, BlockPos pos, List<Block> possibleblocks, List<BlockPos> theblocksaround, List<BlockPos> checkedblocks) {
        List<BlockPos> possibleblocksaround = BlockPosFunctions.getBlocksAround(pos, true);
        for (BlockPos pba : possibleblocksaround) {
            if (checkedblocks.contains(pba)) continue;
            checkedblocks.add(pba);
            if (!possibleblocks.contains(world.func_180495_p(pba).func_177230_c()) || theblocksaround.contains(pba)) continue;
            theblocksaround.add(pba);
            BlockPosFunctions.recursiveGetNextBlocks(world, pba, possibleblocks, theblocksaround, checkedblocks);
        }
    }

    public static List<BlockPos> getBlocksNextToEachOtherMaterial(World world, BlockPos startpos, List<Material> possiblematerials) {
        ArrayList<BlockPos> checkedblocks = new ArrayList<BlockPos>();
        ArrayList<BlockPos> theblocksaround = new ArrayList<BlockPos>();
        if (possiblematerials.contains(world.func_180495_p(startpos).func_185904_a())) {
            theblocksaround.add(startpos);
            checkedblocks.add(startpos);
        }
        BlockPosFunctions.recursiveGetNextBlocksMaterial(world, startpos, possiblematerials, theblocksaround, checkedblocks);
        return theblocksaround;
    }

    private static void recursiveGetNextBlocksMaterial(World world, BlockPos pos, List<Material> possiblematerials, List<BlockPos> theblocksaround, List<BlockPos> checkedblocks) {
        List<BlockPos> possibleblocksaround = BlockPosFunctions.getBlocksAround(pos, true);
        for (BlockPos pba : possibleblocksaround) {
            if (checkedblocks.contains(pba)) continue;
            checkedblocks.add(pba);
            if (!possiblematerials.contains(world.func_180495_p(pba).func_185904_a()) || theblocksaround.contains(pba)) continue;
            theblocksaround.add(pba);
            BlockPosFunctions.recursiveGetNextBlocksMaterial(world, pba, possiblematerials, theblocksaround, checkedblocks);
        }
    }

    public static BlockPos getSurfaceBlockPos(World world, int x, int z, DimensionType dtype) {
        BlockPos returnpos = new BlockPos(x, 255, z);
        if (!dtype.equals((Object)DimensionType.NETHER)) {
            int maxheight = 256;
            BlockPos pos = new BlockPos(x, maxheight, z);
            for (int y = maxheight; y > 0; --y) {
                IBlockState blockstate = world.func_180495_p(pos);
                Material material = blockstate.func_185904_a();
                if (blockstate.getLightOpacity((IBlockAccess)world, pos) >= 15 || material.equals(Material.field_151588_w) || material.equals(Material.field_151598_x)) {
                    returnpos = pos.func_177984_a().func_185334_h();
                    break;
                }
                pos = pos.func_177977_b();
            }
        } else {
            int maxheight = 128;
            BlockPos pos = new BlockPos(x, 0, z);
            for (int y = 0; y < maxheight; ++y) {
                IBlockState upstate;
                IBlockState blockstate = world.func_180495_p(pos);
                if (blockstate.func_177230_c().equals(Blocks.field_150350_a) && (upstate = world.func_180495_p(pos.func_177984_a())).func_177230_c().equals(Blocks.field_150350_a)) {
                    returnpos = pos.func_185334_h();
                    break;
                }
                pos = pos.func_177984_a();
            }
        }
        return returnpos;
    }

    public static BlockPos getSurfaceBlockPos(World world, int x, int z) {
        return BlockPosFunctions.getSurfaceBlockPos(world, x, z, DimensionType.OVERWORLD);
    }

    public static BlockPos getCenterNearbyVillage(WorldServer serverworld) {
        return BlockPosFunctions.getNearbyVillage(serverworld, new BlockPos(0, 0, 0));
    }

    public static BlockPos getNearbyVillage(WorldServer serverworld, BlockPos nearpos) {
        return BlockPosFunctions.getNearbyStructure(serverworld, "Village", nearpos, 9999);
    }

    public static BlockPos getCenterNearbyStructure(WorldServer serverworld, String structure) {
        return BlockPosFunctions.getNearbyStructure(serverworld, structure, new BlockPos(0, 0, 0));
    }

    public static BlockPos getNearbyStructure(WorldServer serverworld, String structure, BlockPos nearpos) {
        return BlockPosFunctions.getNearbyStructure(serverworld, structure, nearpos, 9999);
    }

    public static BlockPos getNearbyStructure(WorldServer serverworld, String structure, BlockPos nearpos, int radius) {
        BlockPos villagepos = serverworld.func_190528_a(structure, nearpos, false);
        if (villagepos == null) {
            return null;
        }
        BlockPos spawnpos = null;
        for (int y = 255; y > 0; --y) {
            BlockPos checkpos = new BlockPos(villagepos.func_177958_n(), y, villagepos.func_177952_p());
            if (serverworld.func_180495_p(checkpos).func_177230_c().equals(Blocks.field_150350_a)) continue;
            spawnpos = checkpos.func_177984_a().func_185334_h();
            break;
        }
        return spawnpos;
    }

    public static BlockPos getBlockPlayerIsLookingAt(World world, EntityPlayer player, boolean stopOnLiquid) {
        RayTraceResult raytraceresult = RayTraceFunctions.rayTrace(world, player, stopOnLiquid);
        double posX = raytraceresult.field_72307_f.field_72450_a;
        double posY = Math.floor(raytraceresult.field_72307_f.field_72448_b);
        double posZ = raytraceresult.field_72307_f.field_72449_c;
        return new BlockPos(posX, posY, posZ);
    }

    public static Boolean isOnSurface(World world, BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        int maxheight = world.func_72800_K();
        for (int y0 = y; y0 < maxheight; ++y0) {
            IBlockState blockstate = world.func_180495_p(new BlockPos(x, y0, z));
            if (blockstate.getLightOpacity((IBlockAccess)world, pos) < 15 || blockstate.func_177230_c() instanceof BlockLeaves) continue;
            return false;
        }
        return true;
    }

    public static Boolean isOnSurface(World world, Vec3d vecpos) {
        return BlockPosFunctions.isOnSurface(world, new BlockPos(vecpos.field_72450_a, vecpos.field_72448_b, vecpos.field_72449_c));
    }

    public static Boolean withinDistance(BlockPos start, BlockPos end, int distance) {
        if (BlockPosFunctions.withinDistance(start, end, (double)distance).booleanValue()) {
            return true;
        }
        return false;
    }

    public static Boolean withinDistance(BlockPos start, BlockPos end, double distance) {
        if (start.func_185332_f(end.func_177958_n(), end.func_177956_o(), end.func_177952_p()) <= distance) {
            return true;
        }
        return false;
    }
}

