/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.client.gui;

import com.pau101.fairylights.FairyLights;
import com.pau101.fairylights.client.ClientProxy;
import com.pau101.fairylights.client.gui.component.GuiButtonColor;
import com.pau101.fairylights.client.gui.component.GuiButtonPalette;
import com.pau101.fairylights.client.gui.component.GuiButtonToggle;
import com.pau101.fairylights.client.gui.component.GuiStyledTextField;
import com.pau101.fairylights.server.fastener.connection.type.Connection;
import com.pau101.fairylights.server.fastener.connection.type.Lettered;
import com.pau101.fairylights.server.net.serverbound.MessageEditLetteredConnection;
import com.pau101.fairylights.util.styledstring.StyledString;
import com.pau101.fairylights.util.styledstring.StylingPresence;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public final class GuiEditLetteredConnection<C extends Connection>
extends GuiScreen {
    public static final ResourceLocation WIDGETS_TEXTURE = new ResourceLocation("fairylights", "textures/gui/widgets.png");
    private static final int DONE_ID = 0;
    private static final int CANCEL_ID = 1;
    private static final int COLOR_ID = 2;
    private static final int BOLD_ID = 3;
    private static final int ITALIC_ID = 4;
    private static final int UNDERLINE_ID = 5;
    private static final int STRIKETHROUGH_ID = 6;
    private static final int PALETTE_ID = 7;
    private final C connection;
    private GuiStyledTextField textField;
    private GuiButton doneBtn;
    private GuiButton cancelBtn;
    private GuiButtonColor colorBtn;
    private GuiButtonToggle boldBtn;
    private GuiButtonToggle italicBtn;
    private GuiButtonToggle underlineBtn;
    private GuiButtonToggle strikethroughBtn;
    private GuiButtonPalette paletteBtn;
    private GuiButton selectedButton;

    public GuiEditLetteredConnection(C connection) {
        this.connection = connection;
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        int pad = 4;
        int buttonWidth = 150;
        this.field_146292_n.clear();
        this.doneBtn = this.func_189646_b(new GuiButton(0, this.field_146294_l / 2 - 4 - 150, this.field_146295_m / 4 + 120 + 12, 150, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
        this.cancelBtn = this.func_189646_b(new GuiButton(1, this.field_146294_l / 2 + 4, this.field_146295_m / 4 + 120 + 12, 150, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])));
        int textFieldX = this.field_146294_l / 2 - 150;
        int textFieldY = this.field_146295_m / 2 - 10;
        int buttonX = textFieldX;
        int buttonY = textFieldY - 25;
        int bInc = 24;
        this.colorBtn = (GuiButtonColor)this.func_189646_b(new GuiButtonColor(2, buttonX, buttonY));
        this.paletteBtn = (GuiButtonPalette)this.func_189646_b(new GuiButtonPalette(7, buttonX - 4, buttonY - 30, ClientProxy.recoloredFont, this.colorBtn));
        this.boldBtn = (GuiButtonToggle)this.func_189646_b(new GuiButtonToggle(3, buttonX += bInc, buttonY, 40, 0));
        this.italicBtn = (GuiButtonToggle)this.func_189646_b(new GuiButtonToggle(4, buttonX += bInc, buttonY, 60, 0));
        this.underlineBtn = (GuiButtonToggle)this.func_189646_b(new GuiButtonToggle(5, buttonX += bInc, buttonY, 80, 0));
        this.strikethroughBtn = (GuiButtonToggle)this.func_189646_b(new GuiButtonToggle(6, buttonX += bInc, buttonY, 100, 0));
        this.textField = new GuiStyledTextField(0, ClientProxy.recoloredFont, this.colorBtn, this.boldBtn, this.italicBtn, this.underlineBtn, this.strikethroughBtn, textFieldX, textFieldY, 300, 20);
        this.textField.setValue(((Lettered)this.connection).getText());
        this.textField.setCaretStart();
        this.textField.setFocused(true);
        this.textField.setIsBlurable(false);
        this.textField.registerChangeListener(this::validateText);
        this.textField.setCharInputTransformer(((Lettered)this.connection).getCharInputTransformer());
        this.paletteBtn.field_146125_m = false;
        StylingPresence ss = ((Lettered)this.connection).getSupportedStyling();
        this.colorBtn.field_146125_m = ss.hasColor();
        this.boldBtn.field_146125_m = ss.hasBold();
        this.italicBtn.field_146125_m = ss.hasItalic();
        this.underlineBtn.field_146125_m = ss.hasUnderline();
        this.strikethroughBtn.field_146125_m = ss.hasStrikethrough();
    }

    private void validateText(StyledString text) {
        this.doneBtn.field_146124_l = ((Lettered)this.connection).isSuppportedText(text) && !((Lettered)this.connection).getText().equals(text);
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_73876_c() {
        int x = Mouse.getX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int y = this.field_146295_m - Mouse.getY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        this.textField.update(x, y);
    }

    protected void func_73869_a(char chr, int keyCode) {
        this.paletteBtn.field_146125_m = false;
        if (GuiEditLetteredConnection.isControlOp(keyCode, 48)) {
            this.toggleStyleButton(TextFormatting.BOLD, this.boldBtn);
        } else if (GuiEditLetteredConnection.isControlOp(keyCode, 23)) {
            this.toggleStyleButton(TextFormatting.ITALIC, this.italicBtn);
        } else if (GuiEditLetteredConnection.isControlOp(keyCode, 22)) {
            this.toggleStyleButton(TextFormatting.UNDERLINE, this.underlineBtn);
        } else if (GuiEditLetteredConnection.isControlOp(keyCode, 31)) {
            this.toggleStyleButton(TextFormatting.STRIKETHROUGH, this.strikethroughBtn);
        }
        this.textField.keyTyped(chr, keyCode);
        if ((keyCode == 28 || keyCode == 156) && this.doneBtn.field_146124_l) {
            this.func_146284_a(this.doneBtn);
        } else if (keyCode == 1) {
            this.func_146284_a(this.cancelBtn);
        }
    }

    private void toggleStyleButton(TextFormatting styling, GuiButtonToggle btn) {
        btn.setValue(!btn.getValue());
        this.updateStyleButton(styling, btn);
    }

    protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        boolean blurTextField = true;
        if (button == 0) {
            for (GuiButton btn : this.field_146292_n) {
                if (!btn.func_146116_c(this.field_146297_k, mouseX, mouseY)) continue;
                GuiScreenEvent.ActionPerformedEvent.Pre event = new GuiScreenEvent.ActionPerformedEvent.Pre((GuiScreen)this, btn, this.field_146292_n);
                if (MinecraftForge.EVENT_BUS.post((Event)event)) break;
                this.selectedButton = btn = event.getButton();
                btn.func_146113_a(this.field_146297_k.func_147118_V());
                this.func_146284_a(btn);
                MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.ActionPerformedEvent.Post((GuiScreen)this, event.getButton(), this.field_146292_n));
                blurTextField = false;
            }
        }
        this.textField.mouseClicked(mouseX, mouseY, button, blurTextField);
    }

    protected void func_146286_b(int mouseX, int mouseY, int button) {
        if (this.selectedButton != this.colorBtn) {
            this.paletteBtn.field_146125_m = false;
        }
        if (this.selectedButton != null && button == 0) {
            this.selectedButton.func_146118_a(mouseX, mouseY);
            this.selectedButton = null;
        }
        this.textField.mouseReleased(mouseX, mouseY, button);
    }

    protected void func_146273_a(int mouseX, int mouseY, int button, long lastClickTime) {
        this.textField.mouseClickMove(mouseX, mouseY, button);
    }

    protected void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 2: {
                this.paletteBtn.field_146125_m = !this.paletteBtn.field_146125_m;
                break;
            }
            case 3: {
                this.updateStyleButton(TextFormatting.BOLD, this.boldBtn);
                break;
            }
            case 4: {
                this.updateStyleButton(TextFormatting.ITALIC, this.italicBtn);
                break;
            }
            case 5: {
                this.updateStyleButton(TextFormatting.UNDERLINE, this.underlineBtn);
                break;
            }
            case 6: {
                this.updateStyleButton(TextFormatting.STRIKETHROUGH, this.strikethroughBtn);
                break;
            }
            case 7: {
                this.textField.updateStyling(this.colorBtn.getDisplayColor(), true);
                break;
            }
            case 0: {
                FairyLights.network.sendToServer(new MessageEditLetteredConnection<C>(this.connection, this.textField.getValue()));
            }
            case 1: {
                this.field_146297_k.func_147108_a(null);
            }
        }
    }

    private void updateStyleButton(TextFormatting styling, GuiButtonToggle btn) {
        if (btn.field_146125_m) {
            this.textField.updateStyling(styling, btn.getValue());
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float delta) {
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.editLetteredConnection.name", (Object[])new Object[0]), this.field_146294_l / 2, 20, 0xFFFFFF);
        super.func_73863_a(mouseX, mouseY, delta);
        float mx = (float)(Mouse.getX() * this.field_146294_l) / (float)this.field_146297_k.field_71443_c;
        float my = (float)this.field_146295_m - (float)(Mouse.getY() * this.field_146295_m) / (float)this.field_146297_k.field_71440_d - 1.0f;
        this.textField.draw(mouseX, mouseY, mx, my);
    }

    public static boolean isControlOp(int key, int controlKey) {
        return key == controlKey && GuiEditLetteredConnection.func_146271_m() && !GuiEditLetteredConnection.func_146272_n() && !GuiEditLetteredConnection.func_175283_s();
    }
}

