/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.server;

import com.pau101.fairylights.FairyLights;
import com.pau101.fairylights.server.ServerEventHandler;
import com.pau101.fairylights.server.capability.CapabilityHandler;
import com.pau101.fairylights.server.config.Configurator;
import com.pau101.fairylights.server.creativetabs.CreativeTabsFairyLights;
import com.pau101.fairylights.server.fastener.BlockView;
import com.pau101.fairylights.server.fastener.CreateBlockViewEvent;
import com.pau101.fairylights.server.fastener.RegularBlockView;
import com.pau101.fairylights.server.jingle.JingleLibrary;
import com.pau101.fairylights.server.net.FLMessage;
import com.pau101.fairylights.server.net.clientbound.MessageJingle;
import com.pau101.fairylights.server.net.clientbound.MessageOpenEditLetteredConnectionGUI;
import com.pau101.fairylights.server.net.clientbound.MessageUpdateFastenerEntity;
import com.pau101.fairylights.server.net.serverbound.MessageConnectionInteraction;
import com.pau101.fairylights.server.net.serverbound.MessageEditLetteredConnection;
import com.pau101.fairylights.util.CalendarEvent;
import java.time.Month;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class ServerProxy
implements IMessageHandler<FLMessage, IMessage> {
    private int nextMessageId;

    public void initConfig(FMLPreInitializationEvent event) {
        Configurator.initConfig(event);
    }

    public void initGUI() {
        FairyLights.fairyLightsTab = new CreativeTabsFairyLights();
    }

    public void initEggs() {
        FairyLights.christmas = new CalendarEvent(Month.DECEMBER, 24, 26);
        FairyLights.christmasJingles = JingleLibrary.create("christmas");
        FairyLights.randomJingles = JingleLibrary.create("random");
        this.loadJingleLibraries();
    }

    protected void loadJingleLibraries() {
        JingleLibrary.loadAll();
    }

    public void initHandlers() {
        MinecraftForge.EVENT_BUS.register((Object)new ServerEventHandler());
        CapabilityHandler.register();
    }

    public void initNetwork() {
        FairyLights.network = NetworkRegistry.INSTANCE.newSimpleChannel("fairylights");
        this.registerMessage(MessageJingle.class, Side.CLIENT);
        this.registerMessage(MessageUpdateFastenerEntity.class, Side.CLIENT);
        this.registerMessage(MessageOpenEditLetteredConnectionGUI.class, Side.CLIENT);
        this.registerMessage(MessageConnectionInteraction.class, Side.SERVER);
        this.registerMessage(MessageEditLetteredConnection.class, Side.SERVER);
    }

    public void initRenders() {
    }

    public void initRendersLate() {
    }

    @Nullable
    public IMessage onMessage(FLMessage message, MessageContext ctx) {
        IThreadListener thread = FMLCommonHandler.instance().getWorldThread(ctx.netHandler);
        thread.func_152344_a(() -> message.process(ctx));
        return null;
    }

    public static void sendToPlayersWatchingChunk(FLMessage message, World world, BlockPos pos) {
        PlayerChunkMap map = ((WorldServer)world).func_184164_w();
        PlayerChunkMapEntry e = map.func_187301_b(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
        if (e != null) {
            e.func_187267_a(FairyLights.network.getPacketFrom((IMessage)message));
        }
    }

    public static void sendToPlayersWatchingEntity(FLMessage message, World world, Entity entity) {
        for (EntityPlayer player : ((WorldServer)world).func_73039_n().getTrackingPlayers(entity)) {
            FairyLights.network.sendTo((IMessage)message, (EntityPlayerMP)player);
        }
        if (entity instanceof EntityPlayerMP) {
            FairyLights.network.sendTo((IMessage)message, (EntityPlayerMP)entity);
        }
    }

    public static BlockView buildBlockView() {
        CreateBlockViewEvent evt = new CreateBlockViewEvent(new RegularBlockView());
        MinecraftForge.EVENT_BUS.post((Event)evt);
        return evt.getView();
    }

    private void registerMessage(Class<? extends FLMessage> clazz, Side toSide) {
        FairyLights.network.registerMessage((IMessageHandler)this, clazz, this.nextMessageId++, toSide);
    }

    public void initIntegration() {
        if (Loader.isModLoaded((String)"valkyrienskies")) {
            Class<?> vs;
            try {
                vs = Class.forName("com.pau101.fairylights.server.integration.valkyrienskies.ValkyrienSkies");
            }
            catch (ClassNotFoundException e) {
                throw new AssertionError((Object)e);
            }
            MinecraftForge.EVENT_BUS.register(vs);
        }
    }
}

