/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.joml.Math;
import org.joml.MemUtil;
import org.joml.Options;
import org.joml.Vector2ic;
import org.joml.Vector3dc;
import org.joml.Vector3ic;

public class Vector3i
implements Externalizable,
Vector3ic {
    private static final long serialVersionUID = 1L;
    public int x;
    public int y;
    public int z;

    public Vector3i() {
    }

    public Vector3i(int d) {
        this(d, d, d);
    }

    public Vector3i(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3i(Vector3ic v) {
        this.x = v.x();
        this.y = v.y();
        this.z = v.z();
    }

    public Vector3i(Vector2ic v, int z) {
        this.x = v.x();
        this.y = v.y();
        this.z = z;
    }

    public Vector3i(ByteBuffer buffer) {
        this(buffer.position(), buffer);
    }

    public Vector3i(int index, ByteBuffer buffer) {
        MemUtil.INSTANCE.get(this, index, buffer);
    }

    public Vector3i(IntBuffer buffer) {
        this(buffer.position(), buffer);
    }

    public Vector3i(int index, IntBuffer buffer) {
        MemUtil.INSTANCE.get(this, index, buffer);
    }

    public int x() {
        return this.x;
    }

    public int y() {
        return this.y;
    }

    public int z() {
        return this.z;
    }

    public Vector3i set(Vector3ic v) {
        this.x = v.x();
        this.y = v.y();
        this.z = v.z();
        return this;
    }

    public Vector3i set(Vector3dc v) {
        this.x = (int)v.x();
        this.y = (int)v.y();
        this.z = (int)v.z();
        return this;
    }

    public Vector3i set(Vector2ic v, int z) {
        this.x = v.x();
        this.y = v.y();
        this.z = z;
        return this;
    }

    public Vector3i set(int d) {
        return this.set(d, d, d);
    }

    public Vector3i set(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public Vector3i set(ByteBuffer buffer) {
        return this.set(buffer.position(), buffer);
    }

    public Vector3i set(int index, ByteBuffer buffer) {
        MemUtil.INSTANCE.get(this, index, buffer);
        return this;
    }

    public Vector3i set(IntBuffer buffer) {
        return this.set(buffer.position(), buffer);
    }

    public Vector3i set(int index, IntBuffer buffer) {
        MemUtil.INSTANCE.get(this, index, buffer);
        return this;
    }

    public Vector3i setComponent(int component, int value) throws IllegalArgumentException {
        switch (component) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            case 2: {
                this.z = value;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return this;
    }

    public IntBuffer get(IntBuffer buffer) {
        return this.get(buffer.position(), buffer);
    }

    public IntBuffer get(int index, IntBuffer buffer) {
        MemUtil.INSTANCE.put(this, index, buffer);
        return buffer;
    }

    public ByteBuffer get(ByteBuffer buffer) {
        return this.get(buffer.position(), buffer);
    }

    public ByteBuffer get(int index, ByteBuffer buffer) {
        MemUtil.INSTANCE.put(this, index, buffer);
        return buffer;
    }

    public Vector3i sub(Vector3ic v) {
        this.x -= v.x();
        this.y -= v.y();
        this.z -= v.z();
        return this;
    }

    public Vector3i sub(Vector3ic v, Vector3i dest) {
        dest.x = this.x - v.x();
        dest.y = this.y - v.y();
        dest.z = this.z - v.z();
        return dest;
    }

    public Vector3i sub(int x, int y, int z) {
        this.x -= x;
        this.y -= y;
        this.z -= z;
        return this;
    }

    public Vector3i sub(int x, int y, int z, Vector3i dest) {
        dest.x = this.x - x;
        dest.y = this.y - y;
        dest.z = this.z - z;
        return dest;
    }

    public Vector3i add(Vector3ic v) {
        this.x += v.x();
        this.y += v.y();
        this.z += v.z();
        return this;
    }

    public Vector3i add(Vector3ic v, Vector3i dest) {
        dest.x = this.x + v.x();
        dest.y = this.y + v.y();
        dest.z = this.z + v.z();
        return dest;
    }

    public Vector3i add(int x, int y, int z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public Vector3i add(int x, int y, int z, Vector3i dest) {
        dest.x = this.x + x;
        dest.y = this.y + y;
        dest.z = this.z + z;
        return dest;
    }

    public Vector3i mul(int scalar) {
        this.x *= scalar;
        this.y *= scalar;
        this.z *= scalar;
        return this;
    }

    public Vector3i mul(int scalar, Vector3i dest) {
        dest.x = this.x * scalar;
        dest.y = this.y * scalar;
        dest.y = this.z * scalar;
        return dest;
    }

    public Vector3i mul(Vector3ic v) {
        this.x += v.x();
        this.y += v.y();
        this.z += v.z();
        return this;
    }

    public Vector3i mul(Vector3ic v, Vector3i dest) {
        dest.x = this.x * v.x();
        dest.y = this.y * v.y();
        dest.z = this.z * v.z();
        return dest;
    }

    public Vector3i mul(int x, int y, int z) {
        this.x *= x;
        this.y *= y;
        this.z *= z;
        return this;
    }

    public Vector3i mul(int x, int y, int z, Vector3i dest) {
        dest.x = this.x * x;
        dest.y = this.y * y;
        dest.z = this.z * z;
        return dest;
    }

    public long lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public double length() {
        return Math.sqrt(this.lengthSquared());
    }

    public double distance(Vector3ic v) {
        return Math.sqrt(this.distanceSquared(v));
    }

    public double distance(int x, int y, int z) {
        return Math.sqrt(this.distanceSquared(x, y, z));
    }

    public long distanceSquared(Vector3ic v) {
        int dx = this.x - v.x();
        int dy = this.y - v.y();
        int dz = this.z - v.z();
        return dx * dx + dy * dy + dz * dz;
    }

    public long distanceSquared(int x, int y, int z) {
        int dx = this.x - x;
        int dy = this.y - y;
        int dz = this.z - z;
        return dx * dx + dy * dy + dz * dz;
    }

    public Vector3i zero() {
        this.x = 0;
        this.y = 0;
        this.z = 0;
        return this;
    }

    public String toString() {
        DecimalFormat formatter = new DecimalFormat(" 0.000E0;-");
        String str = this.toString(formatter);
        StringBuffer res = new StringBuffer();
        int eIndex = Integer.MIN_VALUE;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == 'E') {
                eIndex = i;
            } else {
                if (c == ' ' && eIndex == i - 1) {
                    res.append('+');
                    continue;
                }
                if (Character.isDigit(c) && eIndex == i - 1) {
                    res.append('+');
                }
            }
            res.append(c);
        }
        return res.toString();
    }

    public String toString(NumberFormat formatter) {
        return "(" + formatter.format(this.x) + " " + formatter.format(this.y) + " " + formatter.format(this.z) + ")";
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.x);
        out.writeInt(this.y);
        out.writeInt(this.z);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.x = in.readInt();
        this.y = in.readInt();
        this.z = in.readInt();
    }

    public Vector3i negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public Vector3i negate(Vector3i dest) {
        dest.x = -this.x;
        dest.y = -this.y;
        dest.z = -this.z;
        return dest;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.z;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vector3i other = (Vector3i)obj;
        if (this.x != other.x) {
            return false;
        }
        if (this.y != other.y) {
            return false;
        }
        return this.z == other.z;
    }

    public Vector3ic toImmutable() {
        if (!Options.DEBUG) {
            return this;
        }
        return new Proxy(this);
    }

    private final class Proxy
    implements Vector3ic {
        private final Vector3ic delegate;

        Proxy(Vector3ic delegate) {
            this.delegate = delegate;
        }

        public int x() {
            return this.delegate.x();
        }

        public int y() {
            return this.delegate.y();
        }

        public int z() {
            return this.delegate.z();
        }

        public IntBuffer get(IntBuffer buffer) {
            return this.delegate.get(buffer);
        }

        public IntBuffer get(int index, IntBuffer buffer) {
            return this.delegate.get(index, buffer);
        }

        public ByteBuffer get(ByteBuffer buffer) {
            return this.delegate.get(buffer);
        }

        public ByteBuffer get(int index, ByteBuffer buffer) {
            return this.delegate.get(index, buffer);
        }

        public Vector3i sub(Vector3ic v, Vector3i dest) {
            return this.delegate.sub(v, dest);
        }

        public Vector3i sub(int x, int y, int z, Vector3i dest) {
            return this.delegate.sub(x, y, z, dest);
        }

        public Vector3i add(Vector3ic v, Vector3i dest) {
            return this.delegate.add(v, dest);
        }

        public Vector3i add(int x, int y, int z, Vector3i dest) {
            return this.delegate.add(x, y, z, dest);
        }

        public Vector3i mul(int scalar, Vector3i dest) {
            return this.delegate.mul(scalar, dest);
        }

        public Vector3i mul(Vector3ic v, Vector3i dest) {
            return this.delegate.mul(v, dest);
        }

        public Vector3i mul(int x, int y, int z, Vector3i dest) {
            return this.delegate.mul(x, y, z, dest);
        }

        public long lengthSquared() {
            return this.delegate.lengthSquared();
        }

        public double length() {
            return this.delegate.length();
        }

        public double distance(Vector3ic v) {
            return this.delegate.distance(v);
        }

        public double distance(int x, int y, int z) {
            return this.delegate.distance(x, y, z);
        }

        public long distanceSquared(Vector3ic v) {
            return this.delegate.distanceSquared(v);
        }

        public long distanceSquared(int x, int y, int z) {
            return this.delegate.distanceSquared(x, y, z);
        }

        public Vector3i negate(Vector3i dest) {
            return this.delegate.negate(dest);
        }
    }
}

