/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.lootcapacitortooltips;

import com.tfar.lootcapacitortooltips.LootCapacitorTooltips;
import crazypants.enderio.base.capacitor.ItemCapacitor;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="lootcapacitortooltips")
public class Tooltips {
    @Config.Name(value="Enable Flavor Text?")
    public static boolean enableFlavorText = false;
    @Config.Name(value="Precision")
    public static int round = 2;
    @Config.Name(value="Show Levels of Regular Capacitors?")
    public static boolean showRegularCapacitors = true;
    @Config.Name(value="Show Levels of Endergy Capacitors?")
    public static boolean showEndergyCapacitors = true;
    @Config.Name(value="Show Durability of Totemic Capacitor?")
    public static boolean showTotemicDurability = true;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onItemTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.func_77973_b() instanceof ItemCapacitor && (stack.func_77952_i() == 3 || stack.func_77952_i() == 4)) {
            NBTTagCompound nbtCap;
            float level;
            NBTTagCompound nbt = stack.func_77978_p();
            ArrayList tooltip = (ArrayList)event.getToolTip();
            if (!enableFlavorText) {
                tooltip.remove(3);
            }
            if ((level = (nbtCap = nbt.func_74775_l("eiocap")).func_74760_g("level")) > 5.0f) {
                tooltip.add(I18n.func_135052_a((String)LootCapacitorTooltips.s1, (Object[])new Object[0]) + " " + TextFormatting.WHITE + TextFormatting.BOLD + Tooltips.roundAvoid(level, round));
            } else if (level >= 1.0f) {
                tooltip.add(I18n.func_135052_a((String)LootCapacitorTooltips.s1, (Object[])new Object[0]) + " " + TextFormatting.func_175744_a((int)Tooltips.getColor(level)) + Tooltips.roundAvoid(level, round));
            } else {
                tooltip.add(I18n.func_135052_a((String)LootCapacitorTooltips.s1, (Object[])new Object[0]) + " " + TextFormatting.DARK_RED + TextFormatting.BOLD + Tooltips.roundAvoid(level, round));
            }
            TreeMap<String, Float> machines = new TreeMap<String, Float>();
            machines.put("painter", Float.valueOf(nbtCap.func_74760_g(LootCapacitorTooltips.s2 + "painter/use")));
            machines.put("combustion", Float.valueOf(nbtCap.func_74760_g(LootCapacitorTooltips.s2 + "combustion_generator/gen")));
            machines.put("enhanced_combustion", Float.valueOf(nbtCap.func_74760_g(LootCapacitorTooltips.s2 + "enhanced_combustion_generator/gen")));
            machines.put("alloy_smelter", Float.valueOf(nbtCap.func_74760_g(LootCapacitorTooltips.s2 + "alloy_smelter/use")));
            machines.put("vat", Float.valueOf(nbtCap.func_74760_g(LootCapacitorTooltips.s2 + "vat/use")));
            machines.put("farm_station", Float.valueOf(nbtCap.func_74760_g(LootCapacitorTooltips.s2 + "farm_station/bonus_size")));
            machines.put("slice_and_splice", Float.valueOf(nbtCap.func_74760_g(LootCapacitorTooltips.s2 + "slice_and_splice/use")));
            machines.put("energy_intake", Float.valueOf(nbtCap.func_74760_g("energy_intake")));
            machines.put("sag_mill", Float.valueOf(nbtCap.func_74760_g(LootCapacitorTooltips.s2 + "sag_mill/use")));
            machines.put("stirling_generator", Float.valueOf(nbtCap.func_74760_g(LootCapacitorTooltips.s2 + "stirling_generator/gen")));
            machines.put("powered_spawner", Float.valueOf(nbtCap.func_74760_g(LootCapacitorTooltips.s2 + "powered_spawner/speed")));
            machines.put("soul_binder", Float.valueOf(nbtCap.func_74760_g(LootCapacitorTooltips.s2 + "soul_binder/use")));
            machines.put("energy_buffer", Float.valueOf(nbtCap.func_74760_g("energy_buffer")));
            machines.put("area", Float.valueOf(nbtCap.func_74760_g("area")));
            for (Map.Entry machine : machines.entrySet()) {
                Float value = (Float)machine.getValue();
                if (value.floatValue() == 0.0f) continue;
                String key = (String)machine.getKey();
                if (value.floatValue() >= 1.0f) {
                    tooltip.add(I18n.func_135052_a((String)(LootCapacitorTooltips.s3 + key), (Object[])new Object[0]) + " " + TextFormatting.func_175744_a((int)Tooltips.getColor(value.floatValue())) + Tooltips.roundAvoid(value.floatValue(), round));
                    continue;
                }
                tooltip.add(I18n.func_135052_a((String)(LootCapacitorTooltips.s3 + key), (Object[])new Object[0]) + " " + TextFormatting.DARK_RED + TextFormatting.BOLD + Tooltips.roundAvoid(value.floatValue(), round));
            }
        } else if (stack.func_77973_b() instanceof ItemCapacitor && showRegularCapacitors) {
            int l = stack.func_77952_i() + 1;
            ArrayList tooltip = (ArrayList)event.getToolTip();
            tooltip.add(I18n.func_135052_a((String)LootCapacitorTooltips.s1, (Object[])new Object[0]) + " " + TextFormatting.func_175744_a((int)Tooltips.getColor(l)) + l);
        }
    }

    public static double roundAvoid(float value, int places) {
        double scale = Math.pow(10.0, places);
        return (double)Math.round((double)value * scale) / scale;
    }

    public static int getColor(float key) {
        int color = (int)Math.floor(key);
        switch (color) {
            case 0: {
                return 4;
            }
            case 1: {
                return 12;
            }
            case 2: {
                return 14;
            }
            case 3: {
                return 10;
            }
            case 4: {
                return 11;
            }
            case 5: {
                return 15;
            }
        }
        return -1;
    }
}

