/*
 * Decompiled with CFR 0.152.
 */
package subaraki.paintings.mod.server.proxy;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import net.minecraftforge.fml.common.Loader;
import subaraki.paintings.config.ConfigurationHandler;
import subaraki.paintings.mod.IPaintingsProxy;
import subaraki.paintings.mod.Paintings;

public class ServerProxy
implements IPaintingsProxy {
    @Override
    public void registerRenderInformation() {
    }

    @Override
    public JsonObject getPatternFile(String patternName) {
        File configDirectory = Loader.instance().getConfigDir();
        Gson gson = new Gson();
        String[] validPatternDirectories = new String[]{"morepaintings", "paintings--", "Paintings--"};
        String patternFileName = patternName + ".json";
        try {
            InputStream in = null;
            for (String child : validPatternDirectories) {
                File patternFile;
                File patternDirectory = new File(configDirectory, child);
                if (!patternDirectory.exists() || !(patternFile = new File(patternDirectory, patternFileName)).exists() || !patternFile.canRead()) continue;
                in = new FileInputStream(patternFile);
                Paintings.log.info(patternFileName + " found in " + patternDirectory);
                break;
            }
            if (in == null && Arrays.asList(ConfigurationHandler.BUILTIN_PATTERNS).contains(patternName)) {
                in = Paintings.class.getResourceAsStream("/assets/subaraki/patterns/" + patternFileName);
                Paintings.log.info("Loading built-in " + patternName + " pattern");
            } else {
                in = Paintings.class.getResourceAsStream("/assets/subaraki/patterns/vanilla.json");
                Paintings.log.info("Unable to locate " + patternFileName + ". Defaulting to vanilla pattern.");
            }
            if (in != null) {
                BufferedReader resourceReader = new BufferedReader(new InputStreamReader(in));
                return ((JsonElement)gson.fromJson((Reader)resourceReader, JsonElement.class)).getAsJsonObject();
            }
            Paintings.log.error("Unable to find a valid pattern. Use of paintings will crash you Minecraft instance.");
        }
        catch (Exception e) {
            Paintings.log.error(e.getLocalizedMessage());
        }
        return null;
    }

    @Override
    public void configurePaintingsGuiButtonTexture() {
    }
}

