/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.base.channels;

import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.IItemHandler;
import sonar.core.api.utils.BlockCoords;
import sonar.logistics.base.channels.NodeConnection;
import sonar.logistics.base.channels.NodeConnectionType;
import sonar.logistics.base.data.generators.items.ITileInventoryProvider;
import sonar.logistics.base.tiles.INetworkTile;
import sonar.logistics.base.utils.LogisticsHelper;
import sonar.logistics.core.tiles.displays.info.MasterInfoRegistry;
import sonar.logistics.core.tiles.displays.info.types.channels.MonitoredBlockCoords;

public class BlockConnection
extends NodeConnection<MonitoredBlockCoords> {
    public BlockCoords coords;
    public EnumFacing face;

    public BlockConnection(INetworkTile source, BlockCoords coords, EnumFacing face) {
        super(source);
        this.coords = coords;
        this.face = face;
    }

    public int hashCode() {
        return this.coords.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof BlockConnection) {
            return ((BlockConnection)obj).coords.equals((Object)this.coords);
        }
        return false;
    }

    @Override
    public MonitoredBlockCoords getChannel() {
        return new MonitoredBlockCoords(this.coords, LogisticsHelper.getCoordItem(this.coords, this.coords.getWorld()));
    }

    @Override
    @Nullable
    public IItemHandler getItemHandler() {
        TileEntity tile = this.coords.getTileEntity();
        if (tile != null) {
            for (ITileInventoryProvider provider : MasterInfoRegistry.INSTANCE.inventoryProviders) {
                IItemHandler handler = provider.getHandler(tile, this.face);
                if (handler == null) continue;
                return handler;
            }
        }
        return null;
    }

    @Override
    public NodeConnectionType getType() {
        return NodeConnectionType.TILE;
    }
}

