/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.base.data.generators.items;

import appeng.api.AEApi;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AEPartLocation;
import appeng.core.Api;
import appeng.me.helpers.IGridProxyable;
import appeng.me.helpers.MachineSource;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.IItemHandler;
import sonar.core.api.utils.ActionType;
import sonar.core.integration.AE2Helper;
import sonar.logistics.api.asm.ASMTileInventoryProvider;
import sonar.logistics.base.data.generators.items.ITileInventoryProvider;
import sonar.logistics.core.tiles.displays.info.types.items.ItemChangeableList;

@ASMTileInventoryProvider(modid="appliedenergistics2", priority=0)
public class TileInventoryAE2
implements ITileInventoryProvider {
    @Override
    @Nullable
    public IItemHandler getHandler(TileEntity tile, EnumFacing face) {
        IGridNode gridNode;
        if (tile instanceof IGridProxyable && (gridNode = ((IGridProxyable)tile).getGridNode(AEPartLocation.fromFacing((EnumFacing)face))) != null) {
            IStorageGrid grid = (IStorageGrid)gridNode.getGrid().getCache(IStorageGrid.class);
            IMEMonitor items = grid.getInventory(Api.INSTANCE.storage().getStorageChannel(IItemStorageChannel.class));
            return new AE2ItemHandler((IActionHost)tile, (IMEMonitor<IAEItemStack>)items);
        }
        return null;
    }

    @Override
    public void getItemList(ItemChangeableList list, IItemHandler handler, TileEntity tile, EnumFacing face) {
        IGridNode gridNode = ((IGridProxyable)tile).getGridNode(AEPartLocation.fromFacing((EnumFacing)face));
        if (gridNode != null) {
            IStorageGrid grid = (IStorageGrid)gridNode.getGrid().getCache(IStorageGrid.class);
            IItemList items = grid.getInventory(Api.INSTANCE.storage().getStorageChannel(IItemStorageChannel.class)).getStorageList();
            items.forEach(i -> list.add(i.asItemStackRepresentation(), i.getStackSize(), i.getStackSize()));
        }
    }

    public static class AE2ItemHandler
    implements IItemHandler {
        public final IActionHost tile;
        public IMEMonitor<IAEItemStack> items;
        public IItemList<IAEItemStack> list;

        public AE2ItemHandler(IActionHost tile, IMEMonitor<IAEItemStack> items) {
            this.tile = tile;
            this.items = items;
            this.list = items.getStorageList();
        }

        public int getSlots() {
            return this.list.size() + 1;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            if (slot == 0) {
                return ItemStack.field_190927_a;
            }
            int i = 0;
            for (IAEItemStack item : this.list) {
                if (i == slot - 1) {
                    ItemStack stack = item.asItemStackRepresentation().func_77946_l();
                    stack.func_190920_e(Math.min((int)Math.min(Integer.MAX_VALUE, item.getStackSize()), 64));
                    return stack;
                }
                ++i;
            }
            return ItemStack.field_190927_a;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            IAEItemStack aeStack = (IAEItemStack)((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createStack((Object)stack);
            if (aeStack != null) {
                IAEItemStack injected = (IAEItemStack)this.items.injectItems((IAEStack)aeStack, AE2Helper.getActionable((ActionType)ActionType.getTypeForAction((boolean)simulate)), (IActionSource)new MachineSource(this.tile));
                return injected != null ? injected.createItemStack().func_77946_l() : ItemStack.field_190927_a;
            }
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot == 0) {
                return ItemStack.field_190927_a;
            }
            ItemStack stack = this.getStackInSlot(slot);
            stack.func_190920_e(amount);
            IAEItemStack aeStack = (IAEItemStack)((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createStack((Object)stack);
            if (aeStack == null) {
                return ItemStack.field_190927_a;
            }
            IAEItemStack extracted = (IAEItemStack)this.items.extractItems((IAEStack)aeStack, AE2Helper.getActionable((ActionType)ActionType.getTypeForAction((boolean)simulate)), (IActionSource)new MachineSource(this.tile));
            return extracted == null ? ItemStack.field_190927_a : extracted.createItemStack().func_77946_l();
        }

        public int getSlotLimit(int slot) {
            return 64;
        }
    }
}

