/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.base.gui.buttons;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sonar.core.client.gui.GuiHelpOverlay;
import sonar.core.client.gui.GuiSonar;
import sonar.core.client.gui.SonarButtons;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.SonarHelper;
import sonar.logistics.PL2Translate;

@SideOnly(value=Side.CLIENT)
public class LogisticsButton
extends SonarButtons.AnimatedButton {
    public static final ResourceLocation logisticsButtons = new ResourceLocation("practicallogistics2:textures/gui/filter_buttons.png");
    public GuiSonar sonar;
    public String buttonText;
    public int texX;
    public int texY;
    public List<String> description;

    public LogisticsButton(GuiSonar sonar, int id, int x, int y, int texX, int texY, String buttonText, String helpKey) {
        this(sonar, id, x, y, texX, texY, 16, 16, buttonText, helpKey);
    }

    public LogisticsButton(GuiSonar sonar, int id, int x, int y, int texX, int texY, int xSize, int ySize, String buttonText, String helpKey) {
        super(id, x, y, logisticsButtons, xSize - 1, ySize - 1);
        this.description = Lists.newArrayList((Object[])new String[]{buttonText});
        List array = SonarHelper.convertArray((Object[])FontHelper.translate((String)helpKey).split("-"));
        for (String des : array) {
            if (des.isEmpty()) continue;
            this.description.add(TextFormatting.GRAY + des);
        }
        this.sonar = sonar;
        this.buttonText = buttonText;
        this.texX = texX;
        this.texY = texY;
    }

    public void func_146111_b(int x, int y) {
        if (this.field_146123_n) {
            if (GuiHelpOverlay.enableHelp) {
                this.sonar.drawSpecialToolTip(this.description, this.sonar.getGuiLeft() + x, this.sonar.getGuiTop() + y, null);
            } else {
                this.sonar.drawSonarCreativeTabHoveringText(this.buttonText, x, y);
            }
        }
    }

    public void onClicked() {
    }

    public int getTextureX() {
        return this.texX;
    }

    public int getTextureY() {
        return this.texY;
    }

    public static class HELP
    extends LogisticsButton {
        public HELP(GuiSonar sonar, int id, int x, int y) {
            super(sonar, id, x, y, 32, 192 + (GuiHelpOverlay.enableHelp ? 16 : 0), PL2Translate.BUTTON_HELP_ENABLED.t() + ": " + GuiHelpOverlay.enableHelp, "button.HelpButton");
        }
    }

    public static class CHANNELS
    extends LogisticsButton {
        public CHANNELS(GuiSonar sonar, int id, int x, int y) {
            super(sonar, id, x, y, 32, 112, PL2Translate.BUTTON_CHANNELS.t(), "button.Channels");
        }
    }
}

