/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.base.guidance.errors;

import java.util.ArrayList;
import java.util.List;
import sonar.core.translate.Localisation;
import sonar.logistics.base.guidance.state.IState;

public enum ErrorMessage implements IState
{
    NO_NETWORK(false),
    NO_READER_SELECTED(true),
    NO_EMITTERS_CONNECTED(true),
    EMITTERS_OFFLINE(true),
    NO_DATA_SELECTED(true),
    NO_STACK_SELECTED(true),
    NO_FLUID_SELECTED(true),
    NO_STATEMENTS(true),
    READER_DISCONNECTED(true),
    READER_DESTROYED(true);

    public boolean canOpen;
    public Localisation message;

    private ErrorMessage(boolean canOpen) {
        this.canOpen = canOpen;
        this.message = new Localisation("pl.states." + this.name().toLowerCase());
    }

    @Override
    public boolean canOpenTile() {
        return this.canOpen;
    }

    @Override
    public String getStateMessage() {
        return this.message.t();
    }

    @Override
    public int getStateID() {
        return this.ordinal();
    }

    public static List<Localisation> getLocalisations(List<Localisation> current) {
        for (ErrorMessage message : ErrorMessage.values()) {
            current.add(message.message);
        }
        return current;
    }

    public static byte[] toBytes(List<ErrorMessage> errors) {
        byte[] bytes = new byte[errors.size()];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)errors.get(i).ordinal();
        }
        return bytes;
    }

    public static List<ErrorMessage> fromBytes(byte[] bytes) {
        ArrayList<ErrorMessage> errors = new ArrayList<ErrorMessage>();
        for (byte aByte : bytes) {
            errors.add(ErrorMessage.values()[aByte]);
        }
        return errors;
    }
}

