/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.connections.data.handling;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import sonar.core.helpers.ListHelper;
import sonar.core.utils.Pair;
import sonar.logistics.PL2;
import sonar.logistics.api.core.tiles.connections.EnumCableConnectionType;
import sonar.logistics.api.core.tiles.connections.data.IDataCable;
import sonar.logistics.api.core.tiles.connections.data.network.ILogisticsNetwork;
import sonar.logistics.api.core.tiles.readers.IInfoProvider;
import sonar.logistics.base.events.types.NetworkEvent;
import sonar.logistics.base.tiles.INetworkTile;
import sonar.logistics.core.tiles.connections.data.handling.AbstractConnectionHandler;
import sonar.logistics.core.tiles.connections.data.handling.CableConnectionHelper;
import sonar.logistics.core.tiles.connections.data.network.EmptyLogisticsNetwork;
import sonar.logistics.core.tiles.connections.data.network.LogisticsNetworkHandler;

public class CableConnectionHandler
extends AbstractConnectionHandler<IDataCable> {
    public List<IDataCable> updateRenders = new ArrayList<IDataCable>();
    public List<Integer> changedNetworks = new ArrayList<Integer>();
    public List<IDataCable> cableUpdates = new ArrayList<IDataCable>();
    public Map<IDataCable, List<INetworkTile>> cable_tiles = new HashMap<IDataCable, List<INetworkTile>>();
    public Map<IDataCable, List<IInfoProvider>> cable_providers = new HashMap<IDataCable, List<IInfoProvider>>();
    public Map<IInfoProvider, Integer> info_providers = new HashMap<IInfoProvider, Integer>();

    public static CableConnectionHandler instance() {
        return PL2.proxy.cableManager;
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.updateRenders.clear();
        this.changedNetworks.clear();
        this.cableUpdates.clear();
        this.cable_tiles.clear();
        this.cable_providers.clear();
        this.info_providers.clear();
    }

    public void addRenderUpdate(IDataCable cable) {
        ListHelper.addWithCheck(this.updateRenders, (Object)cable);
    }

    public void doRenderUpdates() {
        if (!this.updateRenders.isEmpty()) {
            this.updateRenders.forEach(IDataCable::updateCableRenders);
            this.updateRenders.clear();
        }
    }

    public ILogisticsNetwork getOrCreateNetwork(int networkID) {
        return LogisticsNetworkHandler.instance().getOrCreateNetwork(networkID);
    }

    public ILogisticsNetwork getSubNetwork(IInfoProvider provider) {
        Integer connected_network = this.info_providers.get(provider);
        if (connected_network == null) {
            return EmptyLogisticsNetwork.INSTANCE;
        }
        return LogisticsNetworkHandler.instance().getNetwork(connected_network);
    }

    public void onDataCableRemove(IDataCable cable) {
        List cached = this.cable_tiles.getOrDefault(cable, new ArrayList());
        for (INetworkTile tile : cached) {
            if (!tile.getNetwork().isValid()) continue;
            MinecraftForge.EVENT_BUS.post((Event)new NetworkEvent.DisconnectedTile(tile.getNetwork(), tile));
        }
        List cached_providers = this.cable_providers.getOrDefault(cable, new ArrayList());
        for (IInfoProvider tile : cached_providers) {
            ILogisticsNetwork subNetwork = this.getSubNetwork(tile);
            if (!subNetwork.isValid()) continue;
            MinecraftForge.EVENT_BUS.post((Event)new NetworkEvent.DisconnectedLocalProvider(subNetwork, tile));
            this.info_providers.remove(tile);
        }
        this.cable_tiles.remove(cable);
        this.cable_providers.remove(cable);
    }

    public void updateConnectedTiles(IDataCable cable, ILogisticsNetwork network) {
        List cached = this.cable_tiles.getOrDefault(cable, new ArrayList());
        List<INetworkTile> updated = CableConnectionHelper.getConnectedTiles(cable);
        for (INetworkTile tile : cached) {
            if (updated.contains(tile) || !tile.getNetwork().isValid()) continue;
            MinecraftForge.EVENT_BUS.post((Event)new NetworkEvent.DisconnectedTile(tile.getNetwork(), tile));
        }
        for (INetworkTile tile : updated) {
            if (tile.getNetwork() == network) continue;
            if (tile.getNetwork().isValid()) {
                MinecraftForge.EVENT_BUS.post((Event)new NetworkEvent.DisconnectedTile(tile.getNetwork(), tile));
            }
            MinecraftForge.EVENT_BUS.post((Event)new NetworkEvent.ConnectedTile(network, tile));
        }
        this.cable_tiles.put(cable, updated);
    }

    public void updateInfoProviders(IDataCable cable, ILogisticsNetwork network) {
        ILogisticsNetwork subNetwork;
        List cached_providers = this.cable_providers.getOrDefault(cable, new ArrayList());
        List<IInfoProvider> updated_providers = CableConnectionHelper.getLocalMonitors(cable);
        for (IInfoProvider tile : cached_providers) {
            subNetwork = this.getSubNetwork(tile);
            if (updated_providers.contains(tile) || !subNetwork.isValid()) continue;
            MinecraftForge.EVENT_BUS.post((Event)new NetworkEvent.DisconnectedLocalProvider(subNetwork, tile));
            this.info_providers.remove(tile);
        }
        for (IInfoProvider tile : updated_providers) {
            subNetwork = this.getSubNetwork(tile);
            if (subNetwork.isValid() && subNetwork != network) {
                MinecraftForge.EVENT_BUS.post((Event)new NetworkEvent.DisconnectedLocalProvider(subNetwork, tile));
            }
            if (subNetwork.isValid() && subNetwork == network) continue;
            MinecraftForge.EVENT_BUS.post((Event)new NetworkEvent.ConnectedLocalProvider(network, tile));
            this.info_providers.put(tile, network.getNetworkID());
        }
        this.cable_providers.put(cable, updated_providers);
    }

    public void doQueuedUpdates() {
        for (IDataCable cable : this.cableUpdates) {
            if (cable.getRegistryID() == -1) {
                this.onDataCableRemove(cable);
                continue;
            }
            ILogisticsNetwork network = this.getOrCreateNetwork(cable.getRegistryID());
            this.updateConnectedTiles(cable, network);
            this.updateInfoProviders(cable, network);
        }
        this.cableUpdates.clear();
        for (Integer id : this.changedNetworks) {
            ILogisticsNetwork network;
            List cables = this.getConnections(id);
            if (!cables.isEmpty() || !(network = LogisticsNetworkHandler.instance().getNetwork(id)).isValid()) continue;
            network.onNetworkRemoved();
        }
        this.changedNetworks.clear();
    }

    public void queueNetworkChange(int networkID) {
        ListHelper.addWithCheck(this.changedNetworks, (Object)networkID);
    }

    public void queueCableUpdate(IDataCable cable) {
        ListHelper.addWithCheck(this.cableUpdates, (Object)cable);
        this.addRenderUpdate(cable);
    }

    @Override
    public Pair<EnumCableConnectionType, Integer> getConnectionType(IDataCable source, World world, BlockPos pos, EnumFacing dir, EnumCableConnectionType cableType) {
        return CableConnectionHelper.getCableConnection(source, world, pos, dir, cableType);
    }

    @Override
    public void onNetworksConnected(int newID, int oldID) {
        this.NetworkManager().connectNetworks(oldID, newID);
    }

    @Override
    public void onConnectionAdded(int registryID, IDataCable added) {
        this.queueCableUpdate(added);
    }

    @Override
    public void onConnectionRemoved(int id, IDataCable removed) {
        this.queueCableUpdate(removed);
    }

    @Override
    public void onNetworksDisconnected(List<Integer> newNetworks) {
        ListHelper.addWithCheck(this.changedNetworks, newNetworks);
    }

    @Override
    public int getNextAvailableID() {
        return LogisticsNetworkHandler.instance().getNextIdentity();
    }

    @Override
    public void addConnectionToNetwork(IDataCable add) {
        int networkID = this.addConnection(add);
        this.queueNetworkChange(networkID);
    }

    @Override
    public void removeConnectionFromNetwork(IDataCable remove) {
        this.removeConnection(remove);
        this.queueNetworkChange(remove.getRegistryID());
    }
}

