/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.connections.redstone.handling;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mcmultipart.api.multipart.MultipartHelper;
import mcmultipart.api.slot.EnumCenterSlot;
import mcmultipart.api.slot.IPartSlot;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import sonar.core.integration.multipart.SonarMultipartHelper;
import sonar.logistics.PL2Blocks;
import sonar.logistics.PL2Properties;
import sonar.logistics.api.core.tiles.connections.EnumCableConnection;
import sonar.logistics.api.core.tiles.connections.ICableConnectable;
import sonar.logistics.api.core.tiles.connections.redstone.IRedstoneCable;
import sonar.logistics.api.core.tiles.connections.redstone.IRedstoneConnectable;
import sonar.logistics.core.tiles.connections.data.handling.CableConnectionHelper;
import sonar.logistics.core.tiles.connections.redstone.tiles.BlockRedstoneCable;
import sonar.logistics.core.tiles.connections.redstone.tiles.TileRedstoneCable;

public class RedstoneConnectionHelper {
    public static int getPower(IBlockState state, World world, BlockPos pos, EnumFacing face) {
        IBlockState iblockstate1 = world.func_180495_p(pos);
        return iblockstate1.func_177230_c().shouldCheckWeakPower(iblockstate1, (IBlockAccess)world, pos, face) ? world.func_175676_y(pos) : iblockstate1.func_185911_a((IBlockAccess)world, pos, face);
    }

    public static List<IRedstoneConnectable> getConnectables(IRedstoneCable cable) {
        ArrayList<IRedstoneConnectable> logicTiles = new ArrayList<IRedstoneConnectable>();
        for (EnumFacing face : EnumFacing.values()) {
            ICableConnectable connection = CableConnectionHelper.getConnection(cable, face, EnumCableConnection.NETWORK, false);
            if (connection == null || connection instanceof IRedstoneCable || !(connection instanceof IRedstoneConnectable)) continue;
            logicTiles.add((IRedstoneConnectable)connection);
        }
        return logicTiles;
    }

    public static TileRedstoneCable getCable(IBlockAccess world, BlockPos pos) {
        IBlockAccess actualWorld = SonarMultipartHelper.unwrapBlockAccess((IBlockAccess)world);
        TileEntity tile = actualWorld.func_175625_s(pos);
        if (tile != null) {
            if (tile instanceof TileRedstoneCable) {
                return (TileRedstoneCable)tile;
            }
            Optional cable = MultipartHelper.getPartTile((IBlockAccess)actualWorld, (BlockPos)pos, (IPartSlot)EnumCenterSlot.CENTER);
            if (cable.isPresent() && cable.get() instanceof TileRedstoneCable) {
                return (TileRedstoneCable)cable.get();
            }
        }
        return null;
    }

    public static IBlockState getCableState(IBlockAccess world, BlockPos pos) {
        IBlockAccess actualWorld = SonarMultipartHelper.unwrapBlockAccess((IBlockAccess)world);
        IBlockState state = actualWorld.func_180495_p(pos);
        if (state.func_177230_c() instanceof BlockRedstoneCable) {
            return state;
        }
        Optional cable = MultipartHelper.getPartState((IBlockAccess)actualWorld, (BlockPos)pos, (IPartSlot)EnumCenterSlot.CENTER);
        if (cable.isPresent() && ((IBlockState)cable.get()).func_177230_c() instanceof BlockRedstoneCable) {
            return (IBlockState)cable.get();
        }
        return PL2Blocks.redstone_cable.func_176223_P().func_177226_a((IProperty)PL2Properties.ACTIVE, (Comparable)Boolean.valueOf(false));
    }
}

