/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.connections.redstone.tiles;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcmultipart.api.container.IPartInfo;
import mcmultipart.api.slot.EnumCenterSlot;
import mcmultipart.api.slot.IPartSlot;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import sonar.core.helpers.RayTraceHelper;
import sonar.logistics.PL2Blocks;
import sonar.logistics.PL2Multiparts;
import sonar.logistics.PL2Properties;
import sonar.logistics.api.core.tiles.connections.EnumCableRenderSize;
import sonar.logistics.api.core.tiles.connections.redstone.IRedstoneCable;
import sonar.logistics.api.core.tiles.connections.redstone.IRedstoneConnectable;
import sonar.logistics.core.tiles.base.BlockLogistics;
import sonar.logistics.core.tiles.connections.data.handling.CableConnectionHelper;
import sonar.logistics.core.tiles.connections.redstone.handling.RedstoneConnectionHandler;
import sonar.logistics.core.tiles.connections.redstone.handling.RedstoneConnectionHelper;
import sonar.logistics.core.tiles.connections.redstone.tiles.TileRedstoneCable;

public class BlockRedstoneCable
extends BlockLogistics {
    public BlockRedstoneCable() {
        super(PL2Multiparts.REDSTONE_CABLE);
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return PL2Properties.cableBox;
    }

    public static List<AxisAlignedBB> getSelectionBoxes(World world, BlockPos pos, List<AxisAlignedBB> collidingBoxes) {
        collidingBoxes.add((AxisAlignedBB)PL2Properties.cableBox);
        TileRedstoneCable cable = RedstoneConnectionHelper.getCable((IBlockAccess)world, pos);
        if (cable != null) {
            for (EnumFacing face : EnumFacing.values()) {
                EnumCableRenderSize connect = cable.getRenderType(face);
                if (!connect.canConnect()) continue;
                collidingBoxes.add(PL2Properties.getCableBox(connect, face));
            }
        }
        return collidingBoxes;
    }

    public void func_185477_a(IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull AxisAlignedBB entityBox, @Nonnull List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        super.func_185477_a(state, world, pos, entityBox, collidingBoxes, entityIn, isActualState);
        List<AxisAlignedBB> boxes = BlockRedstoneCable.getSelectionBoxes(world, pos, new ArrayList<AxisAlignedBB>());
        boxes.forEach(box -> BlockRedstoneCable.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, (List)collidingBoxes, (AxisAlignedBB)box));
    }

    public RayTraceResult func_180636_a(IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Vec3d start, @Nonnull Vec3d end) {
        return (RayTraceResult)RayTraceHelper.rayTraceBoxes((BlockPos)pos, (Vec3d)start, (Vec3d)end, BlockRedstoneCable.getSelectionBoxes(world, pos, new ArrayList<AxisAlignedBB>())).getLeft();
    }

    @Deprecated
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, world, pos, blockIn, fromPos);
        TileRedstoneCable cable = RedstoneConnectionHelper.getCable((IBlockAccess)world, pos);
        IBlockState adjState = world.func_180495_p(fromPos);
        if (cable != null && !cable.func_145831_w().field_72995_K && adjState.func_177230_c() != PL2Blocks.redstone_cable) {
            RedstoneConnectionHandler.instance().onNeighbourBlockStateChanged(cable, pos, fromPos);
        }
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(world, pos, neighbor);
        TileRedstoneCable cable = RedstoneConnectionHelper.getCable(world, pos);
        IBlockState state = world.func_180495_p(neighbor);
        if (cable != null && !cable.func_145831_w().field_72995_K && state.func_177230_c() != PL2Blocks.redstone_cable) {
            RedstoneConnectionHandler.instance().onNeighbourTileEntityChanged(cable, pos, neighbor);
        }
    }

    public void onPartAdded(IPartInfo part, IPartInfo otherPart) {
        super.onPartAdded(part, otherPart);
        if (!part.getActualWorld().field_72995_K && part.getTile() != null && otherPart.getTile() != null && otherPart.getTile() instanceof IRedstoneConnectable) {
            RedstoneConnectionHandler.instance().onNeighbourMultipartAdded((IRedstoneCable)part.getTile(), (IRedstoneConnectable)otherPart.getTile());
        }
    }

    public void onPartRemoved(IPartInfo part, IPartInfo otherPart) {
        super.onPartRemoved(part, otherPart);
        if (!part.getActualWorld().field_72995_K && part.getTile() != null && otherPart.getTile() != null && otherPart.getTile() instanceof IRedstoneConnectable) {
            RedstoneConnectionHandler.instance().onNeighbourMultipartRemoved((IRedstoneCable)part.getTile(), (IRedstoneConnectable)otherPart.getTile());
        }
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess world, BlockPos pos) {
        TileRedstoneCable cable = RedstoneConnectionHelper.getCable(world, pos);
        if (cable == null) {
            return state;
        }
        for (PL2Properties.PropertyCableFace p : PL2Properties.CABLE_FACES) {
            state = state.func_177226_a((IProperty)p, (Comparable)((Object)CableConnectionHelper.getConnectionRenderType(cable, p.face)));
        }
        return state;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P();
        for (PL2Properties.PropertyCableFace p : PL2Properties.CABLE_FACES) {
            state = state.func_177226_a((IProperty)p, (Comparable)((Object)EnumCableRenderSize.NONE));
        }
        return state.func_177226_a((IProperty)PL2Properties.ACTIVE, (Comparable)Boolean.valueOf(meta == 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)PL2Properties.ACTIVE) != false ? 1 : 0;
    }

    @Nonnull
    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PL2Properties.ACTIVE, PL2Properties.NORTH, PL2Properties.EAST, PL2Properties.SOUTH, PL2Properties.WEST, PL2Properties.DOWN, PL2Properties.UP});
    }

    public IPartSlot getSlotForPlacement(World world, BlockPos pos, IBlockState state, EnumFacing facing, float hitX, float hitY, float hitZ, EntityLivingBase placer) {
        return EnumCenterSlot.CENTER;
    }

    public IPartSlot getSlotFromWorld(IBlockAccess world, BlockPos pos, IBlockState state) {
        return EnumCenterSlot.CENTER;
    }

    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileRedstoneCable();
    }
}

