/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.info.references;

import net.minecraft.nbt.NBTTagCompound;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.helpers.NBTHelper;
import sonar.logistics.api.core.tiles.displays.info.InfoUUID;
import sonar.logistics.core.tiles.displays.gsi.DisplayGSI;
import sonar.logistics.core.tiles.displays.info.references.ReferenceType;

public class InfoReference
implements INBTSyncable {
    public static final int LIST_HASH = "logiclist".hashCode();
    public InfoUUID uuid;
    public ReferenceType refType;
    public int infoType = -1;
    public Object cachedObject;

    public InfoReference() {
    }

    public InfoReference(InfoUUID uuid, ReferenceType type, int infoType) {
        this.uuid = uuid;
        this.refType = type;
        this.infoType = infoType;
    }

    public Object getLatestInfo(DisplayGSI gsi) {
        if (this.cachedObject != null) {
            return this.cachedObject;
        }
        return null;
    }

    public boolean isList() {
        return this.infoType == LIST_HASH;
    }

    public void replace(InfoUUID uuid) {
        this.uuid = uuid;
        this.cachedObject = null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof InfoReference) {
            return ((InfoReference)obj).uuid.equals(this.uuid) && ((InfoReference)obj).refType.equals((Object)this.refType);
        }
        return false;
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        this.uuid = (InfoUUID)NBTHelper.instanceNBTSyncable(InfoUUID.class, (NBTTagCompound)nbt);
        this.infoType = nbt.func_74762_e("infoType");
        this.refType = ReferenceType.values()[nbt.func_74762_e("t")];
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        this.uuid.writeData(nbt, type);
        nbt.func_74768_a("infoType", this.infoType);
        nbt.func_74768_a("t", this.refType.ordinal());
        return nbt;
    }
}

