/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.info.types.text.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.Tuple;
import sonar.core.helpers.RenderHelper;
import sonar.logistics.core.tiles.displays.info.elements.DisplayElementHelper;
import sonar.logistics.core.tiles.displays.info.elements.base.IDisplayElement;
import sonar.logistics.core.tiles.displays.info.types.text.StyledWrappedTextElement;
import sonar.logistics.core.tiles.displays.info.types.text.gui.GuiEditStyledStrings;
import sonar.logistics.core.tiles.displays.info.types.text.styling.IStyledString;
import sonar.logistics.core.tiles.displays.info.types.text.styling.StyledString;
import sonar.logistics.core.tiles.displays.info.types.text.styling.StyledStringLine;
import sonar.logistics.core.tiles.displays.info.types.text.utils.StyledStringRenderer;
import sonar.logistics.core.tiles.displays.info.types.text.utils.TextSelection;
import sonar.logistics.core.tiles.displays.tiles.TileAbstractDisplay;

public class GuiEditWrappedStyledString
extends GuiEditStyledStrings {
    public GuiEditWrappedStyledString(StyledWrappedTextElement text, TileAbstractDisplay display) {
        super(text, display);
    }

    @Override
    public void renderDisplayScreen(float partialTicks, int x, int y) {
        this.text.updateRender();
        this.text.getHolder().startElementRender(this.text);
        GlStateManager.func_179094_E();
        DisplayElementHelper.align(this.text.getHolder().getAlignmentTranslation(this.text));
        double scale = this.text.getActualScaling()[2];
        GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
        GlStateManager.func_179139_a((double)(this.text.textScale / 100.0), (double)(this.text.textScale / 100.0), (double)1.0);
        int startLine = 0;
        int endLine = ((StyledWrappedTextElement)this.text).handler.linesPerPage;
        Map<Integer, List<StyledStringRenderer.SimpleIndex>> page = ((StyledWrappedTextElement)this.text).handler.lines;
        StyledStringLine cursor_line = this.text.getLine(this.cursorPosition.y);
        List<TextSelection> select = this.getAllSelections();
        if (page != null && !page.isEmpty()) {
            StyledStringRenderer.instance().setRenderPositions(0.0, 0.0);
            for (Map.Entry<Integer, List<StyledStringRenderer.SimpleIndex>> line : page.entrySet()) {
                if (line.getKey() < startLine || line.getKey() >= endLine) continue;
                for (StyledStringRenderer.SimpleIndex index : line.getValue()) {
                    String s = index.string.getUnformattedString().substring(index.start, index.end);
                    StyledStringRenderer.instance().startStyledStringRender(index.string);
                    ArrayList<TextSelection> selections = new ArrayList<TextSelection>();
                    int line_index = this.text.getLineIndex(index.string.getLine());
                    if (!select.isEmpty()) {
                        for (TextSelection validS : select) {
                            if (validS.startY > line_index || validS.endY < line_index) continue;
                            selections.add(validS);
                        }
                    }
                    block3: for (int i = 0; i < s.length(); ++i) {
                        double posX = StyledStringRenderer.instance().getPosX();
                        char current_char = s.charAt(i);
                        StyledStringRenderer.instance().renderChar(index.string, current_char);
                        double char_move = (double)StyledStringRenderer.instance().getPosX() - posX;
                        int actualIndex = index.lineIndex + 1 + i + index.start;
                        if (cursor_line != null && cursor_line == index.string.getLine() && (this.cursorPosition.x == 0 && actualIndex == 0 || this.cursorPosition.x == actualIndex)) {
                            GlStateManager.func_179109_b((float)StyledStringRenderer.instance().getPosX(), (float)StyledStringRenderer.instance().getPosY(), (float)0.0f);
                            this.renderCursorAtPosition();
                            GlStateManager.func_179109_b((float)(-StyledStringRenderer.instance().getPosX()), (float)(-StyledStringRenderer.instance().getPosY()), (float)0.0f);
                        }
                        int value = index.start + i + index.lineIndex;
                        for (TextSelection toRender : selections) {
                            if (toRender.startY == line_index && toRender.startX > value || toRender.endY == line_index && toRender.endX <= value) continue;
                            GlStateManager.func_179090_x();
                            GlStateManager.func_179147_l();
                            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                            GlStateManager.func_179090_x();
                            GlStateManager.func_179120_a((int)770, (int)1, (int)1, (int)0);
                            RenderHelper.drawRect((float)(StyledStringRenderer.instance().getPosX() + (float)(-char_move)), (float)StyledStringRenderer.instance().getPosY(), (float)StyledStringRenderer.instance().getPosX(), (float)(StyledStringRenderer.instance().getPosY() + (float)StyledStringRenderer.instance().field_78288_b));
                            GlStateManager.func_179084_k();
                            GlStateManager.func_179098_w();
                            StyledStringRenderer.instance().startStyledStringRender(index.string);
                            continue block3;
                        }
                    }
                }
                StyledStringRenderer.instance().setRenderPositions(0.0, (double)StyledStringRenderer.instance().getPosY() + ((StyledWrappedTextElement)this.text).handler.totalLineSize());
            }
        }
        GlStateManager.func_179139_a((double)(1.0 / (this.text.textScale / 100.0)), (double)(1.0 / (this.text.textScale / 100.0)), (double)1.0);
        GlStateManager.func_179121_F();
        this.text.getHolder().endElementRender(this.text);
    }

    @Override
    public int[] getDragPositionFromContainerXY(double clickX, double clickY) {
        int xPosition;
        Tuple<StyledStringRenderer.SimpleIndex, Integer> string = ((StyledWrappedTextElement)this.text).getStringClicked(clickX, clickY);
        Tuple<Character, Integer> charClicked = this.getCharClicked(clickX, clickY);
        if (string.func_76341_a() != null) {
            int xPos = ((StyledStringRenderer.SimpleIndex)string.func_76341_a()).lineIndex + ((StyledStringRenderer.SimpleIndex)string.func_76341_a()).start + (Integer)charClicked.func_76340_b();
            int yPos = this.text.getLineIndex(((StyledStringRenderer.SimpleIndex)string.func_76341_a()).string.getLine());
            return new int[]{xPos, yPos};
        }
        double[] align = this.text.getHolder().getAlignmentTranslation(this.text);
        if (clickX < align[0] || clickY < align[1]) {
            return new int[]{0, 0};
        }
        if (this.text.getLines().isEmpty()) {
            StyledStringLine l = new StyledStringLine(this.text);
            this.text.addNewLine(0, l);
            l.addWithCombine(new StyledString("", this.createStylingFromEnabled()));
            return new int[]{0, 0};
        }
        Tuple<StyledStringLine, Integer> line = this.getLineClicked(clickX, clickY);
        int yPosition = Math.min(this.text.getLineCount() - 1, (Integer)line.func_76340_b() == -1 ? this.text.getLineCount() - 1 : (Integer)line.func_76340_b());
        int n = xPosition = (Integer)string.func_76340_b() == -2 || (Integer)string.func_76340_b() == -1 ? this.text.getLineLength(yPosition) : 0;
        if (yPosition < 0) {
            return new int[]{0, 0};
        }
        return new int[]{xPosition, yPosition};
    }

    public int[] getIndexClicked(double clickX, double clickY) {
        Tuple<IDisplayElement, double[]> element = this.c.getClickBoxes(new double[]{0.0, 0.0, 0.0}, clickX, clickY);
        if (element != null && element.func_76341_a() != null && element.func_76341_a() instanceof StyledWrappedTextElement) {
            int[] clicked = ((StyledWrappedTextElement)element.func_76341_a()).getIndexClicked(((double[])element.func_76340_b())[0], ((double[])element.func_76340_b())[1]);
            return clicked;
        }
        return null;
    }

    public Tuple<StyledStringLine, Integer> getLineClicked(double clickX, double clickY) {
        Tuple<StyledStringRenderer.SimpleIndex, Integer> string;
        Tuple<IDisplayElement, double[]> element = this.c.getClickBoxes(new double[]{0.0, 0.0, 0.0}, clickX, clickY);
        if (element != null && element.func_76341_a() != null && element.func_76341_a() instanceof StyledWrappedTextElement && (string = ((StyledWrappedTextElement)element.func_76341_a()).getStringClicked(((double[])element.func_76340_b())[0], ((double[])element.func_76340_b())[1])) != null && string.func_76341_a() != null) {
            return new Tuple((Object)((StyledStringRenderer.SimpleIndex)string.func_76341_a()).string.getLine(), (Object)this.text.getLineIndex(((StyledStringRenderer.SimpleIndex)string.func_76341_a()).string.getLine()));
        }
        return new Tuple(null, (Object)-1);
    }

    public Tuple<IStyledString, Integer> getStringClicked(double clickX, double clickY) {
        Tuple<StyledStringRenderer.SimpleIndex, Integer> string;
        Tuple<IDisplayElement, double[]> element = this.c.getClickBoxes(new double[]{0.0, 0.0, 0.0}, clickX, clickY);
        if (element != null && element.func_76341_a() != null && element.func_76341_a() instanceof StyledWrappedTextElement && (string = ((StyledWrappedTextElement)element.func_76341_a()).getStringClicked(((double[])element.func_76340_b())[0], ((double[])element.func_76340_b())[1])) != null && string.func_76341_a() != null) {
            return new Tuple((Object)((StyledStringRenderer.SimpleIndex)string.func_76341_a()).string, string.func_76340_b());
        }
        return new Tuple(null, (Object)-1);
    }

    public Tuple<Character, Integer> getCharClicked(double clickX, double clickY) {
        Tuple<IDisplayElement, double[]> element = this.c.getClickBoxes(new double[]{0.0, 0.0, 0.0}, clickX, clickY);
        if (element != null && element.func_76341_a() != null && element.func_76341_a() instanceof StyledWrappedTextElement) {
            return ((StyledWrappedTextElement)element.func_76341_a()).getCharClicked(((double[])element.func_76340_b())[0], ((double[])element.func_76340_b())[1]);
        }
        return new Tuple(null, (Object)-1);
    }
}

