/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.tiles.connected;

import java.util.ArrayList;
import java.util.Optional;
import mcmultipart.api.multipart.MultipartHelper;
import mcmultipart.api.slot.IPartSlot;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import sonar.core.api.utils.BlockInteractionType;
import sonar.core.common.block.properties.SonarProperties;
import sonar.logistics.PL2Multiparts;
import sonar.logistics.api.core.tiles.displays.tiles.IDisplay;
import sonar.logistics.api.core.tiles.displays.tiles.ILargeDisplay;
import sonar.logistics.base.utils.slots.EnumDisplayFaceSlot;
import sonar.logistics.core.tiles.displays.tiles.BlockClickableDisplay;
import sonar.logistics.core.tiles.displays.tiles.connected.ConnectedDisplay;
import sonar.logistics.core.tiles.displays.tiles.connected.DisplayConnections;
import sonar.logistics.core.tiles.displays.tiles.connected.TileLargeDisplayScreen;

public class BlockLargeDisplay
extends BlockClickableDisplay {
    public static final PropertyEnum<DisplayConnections> TYPE = PropertyEnum.func_177709_a((String)"type", DisplayConnections.class);
    public static final double depth = 0.0625;
    public static final double height = 1.0;
    public static final double width = 0.0;
    public static final double length = 0.0625;
    public static final AxisAlignedBB DOWN_AXIS = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);
    public static final AxisAlignedBB UP_AXIS = new AxisAlignedBB(0.0, 1.0, 0.0, 1.0, 0.9375, 1.0);
    public static final AxisAlignedBB NORTH_AXIS = new AxisAlignedBB(0.0, 0.0, 0.0625, 1.0, 1.0, 0.0);
    public static final AxisAlignedBB SOUTH_AXIS = new AxisAlignedBB(0.0, 0.0, 1.0, 1.0, 1.0, 0.9375);
    public static final AxisAlignedBB WEST_AXIS = new AxisAlignedBB(0.0625, 0.0, 0.0, 0.0, 1.0, 1.0);
    public static final AxisAlignedBB EAST_AXIS = new AxisAlignedBB(1.0, 0.0, 0.0, 0.9375, 1.0, 1.0);
    public static final AxisAlignedBB[] AXIS = new AxisAlignedBB[]{DOWN_AXIS, UP_AXIS, NORTH_AXIS, SOUTH_AXIS, WEST_AXIS, EAST_AXIS};

    public BlockLargeDisplay() {
        super(PL2Multiparts.LARGE_DISPLAY_SCREEN);
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileLargeDisplayScreen) {
            TileLargeDisplayScreen display;
            TileLargeDisplayScreen source = (TileLargeDisplayScreen)tile;
            Optional<ConnectedDisplay> connectedDisplay = source.getConnectedDisplay();
            if (!connectedDisplay.isPresent()) {
                return false;
            }
            TileLargeDisplayScreen tileLargeDisplayScreen = display = (Boolean)source.shouldRender.getObject() != false ? source : (TileLargeDisplayScreen)connectedDisplay.get().getTopLeftScreen();
            if (display != null) {
                if (facing != state.func_177229_b((IProperty)SonarProperties.ORIENTATION)) {
                    if (!world.field_72995_K && this.canOpenGui(player)) {
                        display.openFlexibleGui(player, 0);
                    }
                } else {
                    return display.getGSI().onClicked(display, player.func_70093_af() ? BlockInteractionType.SHIFT_RIGHT : BlockInteractionType.RIGHT, world, pos, state, player, hand, facing, hitX, hitY, hitZ);
                }
            }
        }
        return true;
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess w, BlockPos pos) {
        ArrayList<EnumFacing> faces = new ArrayList<EnumFacing>();
        TileEntity tile = w.func_175625_s(pos);
        if (tile instanceof TileLargeDisplayScreen) {
            TileLargeDisplayScreen screen = (TileLargeDisplayScreen)tile;
            block8: for (EnumFacing face : EnumFacing.field_82609_l) {
                if (face == screen.getCableFace() || face == screen.getCableFace().func_176734_d()) continue;
                IDisplay display = null;
                Optional multipartTile = MultipartHelper.getPartTile((IBlockAccess)w, (BlockPos)pos.func_177972_a(face), (IPartSlot)EnumDisplayFaceSlot.fromFace(screen.getCableFace()));
                if (multipartTile.isPresent() && multipartTile.get() instanceof IDisplay) {
                    display = (IDisplay)multipartTile.get();
                }
                if (!(display instanceof ILargeDisplay) || ((ILargeDisplay)display).getRegistryID() != screen.getRegistryID()) continue;
                switch (display.getCableFace()) {
                    case DOWN: {
                        EnumFacing toAdd = face;
                        if (toAdd == EnumFacing.NORTH || toAdd == EnumFacing.SOUTH) {
                            toAdd = toAdd.func_176734_d();
                        }
                        faces.add(toAdd);
                        continue block8;
                    }
                    case EAST: {
                        EnumFacing toAdd = face.func_176732_a(EnumFacing.Axis.Z).func_176732_a(EnumFacing.Axis.Y);
                        if (toAdd == EnumFacing.NORTH || toAdd == EnumFacing.SOUTH) {
                            toAdd = toAdd.func_176734_d();
                        }
                        faces.add(toAdd);
                        continue block8;
                    }
                    case NORTH: {
                        EnumFacing toAdd = face.func_176732_a(EnumFacing.Axis.Z).func_176732_a(EnumFacing.Axis.X).func_176732_a(EnumFacing.Axis.Y);
                        if (toAdd == EnumFacing.NORTH || toAdd == EnumFacing.SOUTH) {
                            toAdd = toAdd.func_176734_d();
                        }
                        faces.add(toAdd);
                        continue block8;
                    }
                    case SOUTH: {
                        EnumFacing toAdd = face.func_176732_a(EnumFacing.Axis.Z).func_176732_a(EnumFacing.Axis.X).func_176732_a(EnumFacing.Axis.Y).func_176734_d();
                        faces.add(toAdd);
                        continue block8;
                    }
                    case UP: {
                        faces.add(face);
                        continue block8;
                    }
                    case WEST: {
                        faces.add(face.func_176732_a(EnumFacing.Axis.Z).func_176732_a(EnumFacing.Axis.Y).func_176734_d());
                        continue block8;
                    }
                }
            }
        }
        DisplayConnections type = DisplayConnections.getType(faces);
        return state.func_177226_a((IProperty)SonarProperties.ROTATION, (Comparable)EnumFacing.NORTH).func_177226_a(TYPE, (Comparable)((Object)type));
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AXIS[this.getOrientation(state).ordinal()];
    }

    @Override
    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SonarProperties.ORIENTATION, SonarProperties.ROTATION, TYPE});
    }
}

