/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.readers.info.handling;

import java.util.List;
import javax.annotation.Nullable;
import sonar.logistics.api.core.tiles.connections.data.network.ILogisticsNetwork;
import sonar.logistics.api.core.tiles.displays.info.IProvidableInfo;
import sonar.logistics.api.core.tiles.displays.info.InfoUUID;
import sonar.logistics.api.core.tiles.displays.info.lists.AbstractChangeableList;
import sonar.logistics.api.core.tiles.readers.IListReader;
import sonar.logistics.api.core.tiles.readers.INetworkReader;
import sonar.logistics.base.channels.BlockConnection;
import sonar.logistics.base.channels.ChannelList;
import sonar.logistics.base.channels.ChannelType;
import sonar.logistics.base.channels.EntityConnection;
import sonar.logistics.base.channels.handling.ListNetworkChannels;
import sonar.logistics.base.listeners.ListenerType;
import sonar.logistics.core.tiles.readers.info.handling.InfoNetworkHandler;

public class InfoNetworkChannels
extends ListNetworkChannels<IProvidableInfo, InfoNetworkHandler> {
    private ChannelList currentList;

    public InfoNetworkChannels(ILogisticsNetwork network) {
        super(InfoNetworkHandler.INSTANCE, network);
    }

    @Override
    public void runUpdates() {
        if (this.UPDATES.canSyncUpdate(ListenerType.UpdateType.GUI)) {
            this.updateChannels();
            this.updateReaders(true);
        }
        if (this.UPDATES.canSyncUpdate(ListenerType.UpdateType.DISPLAY)) {
            for (IListReader reader : this.readers) {
                if (!(reader instanceof INetworkReader) || reader.getListenerList().getDisplayListeners().listener_tallies.isEmpty()) continue;
                InfoUUID uuid = ((InfoNetworkHandler)this.handler).getReaderUUID(reader);
                AbstractChangeableList updateList = ((InfoNetworkHandler)this.handler).getUUIDLatestList(uuid);
                ((INetworkReader)reader).setMonitoredInfo(updateList, (List)this.usedChannels.get(reader.getIdentity()), uuid);
            }
        }
    }

    @Override
    public void updateTickLists() {
        super.updateTickLists();
        this.currentList = this.getChannelsList();
    }

    @Nullable
    public ChannelList getChannelsList() {
        ChannelList list = new ChannelList(-1, ChannelType.NETWORK_SINGLE, this.network.getNetworkID());
        for (IListReader monitor : this.readers) {
            if (!(monitor instanceof INetworkReader)) continue;
            ChannelList channels = ((INetworkReader)monitor).getChannels();
            list.addAll(channels.getCoords());
            list.addAllUUID(channels.getUUIDs());
        }
        return list;
    }

    @Override
    public boolean isCoordsMonitored(BlockConnection connection) {
        return this.currentList == null || this.currentList.isCoordsMonitored(connection.coords);
    }

    @Override
    public boolean isEntityMonitored(EntityConnection connection) {
        return this.currentList == null || this.currentList.isEntityMonitored(connection.uuid);
    }

    @Override
    public void onDeleted() {
        super.onDeleted();
        this.currentList = null;
    }
}

