/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.readers.network.handling;

import java.util.ArrayList;
import sonar.core.utils.Pair;
import sonar.logistics.api.core.tiles.connections.data.network.ILogisticsNetwork;
import sonar.logistics.api.core.tiles.displays.info.IProvidableInfo;
import sonar.logistics.api.core.tiles.displays.info.InfoUUID;
import sonar.logistics.api.core.tiles.displays.info.lists.AbstractChangeableList;
import sonar.logistics.api.core.tiles.displays.info.register.RegistryType;
import sonar.logistics.api.core.tiles.readers.IListReader;
import sonar.logistics.api.core.tiles.readers.INetworkReader;
import sonar.logistics.api.core.tiles.readers.channels.INetworkChannels;
import sonar.logistics.api.core.tiles.readers.channels.INetworkHandler;
import sonar.logistics.base.ServerInfoHandler;
import sonar.logistics.base.channels.NodeConnection;
import sonar.logistics.base.events.PL2Events;
import sonar.logistics.base.utils.CacheType;
import sonar.logistics.core.tiles.connections.data.handling.CableConnectionHandler;
import sonar.logistics.core.tiles.connections.data.network.CacheHandler;
import sonar.logistics.core.tiles.displays.info.InfoPacketHelper;
import sonar.logistics.core.tiles.displays.info.types.general.InfoChangeableList;
import sonar.logistics.core.tiles.displays.info.types.general.LogicInfo;
import sonar.logistics.core.tiles.readers.network.handling.NetworkWatcherChannels;

public class NetworkWatcherHandler
implements INetworkHandler {
    public static NetworkWatcherHandler INSTANCE = new NetworkWatcherHandler();

    @Override
    public int updateRate() {
        return 20;
    }

    @Override
    public Class<? extends INetworkChannels> getChannelsType() {
        return NetworkWatcherChannels.class;
    }

    private InfoChangeableList newChangeableList() {
        return new InfoChangeableList();
    }

    public AbstractChangeableList<IProvidableInfo> updateNetworkList(AbstractChangeableList<IProvidableInfo> list, ILogisticsNetwork network) {
        double pl2Tick = (double)PL2Events.updateTick / 1000000.0;
        double networkTick = (double)network.getNetworkTickTime() / 1000000.0;
        list.add(LogicInfo.buildDirectInfo("ILogisticsNetwork.pl2TickTime", RegistryType.LOGICNETWORK, pl2Tick));
        list.add(LogicInfo.buildDirectInfo("ILogisticsNetwork.pl2TickPercentage", RegistryType.LOGICNETWORK, pl2Tick / 50.0 * 100.0));
        list.add(LogicInfo.buildDirectInfo("ILogisticsNetwork.pl2TickFurnace", RegistryType.LOGICNETWORK, PL2Events.updateTick / 1000L / 20L));
        list.add(LogicInfo.buildDirectInfo("ILogisticsNetwork.getNetworkTickTime", RegistryType.LOGICNETWORK, networkTick));
        list.add(LogicInfo.buildDirectInfo("ILogisticsNetwork.percent", RegistryType.LOGICNETWORK, networkTick / 50.0 * 100.0));
        list.add(LogicInfo.buildDirectInfo("ILogisticsNetwork.furnace", RegistryType.LOGICNETWORK, network.getNetworkTickTime() / 1000L / 20L));
        list.add(LogicInfo.buildDirectInfo("ILogisticsNetwork.getNetworkID", RegistryType.LOGICNETWORK, network.getNetworkID()));
        list.add(LogicInfo.buildDirectInfo("ILogisticsNetwork.connectedNetworks", RegistryType.LOGICNETWORK, network.getListenerList().getListeners(new int[]{0}).size()));
        list.add(LogicInfo.buildDirectInfo("ILogisticsNetwork.watchingNetworks", RegistryType.LOGICNETWORK, network.getListenerList().getListeners(new int[]{1}).size()));
        list.add(LogicInfo.buildDirectInfo("ILogisticsNetwork.CACHE.IDataCable", RegistryType.LOGICNETWORK, CableConnectionHandler.instance().getConnections(network.getNetworkID()).size()));
        list.add(LogicInfo.buildDirectInfo("ILogisticsNetwork.CACHE.INetworkListener", RegistryType.LOGICNETWORK, network.getCachedTiles(CacheHandler.TILE, CacheType.ALL).size()));
        list.add(LogicInfo.buildDirectInfo("ILogisticsNetwork.CACHE.INode", RegistryType.LOGICNETWORK, network.getCachedTiles(CacheHandler.NODES, CacheType.ALL).size()));
        list.add(LogicInfo.buildDirectInfo("ILogisticsNetwork.CACHE.IEntityNode", RegistryType.LOGICNETWORK, network.getCachedTiles(CacheHandler.ENTITY_NODES, CacheType.ALL).size()));
        list.add(LogicInfo.buildDirectInfo("ILogisticsNetwork.CACHE.IListReader", RegistryType.LOGICNETWORK, network.getCachedTiles(CacheHandler.READER, CacheType.ALL).size()));
        list.add(LogicInfo.buildDirectInfo("ILogisticsNetwork.CACHE.IDataEmitter", RegistryType.LOGICNETWORK, network.getCachedTiles(CacheHandler.EMITTERS, CacheType.ALL).size()));
        list.add(LogicInfo.buildDirectInfo("ILogisticsNetwork.CACHE.IDataReceiver", RegistryType.LOGICNETWORK, network.getCachedTiles(CacheHandler.RECEIVERS, CacheType.ALL).size()));
        list.add(LogicInfo.buildDirectInfo("ILogisticsNetwork.CACHE.ITransferNode", RegistryType.LOGICNETWORK, network.getCachedTiles(CacheHandler.TRANSFER_NODES, CacheType.ALL).size()));
        list.add(LogicInfo.buildDirectInfo("ILogisticsNetwork.totalConnections", RegistryType.LOGICNETWORK, network.getConnections(CacheType.ALL).size()));
        list.add(LogicInfo.buildDirectInfo("ILogisticsNetwork.localConnections", RegistryType.LOGICNETWORK, network.getConnections(CacheType.LOCAL).size()));
        list.add(LogicInfo.buildDirectInfo("ILogisticsNetwork.globalConnections", RegistryType.LOGICNETWORK, network.getConnections(CacheType.GLOBAL).size()));
        return list;
    }

    public Pair<InfoUUID, AbstractChangeableList<IProvidableInfo>> updateAndSendList(ILogisticsNetwork network, IListReader<IProvidableInfo> reader, AbstractChangeableList<IProvidableInfo> networkList, boolean send) {
        InfoUUID uuid = this.getReaderUUID(reader);
        if (network.validateTile(reader)) {
            ArrayList<NodeConnection> usedChannels = new ArrayList<NodeConnection>();
            AbstractChangeableList currentList = ServerInfoHandler.instance().getChangeableListMap().getOrDefault(uuid, this.newChangeableList());
            currentList.saveStates();
            networkList.createSaveableList().forEach(currentList::add);
            if (reader instanceof INetworkReader) {
                ((INetworkReader)reader).setMonitoredInfo(currentList, usedChannels, uuid);
            }
            ServerInfoHandler.instance().getChangeableListMap().put(uuid, currentList);
            if (send && (!currentList.wasLastListNull || currentList.wasLastListNull != currentList.getList().isEmpty())) {
                InfoPacketHelper.sendReaderToListeners(reader, currentList, uuid);
            }
            return new Pair((Object)uuid, (Object)currentList);
        }
        return new Pair((Object)uuid, (Object)this.newChangeableList());
    }
}

