/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.wireless.emitters;

import net.minecraft.block.properties.IProperty;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import sonar.core.network.sync.SyncTagType;
import sonar.logistics.PL2;
import sonar.logistics.PL2Properties;
import sonar.logistics.api.core.tiles.connections.EnumCableConnection;
import sonar.logistics.api.core.tiles.connections.EnumCableConnectionType;
import sonar.logistics.api.core.tiles.connections.redstone.network.IRedstoneNetwork;
import sonar.logistics.api.core.tiles.wireless.IWirelessManager;
import sonar.logistics.api.core.tiles.wireless.emitters.IRedstoneEmitter;
import sonar.logistics.core.tiles.connections.redstone.handling.RedstoneConnectionHelper;
import sonar.logistics.core.tiles.connections.redstone.network.EmptyRedstoneNetwork;
import sonar.logistics.core.tiles.wireless.emitters.TileAbstractEmitter;
import sonar.logistics.core.tiles.wireless.handling.WirelessRedstoneManager;

public class TileRedstoneEmitter
extends TileAbstractEmitter
implements IRedstoneEmitter {
    public IRedstoneNetwork rNetwork = EmptyRedstoneNetwork.INSTANCE;
    public SyncTagType.INT currentPower = new SyncTagType.INT(0);

    public IWirelessManager getWirelessHandler() {
        return WirelessRedstoneManager.instance();
    }

    @Override
    public String getEmitterName() {
        if ((Integer)this.currentPower.getObject() > 0) {
            return TextFormatting.GREEN + super.getEmitterName();
        }
        return super.getEmitterName();
    }

    @Override
    public EnumCableConnection canConnect(int registryID, EnumCableConnectionType type, EnumFacing dir, boolean internal) {
        if (!type.isRedstone()) {
            return EnumCableConnection.NONE;
        }
        EnumFacing toCheck = internal ? dir : dir.func_176734_d();
        return toCheck == this.getCableFace() ? EnumCableConnection.NETWORK : EnumCableConnection.NONE;
    }

    @Override
    public void onCableChanged(int power) {
    }

    @Override
    public int getRedstonePower() {
        this.currentPower.setObject((Object)((Boolean)RedstoneConnectionHelper.getCableState((IBlockAccess)this.field_145850_b, this.field_174879_c).func_177229_b((IProperty)PL2Properties.ACTIVE) != false ? 15 : 0));
        return (Integer)this.currentPower.getObject();
    }

    @Override
    public IRedstoneNetwork getRedstoneNetwork() {
        return this.rNetwork;
    }

    @Override
    public void onNetworkConnect(IRedstoneNetwork network) {
        if (!this.rNetwork.isValid() || ((Integer)this.networkID.getObject()).intValue() != network.getNetworkID()) {
            this.rNetwork = network;
            this.networkID.setObject((Object)network.getNetworkID());
        }
    }

    @Override
    public void onNetworkDisconnect(IRedstoneNetwork network) {
        if (((Integer)this.networkID.getObject()).intValue() == network.getNetworkID()) {
            this.rNetwork = EmptyRedstoneNetwork.INSTANCE;
            this.networkID.setObject((Object)-1);
        } else if ((Integer)this.networkID.getObject() != -1) {
            PL2.logger.info("%s : attempted to disconnect from the wrong handling with ID: %s expected %s", (Object)this, (Object)network.getNetworkID(), this.networkID.getObject());
        }
    }
}

