/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.block;

import com.github.mnesikos.simplycats.SimplyCats;
import com.github.mnesikos.simplycats.block.BlockTileEntity;
import com.github.mnesikos.simplycats.init.ModItems;
import com.github.mnesikos.simplycats.item.ItemCatBowl;
import com.github.mnesikos.simplycats.tileentity.TileEntityCatBowl;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class BlockCatBowl
extends BlockTileEntity<TileEntityCatBowl> {
    protected String name;
    public static final int GUI_ID = 0;
    public static final PropertyBool FULL_FOOD = PropertyBool.func_177716_a((String)"full_food");
    public static final PropertyInteger WATER_LEVEL = PropertyInteger.func_177719_a((String)"water_level", (int)0, (int)3);
    public static final PropertyEnum<EnumDyeColor> COLOR = PropertyEnum.func_177709_a((String)"color", EnumDyeColor.class);
    protected static final AxisAlignedBB BOWL_AABB = new AxisAlignedBB(0.34375, 0.0, 0.34375, 0.65625, 0.125, 0.65625);

    public BlockCatBowl(String name) {
        super(Material.field_151578_c, name);
        this.name = name;
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149711_c(0.2f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FULL_FOOD, (Comparable)Boolean.FALSE).func_177226_a((IProperty)WATER_LEVEL, (Comparable)Integer.valueOf(0)).func_177226_a(COLOR, (Comparable)EnumDyeColor.BLACK));
    }

    public void setWaterLevel(World world, BlockPos pos, IBlockState state, int level, EnumDyeColor color) {
        world.func_180501_a(pos, state.func_177226_a((IProperty)WATER_LEVEL, (Comparable)Integer.valueOf(MathHelper.func_76125_a((int)level, (int)0, (int)3))), 2);
        ((TileEntityCatBowl)world.func_175625_s(pos)).setColor(color);
        world.func_175666_e(pos, (Block)this);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!(this.getTileEntity((IBlockAccess)world, pos) instanceof TileEntityCatBowl)) {
            return false;
        }
        TileEntityCatBowl tileEntityCatBowl = (TileEntityCatBowl)((Object)this.getTileEntity((IBlockAccess)world, pos));
        EnumDyeColor color = tileEntityCatBowl.getColor();
        if (tileEntityCatBowl == null) {
            return false;
        }
        int waterLevel = (Integer)state.func_177229_b((IProperty)WATER_LEVEL);
        ItemStack itemstack = player.func_184586_b(hand);
        if (tileEntityCatBowl.func_191420_l() && itemstack.func_77973_b() == Items.field_151131_as && waterLevel < 3 && !world.field_72995_K) {
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_184611_a(hand, new ItemStack(Items.field_151133_ar));
            }
            this.setWaterLevel(world, pos, state, 3, color);
            world.func_184133_a(null, pos, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        if (tileEntityCatBowl.func_191420_l() && itemstack.func_77973_b() == Items.field_151133_ar && waterLevel == 3 && !world.field_72995_K) {
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
                if (itemstack.func_190926_b()) {
                    player.func_184611_a(hand, new ItemStack(Items.field_151131_as));
                } else if (!player.field_71071_by.func_70441_a(new ItemStack(Items.field_151131_as))) {
                    player.func_71019_a(new ItemStack(Items.field_151131_as), false);
                }
            }
            this.setWaterLevel(world, pos, state, 0, color);
            world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187630_M, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        if (tileEntityCatBowl.func_191420_l() && itemstack.func_77973_b() == Items.field_151068_bn && PotionUtils.func_185191_c((ItemStack)itemstack) == PotionTypes.field_185230_b && waterLevel < 3 && !world.field_72995_K) {
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_184611_a(hand, new ItemStack(Items.field_151069_bo));
                if (player instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)player).func_71120_a(player.field_71069_bz);
                }
            }
            this.setWaterLevel(world, pos, state, waterLevel + 1, color);
            world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_191241_J, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        if (waterLevel == 0 && !world.field_72995_K) {
            player.openGui((Object)SimplyCats.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntityCatBowl te = (TileEntityCatBowl)((Object)this.getTileEntity((IBlockAccess)world, pos));
        if (te instanceof IInventory) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)te);
        }
        super.func_180663_b(world, pos, state);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        if (te instanceof TileEntityCatBowl) {
            TileEntityCatBowl TileEntityCatBowl2 = (TileEntityCatBowl)te;
            ItemStack itemstack = TileEntityCatBowl2.getItemStack();
            BlockCatBowl.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)itemstack);
        } else {
            super.func_180657_a(worldIn, player, pos, state, null, stack);
        }
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        return (Integer)blockState.func_177229_b((IProperty)WATER_LEVEL);
    }

    @Override
    public Class<TileEntityCatBowl> getTileEntityClass() {
        return TileEntityCatBowl.class;
    }

    @Override
    @Nullable
    public TileEntityCatBowl createTileEntity(World world, IBlockState state) {
        return new TileEntityCatBowl();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity tileEntity;
        TileEntity tileEntity2 = tileEntity = worldIn instanceof ChunkCache ? ((ChunkCache)worldIn).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK) : worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileEntityCatBowl) {
            TileEntityCatBowl tileEntityCatBowl = (TileEntityCatBowl)tileEntity;
            return state.func_177226_a((IProperty)FULL_FOOD, (Comparable)Boolean.valueOf(!tileEntityCatBowl.func_191420_l())).func_177226_a(COLOR, (Comparable)tileEntityCatBowl.getColor());
        }
        return state;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)WATER_LEVEL, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)WATER_LEVEL);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FULL_FOOD, WATER_LEVEL, COLOR});
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOWL_AABB;
    }

    @Override
    public Item createItemBlock() {
        return null;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityCatBowl) {
            TileEntityCatBowl bowl = (TileEntityCatBowl)te;
            if (stack.func_77973_b() instanceof ItemCatBowl) {
                EnumDyeColor color = ((ItemCatBowl)stack.func_77973_b()).color;
                bowl.setColor(color);
            } else {
                bowl.setColor(EnumDyeColor.BLACK);
            }
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntity te = world.func_175625_s(target.func_178782_a());
        if (te instanceof TileEntityCatBowl) {
            TileEntityCatBowl bowl = (TileEntityCatBowl)te;
            return new ItemStack((Item)ModItems.CAT_BOWLS.get(bowl.getColor()));
        }
        return ItemStack.field_190927_a;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return (Item)ModItems.CAT_BOWLS.get(state.func_177229_b(COLOR));
    }
}

