/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.client.render.entity;

import com.github.mnesikos.simplycats.Ref;
import com.github.mnesikos.simplycats.client.model.entity.ModelCat;
import com.github.mnesikos.simplycats.entity.EntityCat;
import com.github.mnesikos.simplycats.entity.core.Genetics;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.LayeredTexture;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderCat
extends RenderLiving<EntityCat> {
    private static final Map<String, ResourceLocation> LAYERED_LOCATION_CACHE = Maps.newHashMap();

    public RenderCat(RenderManager render) {
        super(render, (ModelBase)new ModelCat(), 0.2f);
    }

    protected void preRenderCallback(EntityCat entity, float partialTickTime) {
        GL11.glScalef((float)0.8f, (float)0.9f, (float)0.8f);
        super.func_77041_b((EntityLivingBase)entity, partialTickTime);
    }

    @Nullable
    protected ResourceLocation getEntityTexture(EntityCat entity) {
        String s = entity.getCatTexture();
        ResourceLocation resourceLocation = LAYERED_LOCATION_CACHE.get(s);
        if (resourceLocation == null) {
            resourceLocation = new ResourceLocation(s);
            Minecraft.func_71410_x().func_110434_K().func_110579_a(resourceLocation, (ITextureObject)new LayeredTexture(entity.getTexturePaths()));
            LAYERED_LOCATION_CACHE.put(s, resourceLocation);
        }
        return resourceLocation;
    }

    public void renderName(EntityCat cat, double x, double y, double z) {
        if (this.func_177070_b((EntityLiving)cat)) {
            float range;
            double d0 = cat.func_70068_e(this.field_76990_c.field_78734_h);
            float f = range = cat.func_70093_af() ? NAME_TAG_RANGE_SNEAK : NAME_TAG_RANGE;
            if (d0 < (double)(range * range)) {
                String name = cat.func_145748_c_().func_150254_d();
                GlStateManager.func_179092_a((int)516, (float)0.1f);
                boolean flag = cat.func_70093_af();
                float f2 = this.field_76990_c.field_78735_i;
                float f1 = this.field_76990_c.field_78732_j;
                boolean flag1 = this.field_76990_c.field_78733_k.field_74320_O == 2;
                float f22 = cat.field_70131_O + 0.5f - (flag ? 0.25f : 0.0f);
                EntityRenderer.func_189692_a((FontRenderer)this.func_76983_a(), (String)name, (float)((float)x), (float)((float)y + f22), (float)((float)z), (int)0, (float)f2, (float)f1, (boolean)flag1, (boolean)flag);
                if (d0 < 64.0 && this.field_76990_c.field_78734_h.func_70093_af() && !cat.isFixed() && !cat.func_70631_g_()) {
                    String info = I18n.func_135052_a((String)(cat.getSex() == Genetics.Sex.FEMALE ? (cat.getBreedingStatus("inheat") ? "chat.info.in_heat" : "chat.info.not_in_heat") : "chat.info.male"), (Object[])new Object[]{cat.getMateTimer()});
                    if (cat.getBreedingStatus("ispregnant")) {
                        info = I18n.func_135052_a((String)(cat.getBreedingStatus("inheat") ? "chat.info.pregnant_heat" : "chat.info.pregnant"), (Object[])new Object[]{cat.getMateTimer()});
                    }
                    Ref.drawNameplateScaled(this.func_76983_a(), info, (float)x, (float)y + f22 + 0.12f, (float)z, 0, f2, f1, flag1, flag, -0.012f);
                }
            }
        }
    }
}

