/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.entity.ai;

import com.github.mnesikos.simplycats.configuration.SCConfig;
import com.github.mnesikos.simplycats.entity.EntityCat;
import com.github.mnesikos.simplycats.entity.core.Genetics;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;

public class CatAIBirth
extends EntityAIBase {
    private final EntityCat MOTHER;
    private EntityCat FATHER;
    World WORLD;

    public CatAIBirth(EntityCat entityCat) {
        this.MOTHER = entityCat;
        this.WORLD = entityCat.field_70170_p;
        this.func_75248_a(8);
    }

    public boolean func_75250_a() {
        if (this.MOTHER.getSex() != Genetics.Sex.FEMALE || !this.MOTHER.getBreedingStatus("ispregnant") || this.MOTHER.getBreedingStatus("inheat")) {
            return false;
        }
        if (this.MOTHER.getMateTimer() >= 0) {
            return false;
        }
        return !this.MOTHER.func_70909_n() || this.MOTHER.func_70902_q() != null;
    }

    public boolean func_75253_b() {
        return this.MOTHER.getBreedingStatus("ispregnant");
    }

    public void func_75251_c() {
        this.FATHER = null;
    }

    public void func_75246_d() {
        for (int i = 0; i < this.MOTHER.getKittens(); ++i) {
            this.FATHER = new EntityCat(this.WORLD);
            this.FATHER.func_70020_e(this.MOTHER.getFather(i));
            this.spawnBaby(this.FATHER);
            this.MOTHER.getEntityData().func_82580_o("Father" + i);
        }
        this.MOTHER.setKittens(0);
        this.MOTHER.setBreedingStatus("ispregnant", false);
        this.MOTHER.setTimeCycle("end", SCConfig.HEAT_COOLDOWN);
    }

    private void spawnBaby(EntityCat father) {
        EntityCat child = this.MOTHER.createChild((EntityAgeable)father);
        BabyEntitySpawnEvent event = new BabyEntitySpawnEvent((EntityLiving)this.MOTHER, (EntityLiving)father, (EntityAgeable)child);
        if ((child = (EntityCat)event.getChild()) != null) {
            child.func_70873_a(-SCConfig.KITTEN_MATURE_TIMER);
            child.func_70012_b(this.MOTHER.field_70165_t, this.MOTHER.field_70163_u, this.MOTHER.field_70161_v, 0.0f, 0.0f);
            child.setParent("father", this.FATHER.func_95999_t());
            child.setParent("mother", this.MOTHER.func_95999_t());
            this.WORLD.func_72838_d((Entity)child);
            Random random = this.MOTHER.func_70681_au();
            for (int i = 0; i < 7; ++i) {
                double d0 = random.nextGaussian() * 0.02;
                double d1 = random.nextGaussian() * 0.02;
                double d2 = random.nextGaussian() * 0.02;
                this.WORLD.func_175688_a(EnumParticleTypes.HEART, this.MOTHER.field_70165_t + (double)(random.nextFloat() * this.MOTHER.field_70130_N * 2.0f) - (double)this.MOTHER.field_70130_N, this.MOTHER.field_70163_u + 0.5 + (double)(random.nextFloat() * this.MOTHER.field_70131_O), this.MOTHER.field_70161_v + (double)(random.nextFloat() * this.MOTHER.field_70130_N * 2.0f) - (double)this.MOTHER.field_70130_N, d0, d1, d2, new int[0]);
            }
            if (this.WORLD.func_82736_K().func_82766_b("doMobLoot")) {
                this.WORLD.func_72838_d((Entity)new EntityXPOrb(this.WORLD, this.MOTHER.field_70165_t, this.MOTHER.field_70163_u, this.MOTHER.field_70161_v, random.nextInt(2) + 1));
            }
        }
    }
}

