/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.entity.ai;

import com.github.mnesikos.simplycats.configuration.SCConfig;
import com.github.mnesikos.simplycats.entity.EntityCat;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class CatAIWander
extends EntityAIBase {
    protected final EntityCat cat;
    protected double x;
    protected double y;
    protected double z;
    protected final double speed;
    protected int executionChance;

    public CatAIWander(EntityCat cat, double speed) {
        this.cat = cat;
        this.speed = speed;
        this.executionChance = 45;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        if (this.cat.func_70654_ax() >= 100) {
            return false;
        }
        if (this.cat.func_70681_au().nextInt(this.executionChance) != 0) {
            return false;
        }
        Vec3d vec3d = this.getPosition();
        if (vec3d == null) {
            return false;
        }
        this.x = vec3d.field_72450_a;
        this.y = vec3d.field_72448_b;
        this.z = vec3d.field_72449_c;
        return true;
    }

    @Nullable
    private Vec3d getPosition() {
        double d1;
        double d0;
        PathNavigate pathnavigate = this.cat.func_70661_as();
        Random random = this.cat.func_70681_au();
        int xzRange = 10;
        int yRange = 3;
        boolean outsideBounds = this.cat.hasHomePos() ? (d0 = this.cat.getHomePos().func_177954_c((double)MathHelper.func_76128_c((double)this.cat.field_70165_t), (double)MathHelper.func_76128_c((double)this.cat.field_70163_u), (double)MathHelper.func_76128_c((double)this.cat.field_70161_v)) + 4.0) < (d1 = SCConfig.WANDER_AREA_LIMIT + (double)xzRange) * d1 : false;
        boolean flag1 = false;
        float f = -99999.0f;
        int k1 = 0;
        int i = 0;
        int j = 0;
        for (int k = 0; k < 10; ++k) {
            float f1;
            int l = random.nextInt(2 * xzRange + 1) - xzRange;
            int i1 = random.nextInt(2 * yRange + 1) - yRange;
            int j1 = random.nextInt(2 * xzRange + 1) - xzRange;
            if (this.cat.hasHomePos()) {
                BlockPos blockpos = this.cat.getHomePos();
                l = this.cat.field_70165_t > (double)blockpos.func_177958_n() ? (l -= random.nextInt(xzRange / 2)) : (l += random.nextInt(xzRange / 2));
                j1 = this.cat.field_70161_v > (double)blockpos.func_177952_p() ? (j1 -= random.nextInt(xzRange / 2)) : (j1 += random.nextInt(xzRange / 2));
            }
            BlockPos blockpos1 = new BlockPos((double)l + this.cat.field_70165_t, (double)i1 + this.cat.field_70163_u, (double)j1 + this.cat.field_70161_v);
            if (outsideBounds && !(this.cat.getHomePos().func_177951_i((Vec3i)blockpos1) < SCConfig.WANDER_AREA_LIMIT * SCConfig.WANDER_AREA_LIMIT) || !pathnavigate.func_188555_b(blockpos1) || CatAIWander.isWaterDestination(blockpos1 = CatAIWander.moveAboveSolid(blockpos1, (EntityCreature)this.cat), (EntityCreature)this.cat) || !((f1 = this.cat.func_180484_a(blockpos1)) > f)) continue;
            f = f1;
            k1 = l;
            i = i1;
            j = j1;
            flag1 = true;
        }
        if (flag1) {
            return new Vec3d((double)k1 + this.cat.field_70165_t, (double)i + this.cat.field_70163_u, (double)j + this.cat.field_70161_v);
        }
        return null;
    }

    public boolean func_75253_b() {
        return !this.cat.func_70661_as().func_75500_f();
    }

    public void func_75249_e() {
        this.cat.func_70661_as().func_75492_a(this.x, this.y, this.z, this.speed);
    }

    private static BlockPos moveAboveSolid(BlockPos blockPos, EntityCreature entityCreature) {
        if (!entityCreature.field_70170_p.func_180495_p(blockPos).func_185904_a().func_76220_a()) {
            return blockPos;
        }
        BlockPos blockpos = blockPos.func_177984_a();
        while (blockpos.func_177956_o() < entityCreature.field_70170_p.func_72800_K() && entityCreature.field_70170_p.func_180495_p(blockpos).func_185904_a().func_76220_a()) {
            blockpos = blockpos.func_177984_a();
        }
        return blockpos;
    }

    private static boolean isWaterDestination(BlockPos blockPos, EntityCreature entityCreature) {
        return entityCreature.field_70170_p.func_180495_p(blockPos).func_185904_a() == Material.field_151586_h;
    }
}

