/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structures.client;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.ldtteam.structures.blueprints.v1.Blueprint;
import com.ldtteam.structures.client.BlueprintRenderer;
import com.ldtteam.structurize.api.util.Log;
import java.util.List;
import java.util.concurrent.ExecutionException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.Vector3d;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;

public final class BlueprintRenderHandler {
    private static final BlueprintRenderHandler ourInstance = new BlueprintRenderHandler();
    private final Cache<Blueprint, BlueprintRenderer> blueprintBufferBuilderCache = CacheBuilder.newBuilder().maximumSize(50L).removalListener(notification -> ((BlueprintRenderer)notification.getValue()).getTessellator().getBuffer().func_177362_c()).build();
    private RenderManager entityRenderer;

    private BlueprintRenderHandler() {
    }

    public static BlueprintRenderHandler getInstance() {
        return ourInstance;
    }

    public void draw(Blueprint blueprint, Rotation rotation, Mirror mirror, Vector3d drawingOffset) {
        if (blueprint == null) {
            Log.getLogger().warn("Trying to draw null blueprint!");
            return;
        }
        try {
            ((BlueprintRenderer)this.blueprintBufferBuilderCache.get((Object)blueprint, () -> BlueprintRenderer.buildRendererForBlueprint(blueprint))).draw(rotation, mirror, drawingOffset);
        }
        catch (ExecutionException e) {
            Log.getLogger().error((Object)e);
        }
    }

    public void drawBlueprintAtListOfPositions(List<BlockPos> points, float partialTicks, Blueprint blueprint) {
        if (points.isEmpty()) {
            return;
        }
        EntityPlayerSP perspectiveEntity = Minecraft.func_71410_x().field_71439_g;
        double interpolatedEntityPosX = perspectiveEntity.field_70142_S + (perspectiveEntity.field_70165_t - perspectiveEntity.field_70142_S) * (double)partialTicks;
        double interpolatedEntityPosY = perspectiveEntity.field_70137_T + (perspectiveEntity.field_70163_u - perspectiveEntity.field_70137_T) * (double)partialTicks;
        double interpolatedEntityPosZ = perspectiveEntity.field_70136_U + (perspectiveEntity.field_70161_v - perspectiveEntity.field_70136_U) * (double)partialTicks;
        for (BlockPos coord : points) {
            BlockPos pos = coord.func_177977_b();
            double renderOffsetX = (double)pos.func_177958_n() - interpolatedEntityPosX;
            double renderOffsetY = (double)pos.func_177956_o() - interpolatedEntityPosY;
            double renderOffsetZ = (double)pos.func_177952_p() - interpolatedEntityPosZ;
            Vector3d renderOffset = new Vector3d();
            renderOffset.field_181059_a = renderOffsetX;
            renderOffset.field_181060_b = renderOffsetY;
            renderOffset.field_181061_c = renderOffsetZ;
            this.draw(blueprint, Rotation.NONE, Mirror.NONE, renderOffset);
        }
    }
}

