/*
 * Decompiled with CFR 0.152.
 */
package fluke.stygian.block.fluid;

import net.minecraft.block.material.Material;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class EnderFluid
extends Fluid {
    protected static int mapColor = -1;
    protected static float overlayAlpha = 0.2f;
    protected static SoundEvent emptySound = SoundEvents.field_187624_K;
    protected static SoundEvent fillSound = SoundEvents.field_187630_M;
    protected static Material material = Material.field_151586_h;
    protected boolean bucketEnabled = false;

    public EnderFluid(String fluidName, ResourceLocation still, ResourceLocation flowing) {
        super(fluidName, still, flowing);
    }

    public EnderFluid(String fluidName, ResourceLocation still, ResourceLocation flowing, int mapColor) {
        this(fluidName, still, flowing);
        this.setColor(mapColor);
    }

    public EnderFluid(String fluidName, ResourceLocation still, ResourceLocation flowing, int mapColor, float overlayAlpha) {
        this(fluidName, still, flowing, mapColor);
        this.setAlpha(overlayAlpha);
    }

    public int getColor() {
        return mapColor;
    }

    public EnderFluid setColor(int parColor) {
        mapColor = parColor;
        return this;
    }

    public float getAlpha() {
        return overlayAlpha;
    }

    public EnderFluid setAlpha(float parOverlayAlpha) {
        overlayAlpha = parOverlayAlpha;
        return this;
    }

    public EnderFluid setEmptySound(SoundEvent parSound) {
        emptySound = parSound;
        return this;
    }

    public SoundEvent getEmptySound() {
        return emptySound;
    }

    public EnderFluid setFillSound(SoundEvent parSound) {
        fillSound = parSound;
        return this;
    }

    public SoundEvent getFillSound() {
        return fillSound;
    }

    public EnderFluid setMaterial(Material parMaterial) {
        material = parMaterial;
        return this;
    }

    public Material getMaterial() {
        return material;
    }

    public boolean doesVaporize(FluidStack fluidStack) {
        if (this.block == null) {
            return false;
        }
        return this.block.func_176223_P().func_185904_a() == this.getMaterial();
    }

    public EnderFluid setHasBucket(boolean parEnableBucket) {
        this.bucketEnabled = parEnableBucket;
        return this;
    }

    public boolean isBucketEnabled() {
        return true;
    }
}

