/*
 * Decompiled with CFR 0.152.
 */
package fluke.stygian.world.feature;

import fluke.stygian.util.FastNoise;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenEndLake
extends WorldGenerator {
    private FastNoise perlin;
    private final IBlockState fluid;
    private final IBlockState rim;
    private static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();

    public WorldGenEndLake(IBlockState fluid, IBlockState rim) {
        this.fluid = fluid;
        this.rim = rim;
        this.perlin = new FastNoise();
        this.perlin.SetNoiseType(FastNoise.NoiseType.Perlin);
        this.perlin.SetFrequency(0.075f);
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        short[] lake = this.genLakeShape(world, rand, pos);
        if (lake == null) {
            return false;
        }
        for (int x = -16; x < 16; ++x) {
            for (int z = -16; z < 16; ++z) {
                int depth = lake[this.arrayIndex(x, z)];
                if (depth == -1) {
                    if (world.func_180495_p(pos.func_177982_a(x, 0, z)) != AIR) continue;
                    world.func_175656_a(pos.func_177982_a(x, 0, z), this.rim);
                    continue;
                }
                for (int d = 0; d < depth; ++d) {
                    world.func_175656_a(pos.func_177982_a(x, -d, z), this.fluid);
                }
            }
        }
        return true;
    }

    private short[] createLakeRim(short[] lake) {
        for (int x = -16; x < 16; ++x) {
            for (int z = -16; z < 16; ++z) {
                if (lake[this.arrayIndex(x, z)] <= 0) continue;
                for (int xSide = -1; xSide <= 1; ++xSide) {
                    for (int zSide = -1; zSide <= 1; ++zSide) {
                        if (!(Math.abs(xSide) == 1 ^ Math.abs(zSide) == 1) || x + xSide < -16 || x + xSide >= 16 || z + zSide < -16 || z + zSide >= 16 || lake[this.arrayIndex(x + xSide, z + zSide)] != 0) continue;
                        lake[this.arrayIndex((int)x, (int)z)] = -1;
                    }
                }
            }
        }
        return lake;
    }

    private short[] genLakeShape(World world, Random rand, BlockPos pos) {
        short[] lake = new short[1024];
        for (int n = 0; n < 1; ++n) {
            int radius;
            int posXoffset = 0;
            int posZoffset = 0;
            if (n == 0) {
                radius = 6 + rand.nextInt(4);
            } else {
                radius = 4 + rand.nextInt(3);
                posXoffset = 6 + rand.nextInt(3);
                posZoffset = 6 + rand.nextInt(3);
                if (rand.nextBoolean()) {
                    posXoffset *= -1;
                }
                if (rand.nextBoolean()) {
                    posZoffset *= -1;
                }
            }
            double maxDist = radius * radius - 1;
            double deepDist = (radius - 1) * (radius - 2) - 2;
            for (int x = -radius - 3 - posXoffset; x <= radius + 3 + posXoffset; ++x) {
                for (int z = -radius - 3 - posZoffset; z <= radius + 3 + posZoffset; ++z) {
                    if (lake[this.arrayIndex(x, z)] != 0) continue;
                    int xOffset = (int)((double)(this.perlin.GetNoise(pos.func_177958_n() + x + posXoffset * 2, pos.func_177958_n() + z + posZoffset * 2) * 4.0f) + 0.5);
                    double xDist = (x + xOffset) * (x + xOffset);
                    int zOffset = (int)((double)(this.perlin.GetNoise(pos.func_177952_p() + x + posXoffset * 2, pos.func_177952_p() + z + posZoffset * 2) * 4.0f) + 0.5);
                    double zDist = (z + zOffset) * (z + zOffset);
                    int depth = 0;
                    if (zDist + xDist < deepDist) {
                        depth = 2;
                    } else if (zDist + xDist <= maxDist) {
                        depth = 1;
                    }
                    if (depth <= 0) continue;
                    if (world.func_180495_p(pos.func_177982_a(x, -depth - 1, z)) == AIR) {
                        return null;
                    }
                    lake[this.arrayIndex((int)(x + posXoffset), (int)(z + posZoffset))] = depth;
                }
            }
        }
        return lake;
    }

    private int arrayIndex(int x, int z) {
        int arryPos = x + 16 + (z + 16) * 32;
        if (arryPos < 0) {
            return 0;
        }
        if (arryPos >= 1024) {
            return 1023;
        }
        return arryPos;
    }
}

