/*
 * Decompiled with CFR 0.152.
 */
package com.elseytd.theaurorian.Util;

import com.elseytd.theaurorian.TABlocks;
import com.elseytd.theaurorian.TAConfig;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;

public class GenerationHelper {
    public static Template getTemplate(World world, ResourceLocation structure) {
        return world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), structure);
    }

    public static boolean isNearStructure(IChunkSpecific structure, World worldIn, BlockPos pos, int range, int searchdistance) {
        int chunkX = worldIn.func_175726_f((BlockPos)pos).field_76635_g;
        int chunkZ = worldIn.func_175726_f((BlockPos)pos).field_76647_h;
        if (worldIn.field_73011_w.getDimension() == TAConfig.Config_AurorianDimID) {
            for (int x = -(searchdistance / 2); x < searchdistance / 2; ++x) {
                for (int z = -(searchdistance / 2); z < searchdistance / 2; ++z) {
                    int blocksaway;
                    if (!structure.isValidChunkForGen(chunkX + x, chunkZ + z, 0, 0) || (blocksaway = (int)pos.func_185332_f((chunkX + x) * 16, pos.func_177956_o(), (chunkZ + z) * 16)) > range) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static ChunkPos getNearestStructure(IChunkSpecific structure, EntityPlayer player, int distance) {
        int playerchunkX = player.field_70176_ah;
        int playerchunkZ = player.field_70164_aj;
        ChunkPos closest = null;
        int closestdist = 0;
        if (player.field_71093_bK == TAConfig.Config_AurorianDimID) {
            for (int x = -(distance / 2); x < distance / 2; ++x) {
                for (int z = -(distance / 2); z < distance / 2; ++z) {
                    if (!structure.isValidChunkForGen(playerchunkX + x, playerchunkZ + z, 0, 0)) continue;
                    int blocksaway = (int)player.func_70011_f((double)((playerchunkX + x) * 16), player.field_70163_u, (double)((playerchunkZ + z) * 16));
                    if (closest != null && blocksaway >= closestdist) continue;
                    closest = new ChunkPos(playerchunkX + x, playerchunkZ + z);
                    closestdist = blocksaway;
                }
            }
        }
        return closest;
    }

    public static void populateChestsInTemplate(World world, BlockPos position, Template template, PlacementSettings settings, String dataTag, ResourceLocation lootTable) {
        Map map = template.func_186258_a(position, settings);
        for (Map.Entry entry : map.entrySet()) {
            if (!dataTag.equals(entry.getValue())) continue;
            BlockPos blockpos2 = (BlockPos)entry.getKey();
            world.func_180501_a(blockpos2, Blocks.field_150350_a.func_176223_P(), 3);
            TileEntity tileentity = world.func_175625_s(blockpos2.func_177977_b());
            if (!(tileentity instanceof TileEntityChest)) continue;
            ((TileEntityChest)tileentity).func_189404_a(lootTable, world.field_73012_v.nextLong());
        }
    }

    public static boolean isTerrainFlat(World worldIn, BlockPos pos, int maximumDifference) {
        int low = 255;
        int high = 0;
        for (int x = 0; x <= 16; ++x) {
            block1: for (int z = 0; z <= 16; ++z) {
                for (int y = 190; y >= 60; --y) {
                    if (worldIn.func_180495_p(new BlockPos(pos.func_177958_n() + x, y, pos.func_177952_p() + z)).func_177230_c() != TABlocks.Registry.AURORIANGRASS.getBlock()) continue;
                    if (y >= high) {
                        high = y;
                    }
                    if (y > low) continue block1;
                    low = y;
                    continue block1;
                }
            }
        }
        return high - low <= maximumDifference;
    }

    public static interface IChunkSpecific {
        public boolean isValidChunkForGen(int var1, int var2, int var3, int var4);
    }
}

