/*
 * Decompiled with CFR 0.152.
 */
package com.elseytd.theaurorian.World.Structures;

import com.elseytd.theaurorian.TABlocks;
import com.elseytd.theaurorian.TAConfig;
import com.elseytd.theaurorian.Util.GenerationHelper;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;

public class TAWorldGenerator_DarkstoneDungeon
extends WorldGenerator
implements GenerationHelper.IChunkSpecific {
    private static final ResourceLocation DARKSTONE_LOOTTABLELOW = new ResourceLocation("theaurorian", "chests/darkstonelow");
    private static final ResourceLocation DARKSTONE_LOOTTABLEMED = new ResourceLocation("theaurorian", "chests/darkstonemed");
    private static final ResourceLocation DARKSTONE_LOOTTABLEHIGH = new ResourceLocation("theaurorian", "chests/darkstonehigh");
    private static final ResourceLocation DARKSTONE_CORNER = new ResourceLocation("theaurorian", "darkstone/darkstone_corner");
    private static final ResourceLocation DARKSTONE_STRAIGHT = new ResourceLocation("theaurorian", "darkstone/darkstone_straight");
    private static final ResourceLocation DARKSTONE_STRAIGHT_B = new ResourceLocation("theaurorian", "darkstone/darkstone_straight_b");
    private static final ResourceLocation DARKSTONE_CROSS = new ResourceLocation("theaurorian", "darkstone/darkstone_cross");
    private static final ResourceLocation DARKSTONE_END = new ResourceLocation("theaurorian", "darkstone/darkstone_end");
    private static final ResourceLocation DARKSTONE_T = new ResourceLocation("theaurorian", "darkstone/darkstone_t");
    private static final ResourceLocation DARKSTONE_STAIRS = new ResourceLocation("theaurorian", "darkstone/darkstone_stairs");
    private static final ResourceLocation DARKSTONE_ENTRANCE = new ResourceLocation("theaurorian", "darkstone/darkstone_entrance");
    private static final ResourceLocation DARKSTONE_BOSSROOM_FRONT = new ResourceLocation("theaurorian", "darkstone/darkstone_bossroom_front");
    private static final ResourceLocation DARKSTONE_BOSSROOM_FRONTRIGHT = new ResourceLocation("theaurorian", "darkstone/darkstone_bossroom_frontright");
    private static final ResourceLocation DARKSTONE_BOSSROOM_FRONTLEFT = new ResourceLocation("theaurorian", "darkstone/darkstone_bossroom_frontleft");
    private static final ResourceLocation DARKSTONE_BOSSROOM_BACK = new ResourceLocation("theaurorian", "darkstone/darkstone_bossroom_back");
    private static final ResourceLocation DARKSTONE_BOSSROOM_BACKRIGHT = new ResourceLocation("theaurorian", "darkstone/darkstone_bossroom_backright");
    private static final ResourceLocation DARKSTONE_BOSSROOM_BACKLEFT = new ResourceLocation("theaurorian", "darkstone/darkstone_bossroom_backleft");
    public static int CHUNKS_BETWEEN_DUNGEONS = TAConfig.Config_DungeonDensity * 2;
    public static boolean GENERATE_DUNGEON = TAConfig.Config_GenerateDarkstoneDungeon;
    private final String[][] map_a = new String[][]{{"AAQIH", "EOHAJ", "GIFEN", "LBGBJ", "EIKIF"}, {"GM GB", "JEIKH", "DGIFJ", "GOBCF", "EIMIB"}};
    private final String[][] map_b = new String[][]{{"GHCHA", "JSAEN", "EMKIF", "GFEMH", "DCMFD"}, {"GIMHA", "J JEN", "JJDGF", "EFGFA", "CIKIF"}};
    private final int mapWidth = 5;
    private final int mapLength = 5;
    private final int mapFloors = 2;
    private final int mapoffsetx = 6;
    private final int mapoffsetz = -2;

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        this.generateDungeon(worldIn, worldIn.func_175726_f(position));
        return true;
    }

    @Override
    public boolean isValidChunkForGen(int chunkX, int chunkZ, int offsetX, int offsetZ) {
        int offs = TAConfig.Config_DungeonDensity / 2;
        return (chunkX + offsetX + offs) % CHUNKS_BETWEEN_DUNGEONS == 0 && (chunkZ + offsetZ + offs) % CHUNKS_BETWEEN_DUNGEONS == 0;
    }

    private String[][] getMapFromDungeonHeight(int height) {
        return height % 2 == 0 ? this.map_b : this.map_a;
    }

    private void generateDungeon(World world, Chunk c) {
        int chunkX = c.field_76635_g;
        int chunkZ = c.field_76647_h;
        int x = chunkX * 16 + 8;
        int z = chunkZ * 16 + 8;
        PlacementSettings settings = new PlacementSettings().func_186225_a(TABlocks.Registry.AURORIANSTONE.getBlock());
        if (this.isValidChunkForGen(chunkX, chunkZ, 0, 0)) {
            GenerationHelper.getTemplate(world, DARKSTONE_ENTRANCE).func_186253_b(world, new BlockPos(x, this.getHeightOfDungeon(world, chunkX, chunkZ, 0, 0), z), settings);
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, 1, 0)) {
            this.createStructureFromChar('P', world, x, this.getHeightOfDungeon(world, chunkX, chunkZ, 1, 0), z, 0);
        }
        block0: for (int maplayer = 0; maplayer < this.mapFloors; ++maplayer) {
            int ix = 0;
            while (true) {
                this.getClass();
                if (ix >= 5) continue block0;
                int iz = 0;
                while (true) {
                    this.getClass();
                    if (iz >= 5) break;
                    if (this.isValidChunkForGen(chunkX, chunkZ, -ix + this.mapoffsetx, iz + this.mapoffsetz)) {
                        int y = this.getHeightOfDungeon(world, chunkX, chunkZ, -ix + this.mapoffsetx, iz + this.mapoffsetz) - 14 * (maplayer + 1);
                        String[][] mapToUse = this.getMapFromDungeonHeight(y);
                        this.createStructureFromChar(mapToUse[maplayer][ix].toCharArray()[iz], world, x, y, z, maplayer);
                    }
                    ++iz;
                }
                ++ix;
            }
        }
        this.generateBossRoom(world, chunkX, chunkZ, x, z);
    }

    private void generateBossRoom(World world, int chunkX, int chunkZ, int x, int z) {
        PlacementSettings settings = new PlacementSettings().func_186225_a(TABlocks.Registry.AURORIANSTONE.getBlock());
        int bossRoomYOffset = 28;
        if (this.isValidChunkForGen(chunkX, chunkZ, 0, 0)) {
            Template template = GenerationHelper.getTemplate(world, DARKSTONE_BOSSROOM_BACK);
            template.func_186253_b(world, new BlockPos(x, this.getHeightOfDungeon(world, chunkX, chunkZ, 0, 0) - 28, z), settings);
            GenerationHelper.populateChestsInTemplate(world, new BlockPos(x, this.getHeightOfDungeon(world, chunkX, chunkZ, 0, 0) - 28, z), template, settings, "chest", DARKSTONE_LOOTTABLEHIGH);
            return;
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, 0, 1)) {
            Template template = GenerationHelper.getTemplate(world, DARKSTONE_BOSSROOM_BACKLEFT);
            template.func_186253_b(world, new BlockPos(x, this.getHeightOfDungeon(world, chunkX, chunkZ, 0, 1) - 28, z), settings);
            return;
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, 0, -1)) {
            Template template = GenerationHelper.getTemplate(world, DARKSTONE_BOSSROOM_BACKRIGHT);
            template.func_186253_b(world, new BlockPos(x, this.getHeightOfDungeon(world, chunkX, chunkZ, 0, -1) - 28, z), settings);
            return;
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, 1, 0)) {
            Template template = GenerationHelper.getTemplate(world, DARKSTONE_BOSSROOM_FRONT);
            template.func_186253_b(world, new BlockPos(x, this.getHeightOfDungeon(world, chunkX, chunkZ, 1, 0) - 28, z), settings);
            return;
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, 1, 1)) {
            Template template = GenerationHelper.getTemplate(world, DARKSTONE_BOSSROOM_FRONTLEFT);
            template.func_186253_b(world, new BlockPos(x, this.getHeightOfDungeon(world, chunkX, chunkZ, 1, 1) - 28, z), settings);
            return;
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, 1, -1)) {
            Template template = GenerationHelper.getTemplate(world, DARKSTONE_BOSSROOM_FRONTRIGHT);
            template.func_186253_b(world, new BlockPos(x, this.getHeightOfDungeon(world, chunkX, chunkZ, 1, -1) - 28, z), settings);
            return;
        }
    }

    private int getHeightOfDungeon(World world, int xin, int zin, int chunkoffsetx, int chunkoffsetz) {
        int h = world.func_72800_K();
        int originoffsetx = 24;
        int originoffsetz = 16;
        int heightoffset = -1;
        int minimumheight = 40;
        int x = chunkoffsetx * 16 + xin * 16 + originoffsetx;
        int z = chunkoffsetz * 16 + zin * 16 + originoffsetz;
        Block blk = world.func_180495_p(new BlockPos(x, h, z)).func_177230_c();
        while ((blk == Blocks.field_150350_a || blk == TABlocks.Registry.SILENTWOODLEAVES.getBlock() || blk == TABlocks.Registry.SILENTWOODLOG.getBlock() || blk instanceof BlockBush) && h > minimumheight) {
            blk = world.func_180495_p(new BlockPos(x, --h, z)).func_177230_c();
        }
        return h + heightoffset;
    }

    private void createStructureFromChar(char c, World world, int x, int y, int z, int floorForLootRarity) {
        PlacementSettings settings = new PlacementSettings().func_186225_a(TABlocks.Registry.AURORIANSTONE.getBlock());
        ResourceLocation loot = floorForLootRarity == 0 ? DARKSTONE_LOOTTABLELOW : DARKSTONE_LOOTTABLEMED;
        boolean populateChests = false;
        Template template = null;
        int placementx = x;
        int placementy = y;
        int placementz = z;
        switch (c) {
            case ' ': {
                return;
            }
            case 'K': {
                template = GenerationHelper.getTemplate(world, DARKSTONE_CROSS);
                populateChests = true;
                break;
            }
            case 'E': {
                template = GenerationHelper.getTemplate(world, DARKSTONE_CORNER);
                break;
            }
            case 'F': {
                template = GenerationHelper.getTemplate(world, DARKSTONE_CORNER);
                settings.func_186220_a(Rotation.COUNTERCLOCKWISE_90);
                placementz += 15;
                break;
            }
            case 'G': {
                template = GenerationHelper.getTemplate(world, DARKSTONE_CORNER);
                settings.func_186220_a(Rotation.CLOCKWISE_90);
                placementx += 15;
                break;
            }
            case 'H': {
                template = GenerationHelper.getTemplate(world, DARKSTONE_CORNER);
                settings.func_186220_a(Rotation.CLOCKWISE_180);
                placementz += 15;
                placementx += 15;
                break;
            }
            case 'I': {
                boolean variant = world.field_73012_v.nextBoolean();
                populateChests = variant;
                template = GenerationHelper.getTemplate(world, variant ? DARKSTONE_STRAIGHT : DARKSTONE_STRAIGHT_B);
                break;
            }
            case 'J': {
                boolean variant2 = world.field_73012_v.nextBoolean();
                populateChests = variant2;
                template = GenerationHelper.getTemplate(world, variant2 ? DARKSTONE_STRAIGHT : DARKSTONE_STRAIGHT_B);
                settings.func_186220_a(Rotation.COUNTERCLOCKWISE_90);
                placementz += 15;
                break;
            }
            case 'A': {
                template = GenerationHelper.getTemplate(world, DARKSTONE_END);
                populateChests = true;
                break;
            }
            case 'B': {
                template = GenerationHelper.getTemplate(world, DARKSTONE_END);
                settings.func_186220_a(Rotation.CLOCKWISE_90);
                placementx += 15;
                populateChests = true;
                break;
            }
            case 'C': {
                template = GenerationHelper.getTemplate(world, DARKSTONE_END);
                settings.func_186220_a(Rotation.COUNTERCLOCKWISE_90);
                placementz += 15;
                populateChests = true;
                break;
            }
            case 'D': {
                template = GenerationHelper.getTemplate(world, DARKSTONE_END);
                settings.func_186220_a(Rotation.CLOCKWISE_180);
                placementz += 15;
                placementx += 15;
                populateChests = true;
                break;
            }
            case 'L': {
                template = GenerationHelper.getTemplate(world, DARKSTONE_T);
                break;
            }
            case 'M': {
                template = GenerationHelper.getTemplate(world, DARKSTONE_T);
                settings.func_186220_a(Rotation.CLOCKWISE_90);
                placementx += 15;
                break;
            }
            case 'N': {
                template = GenerationHelper.getTemplate(world, DARKSTONE_T);
                settings.func_186220_a(Rotation.CLOCKWISE_180);
                placementz += 15;
                placementx += 15;
                break;
            }
            case 'O': {
                template = GenerationHelper.getTemplate(world, DARKSTONE_T);
                settings.func_186220_a(Rotation.COUNTERCLOCKWISE_90);
                placementz += 15;
                break;
            }
            case 'P': {
                template = GenerationHelper.getTemplate(world, DARKSTONE_STAIRS);
                placementy -= 14;
                break;
            }
            case 'Q': {
                template = GenerationHelper.getTemplate(world, DARKSTONE_STAIRS);
                settings.func_186220_a(Rotation.COUNTERCLOCKWISE_90);
                placementz += 15;
                placementy -= 14;
                break;
            }
            case 'R': {
                template = GenerationHelper.getTemplate(world, DARKSTONE_STAIRS);
                settings.func_186220_a(Rotation.CLOCKWISE_90);
                placementx += 15;
                placementy -= 14;
                break;
            }
            case 'S': {
                template = GenerationHelper.getTemplate(world, DARKSTONE_STAIRS);
                settings.func_186220_a(Rotation.CLOCKWISE_180);
                placementz += 15;
                placementx += 15;
                placementy -= 14;
            }
        }
        if (template != null) {
            BlockPos position = new BlockPos(placementx, placementy, placementz);
            template.func_186253_b(world, position, settings);
            if (populateChests && loot != null) {
                GenerationHelper.populateChestsInTemplate(world, position, template, settings, "chest", loot);
            }
        }
    }
}

