/*
 * Decompiled with CFR 0.152.
 */
package com.elseytd.theaurorian.World.Structures;

import com.elseytd.theaurorian.TABlocks;
import com.elseytd.theaurorian.TAConfig;
import com.elseytd.theaurorian.Util.GenerationHelper;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;

public class TAWorldGenerator_MoonTemple
extends WorldGenerator
implements GenerationHelper.IChunkSpecific {
    private static final ResourceLocation MOONTEMPLE_LOOTTABLE_LOW = new ResourceLocation("theaurorian", "chests/moontemplelow");
    private static final ResourceLocation MOONTEMPLE_LOOTTABLE_MED = new ResourceLocation("theaurorian", "chests/moontemplemed");
    private static final ResourceLocation MOONTEMPLE_TERRAIN = new ResourceLocation("theaurorian", "moontemple/moontemple_terrain");
    private static final ResourceLocation MOONTEMPLE_COURTYARD = new ResourceLocation("theaurorian", "moontemple/moontemplev2_courtyard");
    private static final ResourceLocation MOONTEMPLE_COURTYARD_LEFT = new ResourceLocation("theaurorian", "moontemple/moontemplev2_courtyardl");
    private static final ResourceLocation MOONTEMPLE_COURTYARD_RIGHT = new ResourceLocation("theaurorian", "moontemple/moontemplev2_courtyardr");
    private static final ResourceLocation MOONTEMPLE_CENTER = new ResourceLocation("theaurorian", "moontemple/moontemplev2_center");
    private static final ResourceLocation MOONTEMPLE_TOWER_LEFT = new ResourceLocation("theaurorian", "moontemple/moontemplev2_left");
    private static final ResourceLocation MOONTEMPLE_TOWER_RIGHT = new ResourceLocation("theaurorian", "moontemple/moontemplev2_right");
    private static final ResourceLocation MOONTEMPLE_ROOM = new ResourceLocation("theaurorian", "moontemple/moontemplev2_room");
    private static final ResourceLocation MOONTEMPLE_ISLAND = new ResourceLocation("theaurorian", "moontemple/moontemple_island");
    private static final ResourceLocation MOONTEMPLE_PATH_TURN = new ResourceLocation("theaurorian", "moontemple/moontemple_path_turn");
    private static final ResourceLocation MOONTEMPLE_PATH_STRAIGHT = new ResourceLocation("theaurorian", "moontemple/moontemple_path_straight");
    public static int CHUNKS_BETWEEN_TEMPLES = TAConfig.Config_DungeonDensity * 4;
    public static boolean GENERATE_TEMPLES = TAConfig.Config_GenerateMoonTemple;
    public static boolean GENERATE_TEMPLES_PATH = TAConfig.Config_GenerateMoonTemplePath;

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        this.generateTemple(worldIn, worldIn.func_175726_f(position), 200);
        return true;
    }

    private void populateChests(World world, BlockPos pos, Template template, PlacementSettings settings) {
        GenerationHelper.populateChestsInTemplate(world, pos, template, settings, "chest_low", MOONTEMPLE_LOOTTABLE_LOW);
        GenerationHelper.populateChestsInTemplate(world, pos, template, settings, "chest_med", MOONTEMPLE_LOOTTABLE_MED);
    }

    @Override
    public boolean isValidChunkForGen(int chunkX, int chunkZ, int offsetX, int offsetZ) {
        int offs = TAConfig.Config_DungeonDensity + TAConfig.Config_DungeonDensity / 2;
        return (chunkX + offsetX + offs) % CHUNKS_BETWEEN_TEMPLES == 0 && (chunkZ + offsetZ + offs) % CHUNKS_BETWEEN_TEMPLES == 0;
    }

    private void generateTemple(World world, Chunk c, int height) {
        Template temple_tower;
        int chunkX = c.field_76635_g;
        int chunkZ = c.field_76647_h;
        BlockPos position = new BlockPos(chunkX * 16 + 8, height, chunkZ * 16 + 8);
        PlacementSettings settings = new PlacementSettings().func_186225_a(TABlocks.Registry.AURORIANSTONE.getBlock());
        if (this.isValidChunkForGen(chunkX, chunkZ, 0, 0)) {
            Template temple_center = GenerationHelper.getTemplate(world, MOONTEMPLE_CENTER);
            temple_center.func_186253_b(world, position, settings);
            this.populateChests(world, position, temple_center, settings);
            GenerationHelper.getTemplate(world, MOONTEMPLE_TERRAIN).func_186253_b(world, position.func_177979_c(12), settings);
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, -1, 0)) {
            temple_tower = GenerationHelper.getTemplate(world, MOONTEMPLE_TOWER_LEFT);
            temple_tower.func_186253_b(world, position, settings);
            this.populateChests(world, position, temple_tower, settings);
            GenerationHelper.getTemplate(world, MOONTEMPLE_TERRAIN).func_186253_b(world, position.func_177979_c(12), settings);
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, 1, 0)) {
            temple_tower = GenerationHelper.getTemplate(world, MOONTEMPLE_TOWER_RIGHT);
            temple_tower.func_186253_b(world, position, settings);
            this.populateChests(world, position, temple_tower, settings);
            GenerationHelper.getTemplate(world, MOONTEMPLE_TERRAIN).func_186253_b(world, position.func_177979_c(12), settings);
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, 0, 1)) {
            GenerationHelper.getTemplate(world, MOONTEMPLE_COURTYARD).func_186253_b(world, position, settings);
            GenerationHelper.getTemplate(world, MOONTEMPLE_TERRAIN).func_186253_b(world, position.func_177979_c(12), settings);
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, -1, 1)) {
            GenerationHelper.getTemplate(world, MOONTEMPLE_COURTYARD_LEFT).func_186253_b(world, position, settings);
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, 1, 1)) {
            GenerationHelper.getTemplate(world, MOONTEMPLE_COURTYARD_RIGHT).func_186253_b(world, position, settings);
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, 0, -1)) {
            Template temple_room = GenerationHelper.getTemplate(world, MOONTEMPLE_ROOM);
            temple_room.func_186253_b(world, position, settings);
            this.populateChests(world, position, temple_room, settings);
            GenerationHelper.getTemplate(world, MOONTEMPLE_TERRAIN).func_186253_b(world, position.func_177979_c(12), settings);
        }
        this.genIslands(world, chunkX, chunkZ, position, world.field_73012_v);
        if (GENERATE_TEMPLES_PATH) {
            this.genSpiralPath(world, chunkX, chunkZ, position.func_177958_n(), position.func_177956_o(), position.func_177952_p());
        }
    }

    private void genIslands(World world, int chunkX, int chunkZ, BlockPos position, Random rand) {
        if (this.isValidChunkForGen(chunkX, chunkZ, -1, -3)) {
            GenerationHelper.getTemplate(world, MOONTEMPLE_ISLAND).func_189962_a(world, position.func_177979_c(27 + rand.nextInt(10)), new PlacementSettings().func_186225_a(Blocks.field_150350_a), 3);
            return;
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, 1, -3)) {
            GenerationHelper.getTemplate(world, MOONTEMPLE_ISLAND).func_189962_a(world, position.func_177979_c(27 + rand.nextInt(10)), new PlacementSettings().func_186225_a(Blocks.field_150350_a), 3);
            return;
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, -1, 3)) {
            GenerationHelper.getTemplate(world, MOONTEMPLE_ISLAND).func_189962_a(world, position.func_177979_c(27 + rand.nextInt(10)), new PlacementSettings().func_186225_a(Blocks.field_150350_a), 3);
            return;
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, 1, 3)) {
            GenerationHelper.getTemplate(world, MOONTEMPLE_ISLAND).func_189962_a(world, position.func_177979_c(27 + rand.nextInt(10)), new PlacementSettings().func_186225_a(Blocks.field_150350_a), 3);
            return;
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, -3, -1)) {
            GenerationHelper.getTemplate(world, MOONTEMPLE_ISLAND).func_189962_a(world, position.func_177979_c(27 + rand.nextInt(10)), new PlacementSettings().func_186225_a(Blocks.field_150350_a), 3);
            return;
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, -3, 1)) {
            GenerationHelper.getTemplate(world, MOONTEMPLE_ISLAND).func_189962_a(world, position.func_177979_c(27 + rand.nextInt(10)), new PlacementSettings().func_186225_a(Blocks.field_150350_a), 3);
            return;
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, 3, -1)) {
            GenerationHelper.getTemplate(world, MOONTEMPLE_ISLAND).func_189962_a(world, position.func_177979_c(27 + rand.nextInt(10)), new PlacementSettings().func_186225_a(Blocks.field_150350_a), 3);
            return;
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, 3, 1)) {
            GenerationHelper.getTemplate(world, MOONTEMPLE_ISLAND).func_189962_a(world, position.func_177979_c(27 + rand.nextInt(10)), new PlacementSettings().func_186225_a(Blocks.field_150350_a), 3);
            return;
        }
    }

    private void genSpiralPath(World world, int chunkX, int chunkZ, int x, int y, int z) {
        int height = y - 1;
        int yoffset = 7;
        if (this.isValidChunkForGen(chunkX, chunkZ, 0, 2)) {
            GenerationHelper.getTemplate(world, MOONTEMPLE_PATH_TURN).func_186253_b(world, new BlockPos(x, height - 7, z), new PlacementSettings().func_186225_a(Blocks.field_150350_a));
            GenerationHelper.getTemplate(world, MOONTEMPLE_PATH_STRAIGHT).func_186253_b(world, new BlockPos(x, height - 119, z), new PlacementSettings().func_186225_a(Blocks.field_150350_a));
            return;
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, 1, 2)) {
            GenerationHelper.getTemplate(world, MOONTEMPLE_PATH_STRAIGHT).func_186253_b(world, new BlockPos(x, height - 14, z), new PlacementSettings().func_186225_a(Blocks.field_150350_a));
            GenerationHelper.getTemplate(world, MOONTEMPLE_PATH_STRAIGHT).func_186253_b(world, new BlockPos(x, height - 126, z), new PlacementSettings().func_186225_a(Blocks.field_150350_a));
            return;
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, 2, 2)) {
            GenerationHelper.getTemplate(world, MOONTEMPLE_PATH_TURN).func_186253_b(world, new BlockPos(x, height - 21, z + 15), new PlacementSettings().func_186220_a(Rotation.COUNTERCLOCKWISE_90).func_186225_a(Blocks.field_150350_a));
            return;
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, 2, 1)) {
            GenerationHelper.getTemplate(world, MOONTEMPLE_PATH_STRAIGHT).func_186253_b(world, new BlockPos(x, height - 28, z + 15), new PlacementSettings().func_186220_a(Rotation.COUNTERCLOCKWISE_90).func_186225_a(Blocks.field_150350_a));
            return;
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, 2, 0)) {
            GenerationHelper.getTemplate(world, MOONTEMPLE_PATH_STRAIGHT).func_186253_b(world, new BlockPos(x, height - 35, z + 15), new PlacementSettings().func_186220_a(Rotation.COUNTERCLOCKWISE_90).func_186225_a(Blocks.field_150350_a));
            return;
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, 2, -1)) {
            GenerationHelper.getTemplate(world, MOONTEMPLE_PATH_STRAIGHT).func_186253_b(world, new BlockPos(x, height - 42, z + 15), new PlacementSettings().func_186220_a(Rotation.COUNTERCLOCKWISE_90).func_186225_a(Blocks.field_150350_a));
            return;
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, 2, -2)) {
            GenerationHelper.getTemplate(world, MOONTEMPLE_PATH_TURN).func_186253_b(world, new BlockPos(x + 15, height - 49, z + 15), new PlacementSettings().func_186220_a(Rotation.CLOCKWISE_180).func_186225_a(Blocks.field_150350_a));
            return;
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, 1, -2)) {
            GenerationHelper.getTemplate(world, MOONTEMPLE_PATH_STRAIGHT).func_186253_b(world, new BlockPos(x + 15, height - 56, z + 15), new PlacementSettings().func_186220_a(Rotation.CLOCKWISE_180).func_186225_a(Blocks.field_150350_a));
            return;
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, 0, -2)) {
            GenerationHelper.getTemplate(world, MOONTEMPLE_PATH_STRAIGHT).func_186253_b(world, new BlockPos(x + 15, height - 63, z + 15), new PlacementSettings().func_186220_a(Rotation.CLOCKWISE_180).func_186225_a(Blocks.field_150350_a));
            return;
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, -1, -2)) {
            GenerationHelper.getTemplate(world, MOONTEMPLE_PATH_STRAIGHT).func_186253_b(world, new BlockPos(x + 15, height - 70, z + 15), new PlacementSettings().func_186220_a(Rotation.CLOCKWISE_180).func_186225_a(Blocks.field_150350_a));
            return;
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, -2, -2)) {
            GenerationHelper.getTemplate(world, MOONTEMPLE_PATH_TURN).func_186253_b(world, new BlockPos(x + 15, height - 77, z), new PlacementSettings().func_186220_a(Rotation.CLOCKWISE_90).func_186225_a(Blocks.field_150350_a));
            return;
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, -2, -1)) {
            GenerationHelper.getTemplate(world, MOONTEMPLE_PATH_STRAIGHT).func_186253_b(world, new BlockPos(x + 15, height - 84, z), new PlacementSettings().func_186220_a(Rotation.CLOCKWISE_90).func_186225_a(Blocks.field_150350_a));
            return;
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, -2, 0)) {
            GenerationHelper.getTemplate(world, MOONTEMPLE_PATH_STRAIGHT).func_186253_b(world, new BlockPos(x + 15, height - 91, z), new PlacementSettings().func_186220_a(Rotation.CLOCKWISE_90).func_186225_a(Blocks.field_150350_a));
            return;
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, -2, 1)) {
            GenerationHelper.getTemplate(world, MOONTEMPLE_PATH_STRAIGHT).func_186253_b(world, new BlockPos(x + 15, height - 98, z), new PlacementSettings().func_186220_a(Rotation.CLOCKWISE_90).func_186225_a(Blocks.field_150350_a));
            return;
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, -2, 2)) {
            GenerationHelper.getTemplate(world, MOONTEMPLE_PATH_TURN).func_186253_b(world, new BlockPos(x, height - 105, z), new PlacementSettings().func_186225_a(Blocks.field_150350_a));
            return;
        }
        if (this.isValidChunkForGen(chunkX, chunkZ, -1, 2)) {
            GenerationHelper.getTemplate(world, MOONTEMPLE_PATH_STRAIGHT).func_186253_b(world, new BlockPos(x, height - 112, z), new PlacementSettings().func_186225_a(Blocks.field_150350_a));
            return;
        }
    }
}

